/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallInternalServiceSettings;

public class MultilingualE5SmallModel
extends ElasticsearchInternalModel {
    public static final int E5_SMALL_MAX_WINDOW_SIZE = 300;

    public MultilingualE5SmallModel(String inferenceEntityId, TaskType taskType, String service, MultilingualE5SmallInternalServiceSettings serviceSettings, ChunkingSettings chunkingSettings) {
        super(inferenceEntityId, taskType, service, (ElasticsearchInternalServiceSettings)serviceSettings, chunkingSettings);
        if (chunkingSettings != null && chunkingSettings.maxChunkSize() != null && chunkingSettings.maxChunkSize() > 300) {
            throw new IllegalArgumentException(serviceSettings.modelId() + " does not support chunk sizes larger than 300. Requested chunk size: " + chunkingSettings.maxChunkSize());
        }
    }

    @Override
    public MultilingualE5SmallInternalServiceSettings getServiceSettings() {
        return (MultilingualE5SmallInternalServiceSettings)super.getServiceSettings();
    }
}

