/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion;

import java.util.Collection;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockConverseUtils;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.Message;

public final class AmazonBedrockConverseRequestUtils {
    public static ConverseRequest getConverseRequest(String modelId, AmazonBedrockConverseRequestEntity requestEntity) {
        ConverseRequest.Builder converseRequest = ConverseRequest.builder().modelId(modelId).messages(AmazonBedrockConverseUtils.getConverseMessageList(requestEntity.messages())).additionalModelResponseFieldPaths(requestEntity.additionalModelFields());
        AmazonBedrockConverseUtils.inferenceConfig(requestEntity).ifPresent(arg_0 -> ((ConverseRequest.Builder)converseRequest).inferenceConfig(arg_0));
        return (ConverseRequest)converseRequest.build();
    }

    public static boolean doesConverseRequestHasMessage(ConverseRequest converseRequest, String expectedMessage) {
        if (expectedMessage == null) {
            return false;
        }
        return converseRequest.messages().stream().map(Message::content).flatMap(Collection::stream).map(ContentBlock::text).anyMatch(expectedMessage::equals);
    }

    public static boolean doesConverseRequestHaveAnyTemperatureInput(ConverseRequest converseRequest) {
        return converseRequest.inferenceConfig() != null && converseRequest.inferenceConfig().temperature() != null && !converseRequest.inferenceConfig().temperature().isNaN();
    }

    public static boolean doesConverseRequestHaveAnyTopPInput(ConverseRequest converseRequest) {
        return converseRequest.inferenceConfig() != null && converseRequest.inferenceConfig().topP() != null && !converseRequest.inferenceConfig().topP().isNaN();
    }

    public static boolean doesConverseRequestHaveAnyMaxTokensInput(ConverseRequest converseRequest) {
        return converseRequest.inferenceConfig() != null && converseRequest.inferenceConfig().maxTokens() != null;
    }

    public static boolean doesConverseRequestHaveTemperatureInput(ConverseRequest converseRequest, Double temperature) {
        return AmazonBedrockConverseRequestUtils.doesConverseRequestHaveAnyTemperatureInput(converseRequest) && converseRequest.inferenceConfig().temperature().equals(Float.valueOf(temperature.floatValue()));
    }

    public static boolean doesConverseRequestHaveTopPInput(ConverseRequest converseRequest, Double topP) {
        return AmazonBedrockConverseRequestUtils.doesConverseRequestHaveAnyTopPInput(converseRequest) && converseRequest.inferenceConfig().topP().equals(Float.valueOf(topP.floatValue()));
    }

    public static boolean doesConverseRequestHaveMaxTokensInput(ConverseRequest converseRequest, Integer maxTokens) {
        return AmazonBedrockConverseRequestUtils.doesConverseRequestHaveAnyMaxTokensInput(converseRequest) && converseRequest.inferenceConfig().maxTokens().equals(maxTokens);
    }

    public static boolean doesConverseRequestHaveAnyTopKInput(ConverseRequest converseRequest) {
        if (converseRequest.additionalModelResponseFieldPaths() == null) {
            return false;
        }
        for (String fieldPath : converseRequest.additionalModelResponseFieldPaths()) {
            if (!fieldPath.contains("{\"top_k\":")) continue;
            return true;
        }
        return false;
    }

    public static boolean doesConverseRequestHaveTopKInput(ConverseRequest converseRequest, Double topK) {
        if (!AmazonBedrockConverseRequestUtils.doesConverseRequestHaveAnyTopKInput(converseRequest)) {
            return false;
        }
        String checkString = Strings.format((String)"{\"top_k\":%f}", (Object[])new Object[]{Float.valueOf(topK.floatValue())});
        for (String fieldPath : converseRequest.additionalModelResponseFieldPaths()) {
            if (!fieldPath.contains(checkString)) continue;
            return true;
        }
        return false;
    }
}

