/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.SizeLimitInputStream;
import org.elasticsearch.xpack.inference.external.http.HttpClient;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.StreamingHttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.retry.Retryable;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class RetryingHttpSender
implements RequestSender {
    public static final int MAX_RETIES = 3;
    private final HttpClient httpClient;
    private final ThrottlerManager throttlerManager;
    private final RetrySettings retrySettings;
    private final ThreadPool threadPool;
    private final Executor executor;

    public RetryingHttpSender(HttpClient httpClient, ThrottlerManager throttlerManager, RetrySettings retrySettings, ThreadPool threadPool) {
        this(httpClient, throttlerManager, retrySettings, threadPool, threadPool.executor("inference_utility"));
    }

    RetryingHttpSender(HttpClient httpClient, ThrottlerManager throttlerManager, RetrySettings retrySettings, ThreadPool threadPool, Executor executor) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.throttlerManager = Objects.requireNonNull(throttlerManager);
        this.retrySettings = Objects.requireNonNull(retrySettings);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public void send(Logger logger, Request request, Supplier<Boolean> hasRequestTimedOutFunction, ResponseHandler responseHandler, ActionListener<InferenceServiceResults> listener) {
        InternalRetrier retrier = new InternalRetrier(logger, request, HttpClientContext.create(), hasRequestTimedOutFunction, responseHandler, listener);
        retrier.run();
    }

    private void logException(Logger logger, Request request, String requestType, Exception exception) {
        Throwable causeException = ExceptionsHelper.unwrapCause((Throwable)exception);
        this.throttlerManager.warn(logger, Strings.format((String)"Failed while sending request from inference entity id [%s] of type [%s]", (Object[])new Object[]{request.getInferenceEntityId(), requestType}), causeException);
    }

    private void logException(Logger logger, Request request, HttpResult result, String requestType, Exception exception) {
        Throwable causeException = ExceptionsHelper.unwrapCause((Throwable)exception);
        this.throttlerManager.warn(logger, Strings.format((String)"Failed to process the response for request from inference entity id [%s] of type [%s] with status [%s] [%s]", (Object[])new Object[]{request.getInferenceEntityId(), requestType, result.response().getStatusLine().getStatusCode(), result.response().getStatusLine().getReasonPhrase()}), causeException);
    }

    private class InternalRetrier
    extends RetryableAction<InferenceServiceResults> {
        private Request request;
        private final ResponseHandler responseHandler;
        private final Logger logger;
        private final HttpClientContext context;
        private final Supplier<Boolean> hasRequestCompletedFunction;
        private final AtomicInteger retryCount;

        InternalRetrier(Logger logger, Request request, HttpClientContext context, Supplier<Boolean> hasRequestCompletedFunction, ResponseHandler responseHandler, ActionListener<InferenceServiceResults> listener) {
            super(Objects.requireNonNull(logger), RetryingHttpSender.this.threadPool, RetryingHttpSender.this.retrySettings.getInitialDelay(), RetryingHttpSender.this.retrySettings.getMaxDelayBound(), RetryingHttpSender.this.retrySettings.getTimeout(), listener, RetryingHttpSender.this.executor);
            this.logger = logger;
            this.request = Objects.requireNonNull(request);
            this.context = Objects.requireNonNull(context);
            this.responseHandler = Objects.requireNonNull(responseHandler);
            this.hasRequestCompletedFunction = Objects.requireNonNull(hasRequestCompletedFunction);
            this.retryCount = new AtomicInteger(0);
        }

        public void tryAction(ActionListener<InferenceServiceResults> listener) {
            this.retryCount.incrementAndGet();
            if (this.hasRequestCompletedFunction.get().booleanValue()) {
                return;
            }
            ActionListener retryableListener = listener.delegateResponse((l, e) -> {
                RetryingHttpSender.this.logException(this.logger, this.request, this.responseHandler.getRequestType(), (Exception)e);
                l.onFailure(this.transformIfRetryable((Exception)e));
            });
            try {
                if (this.request.isStreaming() && this.responseHandler.canHandleStreamingResponses()) {
                    RetryingHttpSender.this.httpClient.stream(this.request.createHttpRequest(), (HttpContext)this.context, (ActionListener<StreamingHttpResult>)retryableListener.delegateFailure((l, r) -> {
                        if (r.isSuccessfulResponse()) {
                            l.onResponse((Object)this.responseHandler.parseResult(this.request, r.toHttpResult()));
                        } else {
                            r.readFullResponse((ActionListener<HttpResult>)l.delegateFailureAndWrap((ll, httpResult) -> {
                                try {
                                    this.responseHandler.validateResponse(RetryingHttpSender.this.throttlerManager, this.logger, this.request, (HttpResult)httpResult);
                                    InferenceServiceResults inferenceResults = this.responseHandler.parseResult(this.request, (HttpResult)httpResult);
                                    ll.onResponse((Object)inferenceResults);
                                }
                                catch (Exception e) {
                                    RetryingHttpSender.this.logException(this.logger, this.request, (HttpResult)httpResult, this.responseHandler.getRequestType(), e);
                                    listener.onFailure(e);
                                }
                            }));
                        }
                    }));
                } else {
                    RetryingHttpSender.this.httpClient.send(this.request.createHttpRequest(), this.context, (ActionListener<HttpResult>)retryableListener.delegateFailure((l, r) -> {
                        try {
                            this.responseHandler.validateResponse(RetryingHttpSender.this.throttlerManager, this.logger, this.request, (HttpResult)r);
                            InferenceServiceResults inferenceResults = this.responseHandler.parseResult(this.request, (HttpResult)r);
                            l.onResponse((Object)inferenceResults);
                        }
                        catch (Exception e) {
                            RetryingHttpSender.this.logException(this.logger, this.request, (HttpResult)r, this.responseHandler.getRequestType(), e);
                            listener.onFailure(e);
                        }
                    }));
                }
            }
            catch (Exception e2) {
                RetryingHttpSender.this.logException(this.logger, this.request, this.responseHandler.getRequestType(), e2);
                listener.onFailure(this.wrapWithElasticsearchException(e2, this.request.getInferenceEntityId()));
            }
        }

        private Exception transformIfRetryable(Exception e) {
            Exception exceptionToReturn = e;
            if (e instanceof UnknownHostException) {
                return new ElasticsearchStatusException(Strings.format((String)"Invalid host [%s], please check that the URL is correct.", (Object[])new Object[]{this.request.getURI()}), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
            }
            if (e instanceof SizeLimitInputStream.InputStreamTooLargeException) {
                return e;
            }
            if (e instanceof IOException) {
                return new RetryException(true, e);
            }
            return exceptionToReturn;
        }

        private Exception wrapWithElasticsearchException(Exception e, String inferenceEntityId) {
            Exception transformedException = this.transformIfRetryable(e);
            if (transformedException instanceof ElasticsearchException) {
                return transformedException;
            }
            return new ElasticsearchException(Strings.format((String)"Http client failed to send request from inference entity id [%s]", (Object[])new Object[]{inferenceEntityId}), (Throwable)transformedException, new Object[0]);
        }

        public boolean shouldRetry(Exception e) {
            if (this.retryCount.get() >= 3) {
                return false;
            }
            if (e instanceof Retryable) {
                Retryable retry = (Retryable)((Object)e);
                this.request = retry.rebuildRequest(this.request);
                return retry.shouldRetry();
            }
            return false;
        }
    }
}

