/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutDatafeedAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}"));
    }

    public String getName() {
        return "ml_put_datafeed_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutDatafeedAction.Request putDatafeedRequest;
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        IndicesOptions indicesOptions = IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)SearchRequest.DEFAULT_INDICES_OPTIONS);
        try (XContentParser parser = restRequest.contentParser();){
            putDatafeedRequest = PutDatafeedAction.Request.parseRequest((String)datafeedId, (IndicesOptions)indicesOptions, (XContentParser)parser);
        }
        putDatafeedRequest.ackTimeout(RestUtils.getAckTimeout((RestRequest)restRequest));
        putDatafeedRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        return channel -> client.execute((ActionType)PutDatafeedAction.INSTANCE, (ActionRequest)putDatafeedRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

