/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;

abstract class ForkingResponseHandlerRunnable
extends AbstractRunnable {
    private static final Logger logger = LogManager.getLogger(ForkingResponseHandlerRunnable.class);
    private final TransportResponseHandler<?> handler;
    @Nullable
    private final TransportException transportException;

    ForkingResponseHandlerRunnable(TransportResponseHandler<?> handler, @Nullable TransportException transportException) {
        this(handler, transportException, handler.executor());
    }

    ForkingResponseHandlerRunnable(TransportResponseHandler<?> handler, @Nullable TransportException transportException, Executor executorUsed) {
        assert (executorUsed != EsExecutors.DIRECT_EXECUTOR_SERVICE) : "forking handler required, but got " + String.valueOf(handler);
        this.handler = handler;
        this.transportException = transportException;
    }

    @Override
    protected abstract void doRun();

    @Override
    public boolean isForceExecution() {
        return true;
    }

    @Override
    public void onRejection(Exception e) {
        TransportException exceptionToDeliver;
        assert (false) : e;
        if (this.transportException == null) {
            exceptionToDeliver = new RemoteTransportException(e.getMessage(), e);
        } else {
            exceptionToDeliver = this.transportException;
            exceptionToDeliver.addSuppressed(e);
        }
        try {
            this.handler.handleException(exceptionToDeliver);
        }
        catch (Exception e2) {
            exceptionToDeliver.addSuppressed(e2);
            logger.error(() -> Strings.format((String)"%s [%s]", (Object[])new Object[]{this.transportException == null ? "failed to handle rejection of response" : "failed to handle rejection of error response", this.handler}), (Throwable)exceptionToDeliver);
        }
    }

    @Override
    public void onFailure(Exception e) {
        assert (false) : e;
        logger.error(() -> Strings.format((String)"%s [%s]", (Object[])new Object[]{this.transportException == null ? "failed to handle rejection of response" : "failed to handle rejection of error response", this.handler}), (Throwable)e);
    }
}

