/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class MergeMetrics {
    public static final String MERGE_SEGMENTS_SIZE = "es.merge.segments.size";
    public static final String MERGE_DOCS_TOTAL = "es.merge.docs.total";
    public static final String MERGE_SEGMENTS_QUEUED_USAGE = "es.merge.segments.queued.usage";
    public static final String MERGE_SEGMENTS_RUNNING_USAGE = "es.merge.segments.running.usage";
    public static final String MERGE_SEGMENTS_MERGED_SIZE = "es.merge.segments.merged.size";
    public static final String MERGE_QUEUED_ESTIMATED_MEMORY_SIZE = "es.merge.segments.memory.size";
    public static final String MERGE_TIME_IN_SECONDS = "es.merge.time";
    public static MergeMetrics NOOP = new MergeMetrics(TelemetryProvider.NOOP.getMeterRegistry());
    private final LongCounter mergeSizeInBytes;
    private final LongCounter mergeMergedSegmentSizeInBytes;
    private final LongCounter mergeNumDocs;
    private final LongHistogram mergeTimeInSeconds;
    private final AtomicLong runningMergeSizeInBytes = new AtomicLong();
    private final AtomicLong queuedMergeSizeInBytes = new AtomicLong();
    private final AtomicLong queuedEstimatedMergeMemoryInBytes = new AtomicLong();

    public MergeMetrics(MeterRegistry meterRegistry) {
        this.mergeSizeInBytes = meterRegistry.registerLongCounter(MERGE_SEGMENTS_SIZE, "Total size of segments merged", "bytes");
        meterRegistry.registerLongGauge(MERGE_SEGMENTS_QUEUED_USAGE, "Total usage of segments queued to be merged", "bytes", () -> new LongWithAttributes(this.queuedMergeSizeInBytes.get()));
        meterRegistry.registerLongGauge(MERGE_SEGMENTS_RUNNING_USAGE, "Total usage of segments currently being merged", "bytes", () -> new LongWithAttributes(this.runningMergeSizeInBytes.get()));
        this.mergeMergedSegmentSizeInBytes = meterRegistry.registerLongCounter(MERGE_SEGMENTS_MERGED_SIZE, "Total size of the new merged segments", "bytes");
        this.mergeNumDocs = meterRegistry.registerLongCounter(MERGE_DOCS_TOTAL, "Total number of documents merged", "documents");
        this.mergeTimeInSeconds = meterRegistry.registerLongHistogram(MERGE_TIME_IN_SECONDS, "Merge time in seconds", "seconds");
        meterRegistry.registerLongGauge(MERGE_QUEUED_ESTIMATED_MEMORY_SIZE, "Estimated memory usage for queued merges", "bytes", () -> new LongWithAttributes(this.queuedEstimatedMergeMemoryInBytes.get()));
    }

    public void incrementQueuedMergeBytes(OnGoingMerge currentMerge, long estimatedMemorySize) {
        this.queuedMergeSizeInBytes.getAndAdd(currentMerge.getTotalBytesSize());
        this.queuedEstimatedMergeMemoryInBytes.getAndAdd(estimatedMemorySize);
    }

    public void moveQueuedMergeBytesToRunning(OnGoingMerge currentMerge, long estimatedMemorySize) {
        long totalSize = currentMerge.getTotalBytesSize();
        this.queuedMergeSizeInBytes.getAndAdd(-totalSize);
        this.runningMergeSizeInBytes.getAndAdd(totalSize);
        this.queuedEstimatedMergeMemoryInBytes.getAndAdd(-estimatedMemorySize);
    }

    public void decrementRunningMergeBytes(OnGoingMerge currentMerge) {
        this.runningMergeSizeInBytes.getAndAdd(-currentMerge.getTotalBytesSize());
    }

    public void markMergeMetrics(MergePolicy.OneMerge currentMerge, long mergedSegmentSize, long tookMillis) {
        this.mergeSizeInBytes.incrementBy(currentMerge.totalBytesSize());
        this.mergeMergedSegmentSizeInBytes.incrementBy(mergedSegmentSize);
        this.mergeNumDocs.incrementBy(currentMerge.totalNumDocs());
        this.mergeTimeInSeconds.record(tookMillis / 1000L);
    }

    public long getQueuedMergeSizeInBytes() {
        return this.queuedMergeSizeInBytes.get();
    }

    public long getRunningMergeSizeInBytes() {
        return this.runningMergeSizeInBytes.get();
    }
}

