/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.health.node.ProjectIndexName;

public class HealthIndicatorDisplayValues {
    public static String getNodeName(DiscoveryNode node) {
        if (node.getName() != null) {
            return String.format(Locale.ROOT, "[%s][%s]", node.getId(), node.getName());
        }
        return String.format(Locale.ROOT, "[%s]", node.getId());
    }

    @Deprecated
    public static String getTruncatedIndices(Set<String> indices, Metadata clusterMetadata) {
        int maxIndices = 10;
        Object truncatedIndicesString = indices.stream().sorted(HealthIndicatorDisplayValues.indicesComparatorByPriorityAndName(clusterMetadata)).limit(10L).collect(Collectors.joining(", "));
        if (10 < indices.size()) {
            truncatedIndicesString = (String)truncatedIndicesString + ", ...";
        }
        return truncatedIndicesString;
    }

    public static String getTruncatedProjectIndices(Set<ProjectIndexName> indices, Metadata clusterMetadata, boolean supportsMultipleProjects) {
        int maxIndices = 10;
        Object truncatedIndicesString = indices.stream().sorted(HealthIndicatorDisplayValues.indicesComparatorByPriorityAndProjectIndex(clusterMetadata, supportsMultipleProjects)).limit(10L).map(projectIndexName -> projectIndexName.toString(supportsMultipleProjects)).collect(Collectors.joining(", "));
        if (10 < indices.size()) {
            truncatedIndicesString = (String)truncatedIndicesString + ", ...";
        }
        return truncatedIndicesString;
    }

    public static <T> String getSortedUniqueValuesString(Collection<T> values, Predicate<T> predicate, Function<T, String> toString) {
        return values.stream().filter(predicate).map(toString).distinct().sorted().collect(Collectors.joining(", "));
    }

    public static <T> String getSortedUniqueValuesString(Collection<T> values, Function<T, String> toString) {
        return values.stream().map(toString).distinct().sorted().collect(Collectors.joining(", "));
    }

    public static String indices(int count) {
        return count == 1 ? "index" : "indices";
    }

    public static String are(int count) {
        return count == 1 ? "is" : "are";
    }

    public static String these(int count) {
        return count == 1 ? "this" : "these";
    }

    public static String regularNoun(String noun, int count) {
        return count == 1 ? noun : noun + "s";
    }

    public static String regularVerb(String verb, int count) {
        return count == 1 ? verb + "s" : verb;
    }

    @Deprecated
    public static Comparator<String> indicesComparatorByPriorityAndName(Metadata clusterMetadata) {
        return Comparator.comparingInt(indexName -> {
            IndexMetadata indexMetadata = clusterMetadata.getProject().index((String)indexName);
            return indexMetadata == null ? -1 : indexMetadata.priority();
        }).reversed().thenComparing(Comparator.naturalOrder());
    }

    public static Comparator<ProjectIndexName> indicesComparatorByPriorityAndProjectIndex(Metadata clusterMetadata, boolean supportsMultipleProjects) {
        return Comparator.comparingInt(projectIndexName -> {
            ProjectMetadata projectMetadata = clusterMetadata.getProject(projectIndexName.projectId());
            IndexMetadata indexMetadata = projectMetadata.index(projectIndexName.indexName());
            return indexMetadata == null ? -1 : indexMetadata.priority();
        }).reversed().thenComparing(projectIndex -> projectIndex.toString(supportsMultipleProjects));
    }
}

