/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractPageMappingOperator
implements Operator {
    private Page prev;
    private boolean finished = false;
    private long processNanos;
    private int pagesProcessed;
    private long rowsReceived;
    private long rowsEmitted;

    protected abstract Page process(Page var1);

    public abstract String toString();

    @Override
    public final boolean needsInput() {
        return this.prev == null && !this.finished;
    }

    @Override
    public final void addInput(Page page) {
        assert (this.prev == null) : "has pending input page";
        this.prev = page;
        this.rowsReceived += (long)page.getPositionCount();
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && this.prev == null;
    }

    @Override
    public final Page getOutput() {
        if (this.prev == null) {
            return null;
        }
        if (this.prev.getPositionCount() == 0) {
            return this.prev;
        }
        long start = System.nanoTime();
        Page p = this.process(this.prev);
        ++this.pagesProcessed;
        if (p != null) {
            this.rowsEmitted += (long)p.getPositionCount();
        }
        this.processNanos += System.nanoTime() - start;
        this.prev = null;
        return p;
    }

    @Override
    public final Status status() {
        return this.status(this.processNanos, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
    }

    protected Status status(long processNanos, int pagesProcessed, long rowsReceived, long rowsEmitted) {
        return new Status(processNanos, pagesProcessed, rowsReceived, rowsEmitted);
    }

    @Override
    public void close() {
        if (this.prev != null) {
            Releasables.closeExpectNoException(() -> this.prev.releaseBlocks());
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "page_mapping", Status::new);
        private final long processNanos;
        private final int pagesProcessed;
        private final long rowsReceived;
        private final long rowsEmitted;

        public Status(long processNanos, int pagesProcessed, long rowsReceived, long rowsEmitted) {
            this.processNanos = processNanos;
            this.pagesProcessed = pagesProcessed;
            this.rowsReceived = rowsReceived;
            this.rowsEmitted = rowsEmitted;
        }

        public Status(StreamInput in) throws IOException {
            this.processNanos = in.readVLong();
            this.pagesProcessed = in.readVInt();
            if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                this.rowsReceived = in.readVLong();
                this.rowsEmitted = in.readVLong();
            } else {
                this.rowsReceived = 0L;
                this.rowsEmitted = 0L;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.processNanos);
            out.writeVInt(this.pagesProcessed);
            if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeVLong(this.rowsReceived);
                out.writeVLong(this.rowsEmitted);
            }
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public long rowsReceived() {
            return this.rowsReceived;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public long processNanos() {
            return this.processNanos;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        protected final XContentBuilder innerToXContent(XContentBuilder builder) throws IOException {
            builder.field("process_nanos", this.processNanos);
            if (builder.humanReadable()) {
                builder.field("process_time", (Object)TimeValue.timeValueNanos((long)this.processNanos));
            }
            builder.field("pages_processed", this.pagesProcessed);
            builder.field("rows_received", this.rowsReceived);
            builder.field("rows_emitted", this.rowsEmitted);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.processNanos == status.processNanos && this.pagesProcessed == status.pagesProcessed && this.rowsReceived == status.rowsReceived && this.rowsEmitted == status.rowsEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.processNanos, this.pagesProcessed, this.rowsReceived, this.rowsEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }
}

