/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.TimeSeriesGroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class DeltaIntAggregator {
    public static IntDeltaGroupingState initGrouping(DriverContext driverContext) {
        return new IntDeltaGroupingState(driverContext.bigArrays(), driverContext.breaker());
    }

    public static void combine(IntDeltaGroupingState current, int groupId, int value, long timestamp) {
        current.ensureCapacity(groupId);
        current.append(groupId, timestamp, value);
    }

    public static void combineIntermediate(IntDeltaGroupingState current, int groupId, LongBlock samples, LongBlock timestamps, IntBlock values, int otherPosition) {
        current.combine(groupId, samples, timestamps, values, otherPosition);
    }

    public static Block evaluateFinal(IntDeltaGroupingState state, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        return state.evaluateFinal(selected, evalContext);
    }

    public static final class IntDeltaGroupingState
    implements Releasable,
    Accountable,
    GroupingAggregatorState {
        private ObjectArray<IntDeltaState> states;
        private final BigArrays bigArrays;
        private final CircuitBreaker breaker;
        private long stateBytes;

        IntDeltaGroupingState(BigArrays bigArrays, CircuitBreaker breaker) {
            this.bigArrays = bigArrays;
            this.breaker = breaker;
            this.states = bigArrays.newObjectArray(1L);
        }

        void ensureCapacity(int groupId) {
            this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
        }

        void adjustBreaker(long bytes) {
            this.breaker.addEstimateBytesAndMaybeBreak(bytes, "<<delta aggregation>>");
            this.stateBytes += bytes;
            assert (this.stateBytes >= 0L) : this.stateBytes;
        }

        void append(int groupId, long timestamp, int value) {
            IntDeltaState state = (IntDeltaState)this.states.get((long)groupId);
            if (state == null) {
                state = new IntDeltaState(timestamp, value);
                this.states.set((long)groupId, (Object)state);
                this.adjustBreaker(state.bytesUsed());
            } else if (timestamp >= state.lastTimestamp) {
                state.lastTimestamp = timestamp;
                state.lastValue = value;
                ++state.valuesSeen;
            } else if (timestamp <= state.firstTimestamp) {
                state.firstTimestamp = timestamp;
                state.firstValue = value;
                ++state.valuesSeen;
            }
        }

        void combine(int groupId, LongBlock samples, LongBlock timestamps, IntBlock values, int otherPosition) {
            int valueCount = timestamps.getValueCount(otherPosition);
            if (valueCount == 0) {
                return;
            }
            long valuesSeen = samples.getLong(samples.getFirstValueIndex(otherPosition));
            int firstTs = timestamps.getFirstValueIndex(otherPosition);
            int firstIndex = values.getFirstValueIndex(otherPosition);
            this.ensureCapacity(groupId);
            this.append(groupId, timestamps.getLong(firstTs), values.getInt(firstIndex));
            if (valueCount > 1) {
                this.append(groupId, timestamps.getLong(firstTs + 1), values.getInt(firstIndex + 1));
            }
            ((IntDeltaState)this.states.get((long)((long)groupId))).valuesSeen += valuesSeen - (long)valueCount;
        }

        public long ramBytesUsed() {
            return this.states.ramBytesUsed() + this.stateBytes;
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.states, () -> this.adjustBreaker(-this.stateBytes)});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 2) : "blocks=" + blocks.length + ",offset=" + offset;
            BlockFactory blockFactory = driverContext.blockFactory();
            int positionCount = selected.getPositionCount();
            try (LongVector.FixedBuilder samples = blockFactory.newLongVectorFixedBuilder(positionCount);
                 LongBlock.Builder timestamps = blockFactory.newLongBlockBuilder(positionCount * 2);
                 IntBlock.Builder values = blockFactory.newIntBlockBuilder(positionCount * 2);){
                for (int i = 0; i < positionCount; ++i) {
                    IntDeltaState state;
                    int groupId = selected.getInt(i);
                    IntDeltaState intDeltaState = state = (long)groupId < this.states.size() ? (IntDeltaState)this.states.get((long)groupId) : null;
                    if (state != null) {
                        samples.appendLong(state.valuesSeen);
                        timestamps.beginPositionEntry();
                        timestamps.appendLong(state.lastTimestamp);
                        if (state.valuesSeen > 1L) {
                            timestamps.appendLong(state.firstTimestamp);
                        }
                        timestamps.endPositionEntry();
                        values.beginPositionEntry();
                        values.appendInt(state.lastValue);
                        if (state.valuesSeen > 1L) {
                            values.appendInt(state.firstValue);
                        }
                        values.endPositionEntry();
                        continue;
                    }
                    samples.appendLong(0L);
                    timestamps.appendNull();
                    values.appendNull();
                }
                blocks[offset] = samples.build().asBlock();
                blocks[offset + 1] = timestamps.build();
                blocks[offset + 2] = values.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            int positionCount = selected.getPositionCount();
            try (DoubleBlock.Builder rates = evalContext.blockFactory().newDoubleBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    IntDeltaState state;
                    int groupId = selected.getInt(p);
                    IntDeltaState intDeltaState = state = (long)groupId < this.states.size() ? (IntDeltaState)this.states.get((long)groupId) : null;
                    if (state == null || state.valuesSeen < 2L) {
                        rates.appendNull();
                        continue;
                    }
                    if (evalContext instanceof TimeSeriesGroupingAggregatorEvaluationContext) {
                        TimeSeriesGroupingAggregatorEvaluationContext tsContext = (TimeSeriesGroupingAggregatorEvaluationContext)evalContext;
                        long rangeStart = tsContext.rangeStartInMillis(groupId);
                        long rangeEnd = tsContext.rangeEndInMillis(groupId);
                        if (state.lastTimestamp - state.firstTimestamp == 0L) {
                            rates.appendNull();
                            continue;
                        }
                        double startGap = state.firstTimestamp - rangeStart;
                        double averageSampleInterval = ((double)state.lastTimestamp - (double)state.firstTimestamp) / (double)state.valuesSeen;
                        double slope = (long)(state.lastValue - state.firstValue) / (state.lastTimestamp - state.firstTimestamp);
                        double endGap = rangeEnd - state.lastTimestamp;
                        double calculatedFirstValue = state.firstValue;
                        if (startGap > 0.0) {
                            if (startGap > averageSampleInterval * 1.1) {
                                startGap = averageSampleInterval / 2.0;
                            }
                            calculatedFirstValue -= startGap * slope;
                        }
                        double calculatedLastValue = state.lastValue;
                        if (endGap > 0.0) {
                            if (endGap > averageSampleInterval * 1.1) {
                                endGap = averageSampleInterval / 2.0;
                            }
                            calculatedLastValue += endGap * slope;
                        }
                        rates.appendDouble(calculatedLastValue - calculatedFirstValue);
                        continue;
                    }
                    rates.appendDouble(state.lastValue - state.firstValue);
                }
                DoubleBlock doubleBlock = rates.build();
                return doubleBlock;
            }
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    private static class IntDeltaState {
        static final long BASE_RAM_USAGE = RamUsageEstimator.sizeOfObject(IntDeltaState.class);
        long lastTimestamp = -1L;
        long firstTimestamp = Long.MAX_VALUE;
        int lastValue;
        int firstValue;
        long valuesSeen;

        IntDeltaState(long seenTs, int seenValue) {
            this.lastTimestamp = seenTs;
            this.lastValue = seenValue;
            this.firstTimestamp = seenTs;
            this.firstValue = seenValue;
            this.valuesSeen = 1L;
        }

        long bytesUsed() {
            return BASE_RAM_USAGE;
        }
    }
}

