/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.DeltaFloatAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class DeltaFloatGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("samples", ElementType.LONG), new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.FLOAT));
    private final DeltaFloatAggregator.FloatDeltaGroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public DeltaFloatGroupingAggregatorFunction(List<Integer> channels, DeltaFloatAggregator.FloatDeltaGroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static DeltaFloatGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new DeltaFloatGroupingAggregatorFunction(channels, DeltaFloatAggregator.initGrouping(driverContext), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final FloatBlock valueBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        final LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final FloatVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock, timestampBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                public void close() {
                }
            };
        }
        final LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock, timestampBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector, timestampVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector, timestampVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                DeltaFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector, timestampVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, FloatBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset) || timestampBlock.isNull(valuesPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    float valueValue = valueBlock.getFloat(valueOffset);
                    int timestampStart = timestampBlock.getFirstValueIndex(valuesPosition);
                    int timestampEnd = timestampStart + timestampBlock.getValueCount(valuesPosition);
                    for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                        long timestampValue = timestampBlock.getLong(timestampOffset);
                        DeltaFloatAggregator.combine(this.state, groupId, valueValue, timestampValue);
                    }
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, FloatVector valueVector, LongVector timestampVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                float valueValue = valueVector.getFloat(valuesPosition);
                long timestampValue = timestampVector.getLong(valuesPosition);
                DeltaFloatAggregator.combine(this.state, groupId, valueValue, timestampValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object samplesUncast = page.getBlock(this.channels.get(0));
        if (samplesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock samples = (LongBlock)samplesUncast;
        Object timestampsUncast = page.getBlock(this.channels.get(1));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(2));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock values = (FloatBlock)valuesUncast;
        assert (samples.getPositionCount() == timestamps.getPositionCount() && samples.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                DeltaFloatAggregator.combineIntermediate(this.state, groupId, samples, timestamps, values, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, FloatBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset) || timestampBlock.isNull(valuesPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    float valueValue = valueBlock.getFloat(valueOffset);
                    int timestampStart = timestampBlock.getFirstValueIndex(valuesPosition);
                    int timestampEnd = timestampStart + timestampBlock.getValueCount(valuesPosition);
                    for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                        long timestampValue = timestampBlock.getLong(timestampOffset);
                        DeltaFloatAggregator.combine(this.state, groupId, valueValue, timestampValue);
                    }
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, FloatVector valueVector, LongVector timestampVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                float valueValue = valueVector.getFloat(valuesPosition);
                long timestampValue = timestampVector.getLong(valuesPosition);
                DeltaFloatAggregator.combine(this.state, groupId, valueValue, timestampValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object samplesUncast = page.getBlock(this.channels.get(0));
        if (samplesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock samples = (LongBlock)samplesUncast;
        Object timestampsUncast = page.getBlock(this.channels.get(1));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(2));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock values = (FloatBlock)valuesUncast;
        assert (samples.getPositionCount() == timestamps.getPositionCount() && samples.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                DeltaFloatAggregator.combineIntermediate(this.state, groupId, samples, timestamps, values, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, FloatBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (valueBlock.isNull(valuesPosition) || timestampBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
            int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                float valueValue = valueBlock.getFloat(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(valuesPosition);
                int timestampEnd = timestampStart + timestampBlock.getValueCount(valuesPosition);
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    DeltaFloatAggregator.combine(this.state, groupId, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, FloatVector valueVector, LongVector timestampVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            float valueValue = valueVector.getFloat(valuesPosition);
            long timestampValue = timestampVector.getLong(valuesPosition);
            DeltaFloatAggregator.combine(this.state, groupId, valueValue, timestampValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object samplesUncast = page.getBlock(this.channels.get(0));
        if (samplesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock samples = (LongBlock)samplesUncast;
        Object timestampsUncast = page.getBlock(this.channels.get(1));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(2));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock values = (FloatBlock)valuesUncast;
        assert (samples.getPositionCount() == timestamps.getPositionCount() && samples.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            DeltaFloatAggregator.combineIntermediate(this.state, groupId, samples, timestamps, values, valuesPosition);
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, FloatBlock valueBlock, LongBlock timestampBlock) {
        if (valueBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
        if (timestampBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = DeltaFloatAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

