/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram;

import java.util.List;
import java.util.OptionalLong;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;

public record IndexWithCount(long index, long count) {
    static ExponentialHistogram.Buckets asBuckets(final int scale, final List<IndexWithCount> bucketIndices) {
        return new ExponentialHistogram.Buckets(){

            public CopyableBucketIterator iterator() {
                return new Iterator(bucketIndices, scale, 0);
            }

            public OptionalLong maxBucketIndex() {
                if (bucketIndices.isEmpty()) {
                    return OptionalLong.empty();
                }
                return OptionalLong.of(((IndexWithCount)bucketIndices.get((int)(bucketIndices.size() - 1))).index);
            }

            public long valueCount() {
                throw new UnsupportedOperationException("not implemented");
            }
        };
    }

    private static class Iterator
    implements CopyableBucketIterator {
        private final List<IndexWithCount> buckets;
        private final int scale;
        private int position;

        Iterator(List<IndexWithCount> buckets, int scale, int position) {
            this.buckets = buckets;
            this.scale = scale;
            this.position = position;
        }

        public boolean hasNext() {
            return this.position < this.buckets.size();
        }

        public long peekCount() {
            return this.buckets.get((int)this.position).count;
        }

        public long peekIndex() {
            return this.buckets.get((int)this.position).index;
        }

        public void advance() {
            ++this.position;
        }

        public int scale() {
            return this.scale;
        }

        public CopyableBucketIterator copy() {
            return new Iterator(this.buckets, this.scale, this.position);
        }
    }
}

