/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.common.BytesProcessor;
import org.elasticsearch.ingest.common.CommunityIdProcessor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.common.LowercaseProcessor;
import org.elasticsearch.ingest.common.URLDecodeProcessor;
import org.elasticsearch.ingest.common.UppercaseProcessor;
import org.elasticsearch.ingest.common.UriPartsProcessor;

public final class Processors {
    public static long bytes(String value) {
        return BytesProcessor.apply(value);
    }

    public static String lowercase(String value) {
        return LowercaseProcessor.apply(value);
    }

    public static String uppercase(String value) {
        return UppercaseProcessor.apply(value);
    }

    public static Object json(Object fieldValue) {
        return JsonProcessor.apply(fieldValue, false, true);
    }

    public static Object jsonLenient(Object fieldValue) {
        return JsonProcessor.apply(fieldValue, false, false);
    }

    public static void json(Map<String, Object> map, String field) {
        JsonProcessor.apply(map, field, false, JsonProcessor.ConflictStrategy.REPLACE, true);
    }

    public static void jsonLenient(Map<String, Object> map, String field) {
        JsonProcessor.apply(map, field, false, JsonProcessor.ConflictStrategy.REPLACE, false);
    }

    public static String urlDecode(String value) {
        return URLDecodeProcessor.apply(value);
    }

    public static String communityId(String sourceIpAddrString, String destIpAddrString, Object ianaNumber, Object transport, Object sourcePort, Object destinationPort, Object icmpType, Object icmpCode, int seed) {
        return CommunityIdProcessor.apply(sourceIpAddrString, destIpAddrString, ianaNumber, transport, sourcePort, destinationPort, icmpType, icmpCode, seed);
    }

    public static String communityId(String sourceIpAddrString, String destIpAddrString, Object ianaNumber, Object transport, Object sourcePort, Object destinationPort, Object icmpType, Object icmpCode) {
        return CommunityIdProcessor.apply(sourceIpAddrString, destIpAddrString, ianaNumber, transport, sourcePort, destinationPort, icmpType, icmpCode);
    }

    public static Map<String, Object> uriParts(String uri) {
        return UriPartsProcessor.apply(uri);
    }
}

