/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.LeafReaderContextSupplier;
import org.elasticsearch.script.NumberSortScript;

class ExpressionNumberSortScript
implements NumberSortScript.LeafFactory {
    final Expression exprScript;
    final SimpleBindings bindings;
    final DoubleValuesSource source;
    final boolean needsScores;

    ExpressionNumberSortScript(Expression e, SimpleBindings b, boolean needsScores) {
        this.exprScript = e;
        this.bindings = b;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)this.bindings);
        this.needsScores = needsScores;
    }

    public NumberSortScript newInstance(DocReader reader) throws IOException {
        if (!(reader instanceof LeafReaderContextSupplier)) {
            throw new IllegalStateException("Expected LeafReaderContextSupplier when creating expression NumberSortScript instead of [" + String.valueOf(reader) + "]");
        }
        final LeafReaderContext ctx = ((LeafReaderContextSupplier)reader).getLeafReaderContext();
        return new NumberSortScript(){
            DoubleValues values;
            {
                this.values = ExpressionNumberSortScript.this.source.getValues(ctx, new DoubleValues(this){

                    public double doubleValue() {
                        return 0.0;
                    }

                    public boolean advanceExact(int doc) {
                        return true;
                    }
                });
            }

            public double execute() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + String.valueOf(ExpressionNumberSortScript.this.exprScript), (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + String.valueOf(ExpressionNumberSortScript.this.exprScript), e);
                }
            }
        };
    }

    public boolean needs_score() {
        return this.needsScores;
    }
}

