/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.chunks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.QueryBuilder;

public class MemoryIndexChunkScorer {
    private static final String CONTENT_FIELD = "content";
    private final StandardAnalyzer analyzer = new StandardAnalyzer();

    public List<ScoredChunk> scoreChunks(List<String> chunks, String inferenceText, int maxResults) throws IOException {
        if (chunks == null || chunks.isEmpty() || inferenceText == null || inferenceText.trim().isEmpty()) {
            return new ArrayList<ScoredChunk>();
        }
        try (ByteBuffersDirectory directory = new ByteBuffersDirectory();){
            Object object;
            block20: {
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)this.analyzer);
                try (IndexWriter writer = new IndexWriter((Directory)directory, config);){
                    for (String chunk : chunks) {
                        Document doc = new Document();
                        doc.add((IndexableField)new TextField(CONTENT_FIELD, chunk, Field.Store.YES));
                        writer.addDocument((Iterable)doc);
                    }
                    writer.commit();
                }
                DirectoryReader reader = DirectoryReader.open((Directory)directory);
                try {
                    IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                    QueryBuilder qb = new QueryBuilder((Analyzer)this.analyzer);
                    Query query = qb.createBooleanQuery(CONTENT_FIELD, inferenceText, BooleanClause.Occur.SHOULD);
                    int numResults = Math.min(maxResults, chunks.size());
                    TopDocs topDocs = searcher.search(query, numResults);
                    ArrayList<ScoredChunk> scoredChunks = new ArrayList<ScoredChunk>();
                    object = topDocs.scoreDocs;
                    int n = ((ScoreDoc[])object).length;
                    for (int i = 0; i < n; ++i) {
                        ScoreDoc scoreDoc = object[i];
                        Document doc = reader.storedFields().document(scoreDoc.doc);
                        String content = doc.get(CONTENT_FIELD);
                        scoredChunks.add(new ScoredChunk(content, scoreDoc.score));
                    }
                    Object object2 = object = !scoredChunks.isEmpty() ? scoredChunks : chunks.subList(0, Math.min(maxResults, chunks.size())).stream().map(c -> new ScoredChunk((String)c, 0.0f)).toList();
                    if (reader == null) break block20;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return object;
        }
    }

    public record ScoredChunk(String content, float score) {
    }
}

