/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class AutoscalingMetadata
implements Metadata.ClusterCustom {
    public static final String NAME = "autoscaling";
    public static final AutoscalingMetadata EMPTY = new AutoscalingMetadata(Collections.emptySortedMap());
    private static final ParseField POLICIES_FIELD = new ParseField("policies", new String[0]);
    private static final ConstructingObjectParser<AutoscalingMetadata, Void> PARSER = new ConstructingObjectParser("autoscaling", c -> new AutoscalingMetadata(new TreeMap<String, AutoscalingPolicyMetadata>(((List)c[0]).stream().collect(Collectors.toMap(p -> p.policy().name(), Function.identity())))));
    private final SortedMap<String, AutoscalingPolicyMetadata> policies;

    public static AutoscalingMetadata parse(XContentParser parser) {
        return (AutoscalingMetadata)PARSER.apply(parser, null);
    }

    public SortedMap<String, AutoscalingPolicyMetadata> policies() {
        return this.policies;
    }

    public AutoscalingMetadata(SortedMap<String, AutoscalingPolicyMetadata> policies) {
        this.policies = policies;
    }

    public AutoscalingMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, AutoscalingPolicyMetadata> policiesMap = new TreeMap<String, AutoscalingPolicyMetadata>();
        for (int i = 0; i < size; ++i) {
            AutoscalingPolicyMetadata policyMetadata = new AutoscalingPolicyMetadata(in);
            policiesMap.put(policyMetadata.policy().name(), policyMetadata);
        }
        this.policies = policiesMap;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.policies.values());
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public boolean isRestorable() {
        return false;
    }

    public Diff<Metadata.ClusterCustom> diff(Metadata.ClusterCustom previousState) {
        return new AutoscalingMetadataDiff((AutoscalingMetadata)previousState, this);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return ChunkedToXContentHelper.xContentObjectFields((String)POLICIES_FIELD.getPreferredName(), this.policies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingMetadata metadata = (AutoscalingMetadata)o;
        return this.policies.equals(metadata.policies);
    }

    public int hashCode() {
        return Objects.hash(this.policies);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> AutoscalingPolicyMetadata.parse(p, n), POLICIES_FIELD);
    }

    public static class AutoscalingMetadataDiff
    implements NamedDiff<Metadata.ClusterCustom> {
        final Diff<Map<String, AutoscalingPolicyMetadata>> policies;

        public AutoscalingMetadataDiff(AutoscalingMetadata before, AutoscalingMetadata after) {
            this.policies = DiffableUtils.diff(before.policies, after.policies, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
        }

        public AutoscalingMetadataDiff(StreamInput in) throws IOException {
            this.policies = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), AutoscalingPolicyMetadata::new, AutoscalingMetadataDiff::readFrom);
        }

        public Metadata.ClusterCustom apply(Metadata.ClusterCustom part) {
            return new AutoscalingMetadata(new TreeMap<String, AutoscalingPolicyMetadata>((Map)this.policies.apply(((AutoscalingMetadata)part).policies)));
        }

        public String getWriteableName() {
            return AutoscalingMetadata.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.policies.writeTo(out);
        }

        static Diff<AutoscalingPolicyMetadata> readFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(AutoscalingPolicyMetadata::new, (StreamInput)in);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.zero();
        }
    }
}

