/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class BucketMetricsPipelineAggregationBuilder<AF extends BucketMetricsPipelineAggregationBuilder<AF>>
extends AbstractPipelineAggregationBuilder<AF> {
    private String format;
    private BucketHelpers.GapPolicy gapPolicy;

    protected BucketMetricsPipelineAggregationBuilder(String name, String type, String[] bucketsPaths) {
        this(name, type, bucketsPaths, null, BucketHelpers.GapPolicy.SKIP);
    }

    protected BucketMetricsPipelineAggregationBuilder(String name, String type, String[] bucketsPaths, String format, BucketHelpers.GapPolicy gapPolicy) {
        super(name, type, bucketsPaths);
        this.format = format;
        this.gapPolicy = gapPolicy;
    }

    protected BucketMetricsPipelineAggregationBuilder(StreamInput in, String type) throws IOException {
        super(in, type);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    public AF format(String format) {
        this.format = format;
        return (AF)this;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public AF gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return (AF)this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected abstract PipelineAggregator createInternal(Map<String, Object> var1);

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.bucketsPaths.length != 1) {
            context.addBucketPathValidationError("must contain a single entry for aggregation [" + this.name + "]");
            return;
        }
        List<AggregationPath.PathElement> path = AggregationPath.parse(this.bucketsPaths[0]).getPathElements();
        int pathPos = 0;
        AggregationPath.PathElement currentAgg = path.get(pathPos++);
        String aggName = currentAgg.name();
        Optional<AggregationBuilder> aggBuilder = context.getSiblingAggregations().stream().filter(builder -> builder.getName().equals(aggName)).findAny();
        if (aggBuilder.isEmpty()) {
            context.addBucketPathValidationError("aggregation does not exist for aggregation [" + this.name + "]: " + this.bucketsPaths[0]);
            return;
        }
        while (aggBuilder.isPresent() && pathPos < path.size() && (aggBuilder.get().bucketCardinality() == AggregationBuilder.BucketCardinality.MANY && AggregationPath.pathElementContainsBucketKey(currentAgg) || aggBuilder.get().bucketCardinality() == AggregationBuilder.BucketCardinality.ONE && !aggBuilder.get().getSubAggregations().isEmpty())) {
            currentAgg = path.get(pathPos++);
            String subAggName = currentAgg.name();
            aggBuilder = aggBuilder.get().getSubAggregations().stream().filter(b -> b.getName().equals(subAggName)).findAny();
        }
        if (aggBuilder.isEmpty()) {
            context.addBucketPathValidationError("aggregation does not exist for aggregation [" + this.name + "]: " + String.valueOf(AggregationPath.pathElementsAsStringList(path.subList(0, pathPos))));
            return;
        }
        if (aggBuilder.get().bucketCardinality() != AggregationBuilder.BucketCardinality.MANY) {
            context.addValidationError("Unable to find unqualified multi-bucket aggregation in " + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + ". Path must include a multi-bucket aggregation for aggregation [" + this.name + "] found :" + aggBuilder.get().getClass().getName() + " for buckets path: " + this.bucketsPaths[0]);
        }
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(BucketMetricsParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        this.doXContentBody(builder, params);
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format, this.gapPolicy);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BucketMetricsPipelineAggregationBuilder other = (BucketMetricsPipelineAggregationBuilder)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.gapPolicy, other.gapPolicy);
    }
}

