/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.CentroidAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalCentroid
extends InternalAggregation
implements CentroidAggregation {
    protected final SpatialPoint centroid;
    protected final long count;

    public InternalCentroid(String name, SpatialPoint centroid, long count, Map<String, Object> metadata) {
        super(name, metadata);
        assert (centroid == null == (count == 0L));
        this.centroid = centroid;
        assert (count >= 0L);
        this.count = count;
    }

    protected abstract SpatialPoint centroidFromStream(StreamInput var1) throws IOException;

    protected abstract void centroidToStream(StreamOutput var1) throws IOException;

    protected InternalCentroid(StreamInput in) throws IOException {
        super(in);
        this.count = in.readVLong();
        this.centroid = in.readBoolean() ? this.centroidFromStream(in) : null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (this.centroid != null) {
            out.writeBoolean(true);
            this.centroidToStream(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public SpatialPoint centroid() {
        return this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    protected abstract InternalCentroid copyWith(SpatialPoint var1, long var2);

    protected abstract InternalCentroid copyWith(double var1, double var3, long var5);

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            double firstSum = Double.NaN;
            double secondSum = Double.NaN;
            long totalCount = 0L;

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalCentroid centroidAgg = (InternalCentroid)aggregation;
                if (centroidAgg.count > 0L) {
                    this.totalCount += centroidAgg.count;
                    if (Double.isNaN(this.firstSum)) {
                        this.firstSum = (double)centroidAgg.count * InternalCentroid.this.extractFirst(centroidAgg.centroid);
                        this.secondSum = (double)centroidAgg.count * InternalCentroid.this.extractSecond(centroidAgg.centroid);
                    } else {
                        this.firstSum += (double)centroidAgg.count * InternalCentroid.this.extractFirst(centroidAgg.centroid);
                        this.secondSum += (double)centroidAgg.count * InternalCentroid.this.extractSecond(centroidAgg.centroid);
                    }
                }
            }

            @Override
            public InternalAggregation get() {
                return InternalCentroid.this.copyWith(this.firstSum, this.secondSum, this.totalCount);
            }
        };
    }

    protected abstract String nameFirst();

    protected abstract double extractFirst(SpatialPoint var1);

    protected abstract String nameSecond();

    protected abstract double extractSecond(SpatialPoint var1);

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this.copyWith(this.centroid, samplingContext.scaleUp(this.count));
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    protected abstract double extractDouble(String var1);

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String coordinate;
            return switch (coordinate = path.get(0)) {
                case "value" -> this.centroid;
                case "count" -> Long.valueOf(this.count);
                default -> Double.valueOf(this.extractDouble(coordinate));
            };
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + String.valueOf(path));
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(Fields.CENTROID.getPreferredName());
            builder.field(this.nameFirst(), this.extractFirst(this.centroid));
            builder.field(this.nameSecond(), this.extractSecond(this.centroid));
            builder.endObject();
        }
        builder.field(Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCentroid that = (InternalCentroid)obj;
        return this.count == that.count && Objects.equals(this.centroid, that.centroid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.centroid, this.count);
    }

    @Override
    public String toString() {
        return "InternalCentroid{centroid=" + String.valueOf(this.centroid) + ", count=" + this.count + "}";
    }

    public static class Fields {
        public static final ParseField CENTROID = new ParseField("location", new String[0]);
        public static final ParseField COUNT = new ParseField("count", new String[0]);
    }
}

