/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.codec.vectors.ES813FlatVectorFormat;
import org.elasticsearch.index.codec.vectors.ES813Int8FlatVectorFormat;
import org.elasticsearch.index.codec.vectors.ES814HnswScalarQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.ES815BitFlatVectorFormat;
import org.elasticsearch.index.codec.vectors.ES815HnswBitVectorsFormat;
import org.elasticsearch.index.codec.vectors.diskbbq.ES920DiskBBQVectorsFormat;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.es818.ES818HnswBinaryQuantizedVectorsFormat;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenormalizedCosineFloatVectorValues;
import org.elasticsearch.index.mapper.vectors.IndexOptions;
import org.elasticsearch.index.mapper.vectors.SyntheticVectorsPatchFieldLoader;
import org.elasticsearch.index.mapper.vectors.VectorIndexFieldData;
import org.elasticsearch.index.mapper.vectors.VectorsFormatProvider;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.vectors.DenseVectorQuery;
import org.elasticsearch.search.vectors.DiversifyingChildrenIVFKnnFloatVectorQuery;
import org.elasticsearch.search.vectors.DiversifyingParentBlockQuery;
import org.elasticsearch.search.vectors.ESDiversifyingChildrenByteKnnVectorQuery;
import org.elasticsearch.search.vectors.ESDiversifyingChildrenFloatKnnVectorQuery;
import org.elasticsearch.search.vectors.ESKnnByteVectorQuery;
import org.elasticsearch.search.vectors.ESKnnFloatVectorQuery;
import org.elasticsearch.search.vectors.IVFKnnFloatVectorQuery;
import org.elasticsearch.search.vectors.QueryProfilerProvider;
import org.elasticsearch.search.vectors.RescoreKnnVectorQuery;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.search.vectors.VectorSimilarityQuery;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DenseVectorFieldMapper
extends FieldMapper {
    public static final String COSINE_MAGNITUDE_FIELD_SUFFIX = "._magnitude";
    private static final float EPS = 0.001f;
    public static final int BBQ_MIN_DIMS = 64;
    private static final boolean DEFAULT_HNSW_EARLY_TERMINATION = false;
    public static final Setting<FilterHeuristic> HNSW_FILTER_HEURISTIC = Setting.enumSetting(FilterHeuristic.class, s -> {
        IndexVersion version = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)s);
        if (version.onOrAfter(IndexVersions.DEFAULT_TO_ACORN_HNSW_FILTER_HEURISTIC)) {
            return FilterHeuristic.ACORN.toString();
        }
        return FilterHeuristic.FANOUT.toString();
    }, "index.dense_vector.hnsw_filter_heuristic", fh -> {}, Setting.Property.IndexScope, Setting.Property.ServerlessPublic, Setting.Property.Dynamic);
    public static final Setting<Boolean> HNSW_EARLY_TERMINATION = Setting.boolSetting("index.dense_vector.hnsw_enable_early_termination", false, Setting.Property.IndexScope, Setting.Property.ServerlessPublic, Setting.Property.Dynamic);
    public static final IndexVersion MAGNITUDE_STORED_INDEX_VERSION = IndexVersions.V_7_5_0;
    public static final IndexVersion INDEXED_BY_DEFAULT_INDEX_VERSION = IndexVersions.FIRST_DETACHED_INDEX_VERSION;
    public static final IndexVersion NORMALIZE_COSINE = IndexVersions.NORMALIZED_VECTOR_COSINE;
    public static final IndexVersion DEFAULT_TO_INT8 = IndexVersions.DEFAULT_DENSE_VECTOR_TO_INT8_HNSW;
    public static final IndexVersion DEFAULT_TO_BBQ = IndexVersions.DEFAULT_DENSE_VECTOR_TO_BBQ_HNSW;
    public static final IndexVersion LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION = IndexVersions.V_8_9_0;
    public static final NodeFeature RESCORE_VECTOR_QUANTIZED_VECTOR_MAPPING = new NodeFeature("mapper.dense_vector.rescore_vector");
    public static final NodeFeature RESCORE_ZERO_VECTOR_QUANTIZED_VECTOR_MAPPING = new NodeFeature("mapper.dense_vector.rescore_zero_vector");
    public static final NodeFeature USE_DEFAULT_OVERSAMPLE_VALUE_FOR_BBQ = new NodeFeature("mapper.dense_vector.default_oversample_value_for_bbq");
    public static final String CONTENT_TYPE = "dense_vector";
    public static final short MAX_DIMS_COUNT = 4096;
    public static final int MAX_DIMS_COUNT_BIT = 32768;
    public static final short MIN_DIMS_FOR_DYNAMIC_FLOAT_MAPPING = 128;
    public static final int MAGNITUDE_BYTES = 4;
    public static final int OVERSAMPLE_LIMIT = 10000;
    public static final float DEFAULT_OVERSAMPLE = 3.0f;
    public static final int BBQ_DIMS_DEFAULT_THRESHOLD = 384;
    public static final Element BYTE_ELEMENT = new ByteElement();
    public static final Element FLOAT_ELEMENT = new FloatElement();
    public static final Element BIT_ELEMENT = new BitElement();
    public static final Map<String, ElementType> namesToElementType = Map.of(ElementType.BYTE.toString(), ElementType.BYTE, ElementType.FLOAT.toString(), ElementType.FLOAT, ElementType.BIT.toString(), ElementType.BIT);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexSettings().getIndexVersionCreated(), IndexSettings.INDEX_MAPPING_EXCLUDE_SOURCE_VECTORS_SETTING.get(c.getIndexSettings().getSettings()), c.getVectorsFormatProviders()), DenseVectorFieldMapper.notInMultiFields("dense_vector"));
    private final DenseVectorIndexOptions indexOptions;
    private final IndexVersion indexCreatedVersion;
    private final boolean isExcludeSourceVectors;
    private final List<VectorsFormatProvider> extraVectorsFormatProviders;

    public static boolean isNotUnitVector(float magnitude) {
        return Math.abs(magnitude - 1.0f) > 0.001f;
    }

    private static boolean hasRescoreIndexVersion(IndexVersion version) {
        return version.onOrAfter(IndexVersions.ADD_RESCORE_PARAMS_TO_QUANTIZED_VECTORS) || version.between(IndexVersions.ADD_RESCORE_PARAMS_TO_QUANTIZED_VECTORS_BACKPORT_8_X, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private static boolean allowsZeroRescore(IndexVersion version) {
        return version.onOrAfter(IndexVersions.RESCORE_PARAMS_ALLOW_ZERO_TO_QUANTIZED_VECTORS) || version.between(IndexVersions.RESCORE_PARAMS_ALLOW_ZERO_TO_QUANTIZED_VECTORS_BACKPORT_8_X, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private static boolean defaultOversampleForBBQ(IndexVersion version) {
        return version.onOrAfter(IndexVersions.DEFAULT_OVERSAMPLE_VALUE_FOR_BBQ) || version.between(IndexVersions.DEFAULT_OVERSAMPLE_VALUE_FOR_BBQ_BACKPORT_8_X, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams params, DenseVectorIndexOptions indexOptions, IndexVersion indexCreatedVersion, boolean isExcludeSourceVectorsFinal, List<VectorsFormatProvider> vectorsFormatProviders) {
        super(simpleName, mappedFieldType, params);
        this.indexOptions = indexOptions;
        this.indexCreatedVersion = indexCreatedVersion;
        this.isExcludeSourceVectors = isExcludeSourceVectorsFinal;
        this.extraVectorsFormatProviders = vectorsFormatProviders;
    }

    @Override
    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.doc().getByKey(this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
        }
        if (XContentParser.Token.VALUE_NULL == context.parser().currentToken()) {
            return;
        }
        if (this.fieldType().dims == null) {
            int dims = this.fieldType().element.parseDimensionCount(context);
            Builder builder = (Builder)this.getMergeBuilder();
            builder.dimensions(dims);
            DenseVectorFieldMapper update = builder.build(context.createDynamicMapperBuilderContext());
            context.addDynamicMapper(update);
            return;
        }
        if (this.fieldType().indexed) {
            this.parseKnnVectorAndIndex(context);
        } else {
            this.parseBinaryDocValuesVectorAndIndex(context);
        }
    }

    private void parseKnnVectorAndIndex(DocumentParserContext context) throws IOException {
        this.fieldType().element.parseKnnVectorAndIndex(context, this);
    }

    private void parseBinaryDocValuesVectorAndIndex(DocumentParserContext context) throws IOException {
        int dims = this.fieldType().dims;
        Element element = this.fieldType().element;
        int numBytes = this.indexCreatedVersion.onOrAfter(MAGNITUDE_STORED_INDEX_VERSION) ? element.getNumBytes(dims) + 4 : element.getNumBytes(dims);
        ByteBuffer byteBuffer = element.createByteBuffer(this.indexCreatedVersion, numBytes);
        VectorData vectorData = element.parseKnnVector(context, dims, (i, b) -> {
            if (b) {
                this.checkDimensionMatches(i, context);
            } else {
                this.checkDimensionExceeded(i, context);
            }
        }, this.fieldType().similarity);
        vectorData.addToBuffer(byteBuffer);
        if (this.indexCreatedVersion.onOrAfter(MAGNITUDE_STORED_INDEX_VERSION)) {
            double dotProduct = element.computeSquaredMagnitude(vectorData);
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(byteBuffer.array()));
        context.doc().addWithKey(this.fieldType().name(), (IndexableField)field);
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has more dimensions than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.isExcludeSourceVectors, this.extraVectorsFormatProviders).init(this);
    }

    private static DenseVectorIndexOptions parseIndexOptions(String fieldName, Object propNode, IndexVersion indexVersion) {
        Map indexOptionsMap = (Map)propNode;
        Object typeNode = indexOptionsMap.remove("type");
        if (typeNode == null) {
            throw new MapperParsingException("[index_options] requires field [type] to be configured");
        }
        String type = XContentMapValues.nodeStringValue(typeNode);
        Optional<VectorIndexType> vectorIndexType = VectorIndexType.fromString(type);
        if (vectorIndexType.isEmpty()) {
            throw new MapperParsingException("Unknown vector index options type [" + type + "] for field [" + fieldName + "]");
        }
        VectorIndexType parsedType = vectorIndexType.get();
        return parsedType.parseIndexOptions(fieldName, indexOptionsMap, indexVersion);
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(KnnVectorsFormat defaultFormat, IndexSettings indexSettings) {
        KnnVectorsFormat format;
        if (this.indexOptions == null) {
            format = this.fieldType().element.elementType() == ElementType.BIT ? new ES815HnswBitVectorsFormat() : defaultFormat;
        } else {
            VectorsFormatProvider vectorsFormatProvider;
            KnnVectorsFormat extraKnnFormat = null;
            Iterator<VectorsFormatProvider> iterator = this.extraVectorsFormatProviders.iterator();
            while (iterator.hasNext() && (extraKnnFormat = (vectorsFormatProvider = iterator.next()).getKnnVectorsFormat(indexSettings, this.indexOptions, this.fieldType().similarity())) == null) {
            }
            format = extraKnnFormat != null ? extraKnnFormat : this.indexOptions.getVectorsFormat(this.fieldType().element.elementType());
        }
        return new KnnVectorsFormat(this, format.getName()){

            public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
                return format.fieldsWriter(state);
            }

            public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
                return format.fieldsReader(state);
            }

            public int getMaxDimensions(String fieldName) {
                return 4096;
            }

            public String toString() {
                return format.toString();
            }
        };
    }

    @Override
    public SourceLoader.SyntheticVectorsLoader syntheticVectorsLoader() {
        if (this.isExcludeSourceVectors) {
            return new SyntheticVectorsPatchFieldLoader<IndexedSyntheticFieldLoader>(() -> new IndexedSyntheticFieldLoader(this.indexCreatedVersion, this.fieldType().similarity), IndexedSyntheticFieldLoader::copyVectorAsList);
        }
        return null;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> this.fieldType().indexed ? new IndexedSyntheticFieldLoader(this.indexCreatedVersion, this.fieldType().similarity) : new DocValuesSyntheticFieldLoader(this.indexCreatedVersion));
    }

    public static abstract class DenseVectorIndexOptions
    implements IndexOptions {
        final VectorIndexType type;

        DenseVectorIndexOptions(VectorIndexType type) {
            this.type = type;
        }

        abstract KnnVectorsFormat getVectorsFormat(ElementType var1);

        public boolean validate(ElementType elementType, int dim, boolean throwOnError) {
            return this.validateElementType(elementType, throwOnError) && this.validateDimension(dim, throwOnError);
        }

        public boolean validateElementType(ElementType elementType) {
            return this.validateElementType(elementType, true);
        }

        final boolean validateElementType(ElementType elementType, boolean throwOnError) {
            boolean validElementType = this.type.supportsElementType(elementType);
            if (throwOnError && !validElementType) {
                throw new IllegalArgumentException("[element_type] cannot be [" + elementType.toString() + "] when using index type [" + String.valueOf((Object)this.type) + "]");
            }
            return validElementType;
        }

        public abstract boolean updatableTo(DenseVectorIndexOptions var1);

        public boolean validateDimension(int dim) {
            return this.validateDimension(dim, true);
        }

        public boolean validateDimension(int dim, boolean throwOnError) {
            boolean supportsDimension = this.type.supportsDimension(dim);
            if (throwOnError && !supportsDimension) {
                throw new IllegalArgumentException(this.type.name + " only supports even dimensions; provided=" + dim);
            }
            return supportsDimension;
        }

        abstract boolean doEquals(DenseVectorIndexOptions var1);

        abstract int doHashCode();

        public VectorIndexType getType() {
            return this.type;
        }

        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            DenseVectorIndexOptions otherOptions = (DenseVectorIndexOptions)other;
            return Objects.equals((Object)this.type, (Object)otherOptions.type) && this.doEquals(otherOptions);
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.type, this.doHashCode()});
        }

        public abstract boolean isFlat();
    }

    public static final class DenseVectorFieldType
    extends SimpleMappedFieldType {
        private final Element element;
        private final Integer dims;
        private final boolean indexed;
        private final VectorSimilarity similarity;
        private final IndexVersion indexVersionCreated;
        private final DenseVectorIndexOptions indexOptions;
        private final boolean isSyntheticSource;

        public DenseVectorFieldType(String name, IndexVersion indexVersionCreated, ElementType elementType, Integer dims, boolean indexed, VectorSimilarity similarity, DenseVectorIndexOptions indexOptions, Map<String, String> meta, boolean isSyntheticSource) {
            super(name, indexed, false, !indexed, meta);
            this.element = Element.getElement(elementType);
            this.dims = dims;
            this.indexed = indexed;
            this.similarity = similarity;
            this.indexVersionCreated = indexVersionCreated;
            this.indexOptions = indexOptions;
            this.isSyntheticSource = isSyntheticSource;
        }

        public VectorSimilarity similarity() {
            return this.similarity;
        }

        @Override
        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this, this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.DENSE_VECTOR;
        }

        @Override
        public boolean isAggregatable() {
            return false;
        }

        @Override
        public boolean isVectorEmbedding() {
            return true;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return this.element.fielddataBuilder(this, fieldDataContext);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        public Query createExactKnnQuery(VectorData queryVector, Float vectorSimilarity) {
            Query knnQuery;
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            switch (this.element.elementType().ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Query query = this.createExactKnnByteQuery(queryVector.asByteVector());
                    break;
                }
                case 1: {
                    Query query = this.createExactKnnFloatQuery(queryVector.asFloatVector());
                    break;
                }
                case 2: {
                    Query query = knnQuery = this.createExactKnnBitQuery(queryVector.asByteVector());
                }
            }
            if (vectorSimilarity != null) {
                knnQuery = new VectorSimilarityQuery(knnQuery, vectorSimilarity.floatValue(), this.similarity.score(vectorSimilarity.floatValue(), this.element.elementType(), this.dims));
            }
            return knnQuery;
        }

        public boolean isNormalized() {
            return this.indexVersionCreated.onOrAfter(NORMALIZE_COSINE) && VectorSimilarity.COSINE.equals((Object)this.similarity);
        }

        private Query createExactKnnBitQuery(byte[] queryVector) {
            this.element.checkDimensions(this.dims, queryVector.length);
            return new DenseVectorQuery.Bytes(queryVector, this.name());
        }

        private Query createExactKnnByteQuery(byte[] queryVector) {
            this.element.checkDimensions(this.dims, queryVector.length);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct((byte[])queryVector, (byte[])queryVector);
                this.element.checkVectorMagnitude(this.similarity, ByteElement.errorElementsAppender(queryVector), squaredMagnitude);
            }
            return new DenseVectorQuery.Bytes(queryVector, this.name());
        }

        private Query createExactKnnFloatQuery(float[] queryVector) {
            this.element.checkDimensions(this.dims, queryVector.length);
            this.element.checkVectorBounds(queryVector);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct((float[])queryVector, (float[])queryVector);
                this.element.checkVectorMagnitude(this.similarity, FloatElement.errorElementsAppender(queryVector), squaredMagnitude);
                if (this.isNormalized() && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    queryVector = Arrays.copyOf(queryVector, queryVector.length);
                    int i = 0;
                    while (i < queryVector.length) {
                        int n = i++;
                        queryVector[n] = queryVector[n] / length;
                    }
                }
            }
            return new DenseVectorQuery.Floats(queryVector, this.name());
        }

        public Query createKnnQuery(VectorData queryVector, int k, int numCands, Float visitPercentage, Float oversample, Query filter, Float similarityThreshold, BitSetProducer parentFilter, FilterHeuristic heuristic, boolean hnswEarlyTermination) {
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            if (this.dims == null) {
                return new MatchNoDocsQuery("No data has been indexed for field [" + this.name() + "]");
            }
            KnnSearchStrategy knnSearchStrategy = heuristic.getKnnSearchStrategy();
            hnswEarlyTermination &= this.canApplyPatienceQuery();
            return switch (this.getElementType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.createKnnByteQuery(queryVector.asByteVector(), k, numCands, filter, similarityThreshold, parentFilter, knnSearchStrategy, hnswEarlyTermination);
                case 1 -> this.createKnnFloatQuery(queryVector.asFloatVector(), k, numCands, visitPercentage, oversample, filter, similarityThreshold, parentFilter, knnSearchStrategy, hnswEarlyTermination);
                case 2 -> this.createKnnBitQuery(queryVector.asByteVector(), k, numCands, filter, similarityThreshold, parentFilter, knnSearchStrategy, hnswEarlyTermination);
            };
        }

        private boolean needsRescore(Float rescoreOversample) {
            return rescoreOversample != null && rescoreOversample.floatValue() > 0.0f && this.isQuantized();
        }

        private boolean isQuantized() {
            return this.indexOptions != null && this.indexOptions.type != null && this.indexOptions.type.isQuantized();
        }

        private boolean canApplyPatienceQuery() {
            return this.indexOptions instanceof HnswIndexOptions || this.indexOptions instanceof Int8HnswIndexOptions || this.indexOptions instanceof Int4HnswIndexOptions || this.indexOptions instanceof BBQHnswIndexOptions;
        }

        private Query createKnnBitQuery(byte[] queryVector, int k, int numCands, Query filter, Float similarityThreshold, BitSetProducer parentFilter, KnnSearchStrategy searchStrategy, boolean hnswEarlyTermination) {
            Object knnQuery;
            this.element.checkDimensions(this.dims, queryVector.length);
            if (this.indexOptions != null && this.indexOptions.isFlat()) {
                DiversifyingParentBlockQuery exactKnnQuery = parentFilter != null ? new DiversifyingParentBlockQuery(parentFilter, this.createExactKnnBitQuery(queryVector)) : this.createExactKnnBitQuery(queryVector);
                knnQuery = filter == null ? exactKnnQuery : new BooleanQuery.Builder().add((Query)exactKnnQuery, BooleanClause.Occur.SHOULD).add(filter, BooleanClause.Occur.FILTER).build();
            } else {
                QueryProfilerProvider queryProfilerProvider = knnQuery = parentFilter != null ? new ESDiversifyingChildrenByteKnnVectorQuery(this.name(), queryVector, filter, k, numCands, parentFilter, searchStrategy, hnswEarlyTermination) : new ESKnnByteVectorQuery(this.name(), queryVector, k, numCands, filter, searchStrategy, hnswEarlyTermination);
            }
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)knnQuery, similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.element.elementType(), this.dims));
            }
            return knnQuery;
        }

        private Query createKnnByteQuery(byte[] queryVector, int k, int numCands, Query filter, Float similarityThreshold, BitSetProducer parentFilter, KnnSearchStrategy searchStrategy, boolean hnswEarlyTermination) {
            Object knnQuery;
            this.element.checkDimensions(this.dims, queryVector.length);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct((byte[])queryVector, (byte[])queryVector);
                this.element.checkVectorMagnitude(this.similarity, ByteElement.errorElementsAppender(queryVector), squaredMagnitude);
            }
            if (this.indexOptions != null && this.indexOptions.isFlat()) {
                DiversifyingParentBlockQuery exactKnnQuery = parentFilter != null ? new DiversifyingParentBlockQuery(parentFilter, this.createExactKnnByteQuery(queryVector)) : this.createExactKnnByteQuery(queryVector);
                knnQuery = filter == null ? exactKnnQuery : new BooleanQuery.Builder().add((Query)exactKnnQuery, BooleanClause.Occur.SHOULD).add(filter, BooleanClause.Occur.FILTER).build();
            } else {
                QueryProfilerProvider queryProfilerProvider = knnQuery = parentFilter != null ? new ESDiversifyingChildrenByteKnnVectorQuery(this.name(), queryVector, filter, k, numCands, parentFilter, searchStrategy, hnswEarlyTermination) : new ESKnnByteVectorQuery(this.name(), queryVector, k, numCands, filter, searchStrategy, hnswEarlyTermination);
            }
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)knnQuery, similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.element.elementType(), this.dims));
            }
            return knnQuery;
        }

        private Query createKnnFloatQuery(float[] queryVector, int k, int numCands, Float visitPercentage, Float queryOversample, Query filter, Float similarityThreshold, BitSetProducer parentFilter, KnnSearchStrategy knnSearchStrategy, boolean hnswEarlyTermination) {
            Object knnQuery;
            boolean rescore;
            DenseVectorIndexOptions denseVectorIndexOptions;
            this.element.checkDimensions(this.dims, queryVector.length);
            this.element.checkVectorBounds(queryVector);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct((float[])queryVector, (float[])queryVector);
                this.element.checkVectorMagnitude(this.similarity, FloatElement.errorElementsAppender(queryVector), squaredMagnitude);
                if (this.isNormalized() && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    queryVector = Arrays.copyOf(queryVector, queryVector.length);
                    int i = 0;
                    while (i < queryVector.length) {
                        int n = i++;
                        queryVector[n] = queryVector[n] / length;
                    }
                }
            }
            int adjustedK = k;
            Float oversample = queryOversample;
            if (oversample == null && (denseVectorIndexOptions = this.indexOptions) instanceof QuantizedIndexOptions) {
                QuantizedIndexOptions quantizedIndexOptions = (QuantizedIndexOptions)denseVectorIndexOptions;
                if (quantizedIndexOptions.rescoreVector != null) {
                    oversample = Float.valueOf(quantizedIndexOptions.rescoreVector.oversample);
                }
            }
            if (rescore = this.needsRescore(oversample)) {
                adjustedK = Math.min((int)Math.ceil((float)k * oversample.floatValue()), 10000);
                numCands = Math.max(adjustedK, numCands);
            }
            if (this.indexOptions != null && this.indexOptions.isFlat()) {
                DiversifyingParentBlockQuery exactKnnQuery = parentFilter != null ? new DiversifyingParentBlockQuery(parentFilter, this.createExactKnnFloatQuery(queryVector)) : this.createExactKnnFloatQuery(queryVector);
                knnQuery = filter == null ? exactKnnQuery : new BooleanQuery.Builder().add((Query)exactKnnQuery, BooleanClause.Occur.SHOULD).add(filter, BooleanClause.Occur.FILTER).build();
            } else {
                DenseVectorIndexOptions exactKnnQuery = this.indexOptions;
                if (exactKnnQuery instanceof BBQIVFIndexOptions) {
                    BBQIVFIndexOptions bbqIndexOptions = (BBQIVFIndexOptions)exactKnnQuery;
                    float defaultVisitRatio = (float)(bbqIndexOptions.defaultVisitPercentage / 100.0);
                    float visitRatio = visitPercentage == null ? defaultVisitRatio : (float)((double)visitPercentage.floatValue() / 100.0);
                    knnQuery = parentFilter != null ? new DiversifyingChildrenIVFKnnFloatVectorQuery(this.name(), queryVector, adjustedK, numCands, filter, parentFilter, visitRatio) : new IVFKnnFloatVectorQuery(this.name(), queryVector, adjustedK, numCands, filter, visitRatio);
                } else {
                    Object object = knnQuery = parentFilter != null ? new ESDiversifyingChildrenFloatKnnVectorQuery(this.name(), queryVector, filter, adjustedK, numCands, parentFilter, knnSearchStrategy) : new ESKnnFloatVectorQuery(this.name(), queryVector, adjustedK, numCands, filter, knnSearchStrategy, hnswEarlyTermination);
                }
            }
            if (rescore) {
                knnQuery = RescoreKnnVectorQuery.fromInnerQuery(this.name(), queryVector, this.similarity.vectorSimilarityFunction(this.indexVersionCreated, ElementType.FLOAT), k, adjustedK, knnQuery);
            }
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)knnQuery, similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.element.elementType(), this.dims));
            }
            return knnQuery;
        }

        public VectorSimilarity getSimilarity() {
            return this.similarity;
        }

        public int getVectorDimensions() {
            return this.dims;
        }

        public ElementType getElementType() {
            return this.element.elementType();
        }

        public DenseVectorIndexOptions getIndexOptions() {
            return this.indexOptions;
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.dims == null) {
                return BlockLoader.CONSTANT_NULLS;
            }
            if (this.indexed) {
                return new BlockDocValuesReader.DenseVectorBlockLoader(this.name(), this.dims, this);
            }
            if (this.hasDocValues() && (blContext.fieldExtractPreference() != MappedFieldType.FieldExtractPreference.STORED || this.isSyntheticSource)) {
                return new BlockDocValuesReader.DenseVectorFromBinaryBlockLoader(this.name(), this.dims, this.indexVersionCreated, this.element.elementType());
            }
            BlockSourceReader.LeafIteratorLookup lookup = BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.DenseVectorBlockLoader(this.sourceValueFetcher(blContext.sourcePaths(this.name())), lookup, this.dims);
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(sourcePaths, null){

                @Override
                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return null;
                    }
                    return NumberFieldMapper.NumberType.FLOAT.parse(value, false);
                }

                @Override
                public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) {
                    List<Object> result = super.fetchValues(source, doc, ignoredValues);
                    assert (result.size() == dims.intValue()) : "Unexpected number of dimensions; got " + result.size() + " but expected " + dims;
                    return result;
                }
            };
        }
    }

    public static abstract class Element {
        public static Element getElement(ElementType elementType) {
            return switch (elementType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> FLOAT_ELEMENT;
                case 0 -> BYTE_ELEMENT;
                case 2 -> BIT_ELEMENT;
            };
        }

        public static ElementType checkValidVector(float[] vector, ElementType ... possibleTypes) {
            assert (possibleTypes.length != 0);
            StringBuilder[] errors = new StringBuilder[possibleTypes.length];
            for (int i = 0; i < possibleTypes.length; ++i) {
                StringBuilder error = Element.getElement(possibleTypes[i]).checkVectorErrors(vector);
                if (error == null) {
                    return possibleTypes[i];
                }
                errors[i] = error;
            }
            StringBuilder message = new StringBuilder();
            for (int i = 0; i < possibleTypes.length; ++i) {
                if (i > 0) {
                    message.append(" ");
                }
                message.append("Vector is not a ").append((Object)possibleTypes[i]).append(" vector: ").append((CharSequence)errors[i]);
            }
            throw new IllegalArgumentException(FloatElement.appendErrorElements(message, vector).toString());
        }

        public abstract ElementType elementType();

        public abstract void writeValue(ByteBuffer var1, float var2);

        public abstract void readAndWriteValue(ByteBuffer var1, XContentBuilder var2) throws IOException;

        abstract IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType var1, FieldDataContext var2);

        abstract void parseKnnVectorAndIndex(DocumentParserContext var1, DenseVectorFieldMapper var2) throws IOException;

        public abstract VectorData parseKnnVector(DocumentParserContext var1, int var2, IntBooleanConsumer var3, VectorSimilarity var4) throws IOException;

        public abstract int getNumBytes(int var1);

        public abstract ByteBuffer createByteBuffer(IndexVersion var1, int var2);

        public void checkVectorBounds(float[] vector) {
            StringBuilder errors = this.checkVectorErrors(vector);
            if (errors != null) {
                throw new IllegalArgumentException(FloatElement.appendErrorElements(errors, vector).toString());
            }
        }

        StringBuilder checkVectorErrors(float[] vector) {
            return this.checkNanAndInfinite(vector);
        }

        abstract void checkVectorMagnitude(VectorSimilarity var1, UnaryOperator<StringBuilder> var2, float var3);

        public abstract double computeSquaredMagnitude(VectorData var1);

        public void checkDimensions(Integer dvDims, int qvDims) {
            if (dvDims != null && dvDims != qvDims) {
                throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims + "] than the document vectors [" + dvDims + "].");
            }
        }

        public int parseDimensionCount(DocumentParserContext context) throws IOException {
            int index = 0;
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                ++index;
                token = context.parser().nextToken();
            }
            return index;
        }

        StringBuilder checkNanAndInfinite(float[] vector) {
            StringBuilder errorBuilder = null;
            for (int index = 0; index < vector.length; ++index) {
                float value = vector[index];
                if (Float.isNaN(value)) {
                    errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this.elementType()) + "] vectors do not support NaN values but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (!Float.isInfinite(value)) continue;
                errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this.elementType()) + "] vectors do not support infinite values but found [" + value + "] at dim [" + index + "];");
                break;
            }
            return errorBuilder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<ElementType> elementType = new FieldMapper.Parameter<ElementType>("element_type", false, () -> ElementType.FLOAT, (n, c, o) -> {
            ElementType elementType = namesToElementType.get((String)o);
            if (elementType == null) {
                throw new MapperParsingException("invalid element_type [" + String.valueOf(o) + "]; available types are " + String.valueOf(namesToElementType.keySet()));
            }
            return elementType;
        }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().element.elementType(), XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Integer> dims;
        private final FieldMapper.Parameter<VectorSimilarity> similarity;
        private final FieldMapper.Parameter<DenseVectorIndexOptions> indexOptions;
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final IndexVersion indexVersionCreated;
        final boolean isExcludeSourceVectors;
        private final List<VectorsFormatProvider> vectorsFormatProviders;

        public Builder(String name, IndexVersion indexVersionCreated, boolean isExcludeSourceVectors, List<VectorsFormatProvider> vectorsFormatProviders) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            this.vectorsFormatProviders = vectorsFormatProviders;
            this.dims = new FieldMapper.Parameter<Integer>("dims", true, () -> null, (n, c, o) -> {
                if (!(o instanceof Integer)) {
                    throw new MapperParsingException("Property [dims] on field [" + n + "] must be an integer but got [" + String.valueOf(o) + "]");
                }
                return XContentMapValues.nodeIntegerValue(o);
            }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().dims, XContentBuilder::field, Objects::toString).setSerializerCheck((id, ic, v) -> v != null).setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current)).addValidator(dims -> {
                int minDims;
                if (dims == null) {
                    return;
                }
                int maxDims = this.elementType.getValue() == ElementType.BIT ? 32768 : 4096;
                int n = minDims = this.elementType.getValue() == ElementType.BIT ? 8 : 1;
                if (dims < minDims || dims > maxDims) {
                    throw new MapperParsingException("The number of dimensions should be in the range [" + minDims + ", " + maxDims + "] but was [" + dims + "]");
                }
                if (this.elementType.getValue() == ElementType.BIT && dims % 8 != 0) {
                    throw new MapperParsingException("The number of dimensions for should be a multiple of 8 but was [" + dims + "]");
                }
            });
            this.isExcludeSourceVectors = isExcludeSourceVectors;
            boolean indexedByDefault = indexVersionCreated.onOrAfter(INDEXED_BY_DEFAULT_INDEX_VERSION);
            boolean defaultInt8Hnsw = indexVersionCreated.onOrAfter(IndexVersions.DEFAULT_DENSE_VECTOR_TO_INT8_HNSW);
            boolean defaultBBQ8Hnsw = indexVersionCreated.onOrAfter(IndexVersions.DEFAULT_DENSE_VECTOR_TO_BBQ_HNSW);
            this.indexed = FieldMapper.Parameter.indexParam(m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().indexed, indexedByDefault);
            if (indexedByDefault) {
                this.indexed.alwaysSerialize();
            }
            this.similarity = FieldMapper.Parameter.enumParam("similarity", false, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().similarity, () -> {
                if (indexedByDefault && this.indexed.getValue().booleanValue()) {
                    return this.elementType.getValue() == ElementType.BIT ? VectorSimilarity.L2_NORM : VectorSimilarity.COSINE;
                }
                return null;
            }, VectorSimilarity.class).acceptsNull().setSerializerCheck((id, ic, v) -> v != null).addValidator(vectorSim -> {
                if (vectorSim == null) {
                    return;
                }
                if (this.elementType.getValue() == ElementType.BIT && vectorSim != VectorSimilarity.L2_NORM) {
                    throw new IllegalArgumentException("The [" + String.valueOf((Object)VectorSimilarity.L2_NORM) + "] similarity is the only supported similarity for bit vectors");
                }
            });
            this.indexOptions = new FieldMapper.Parameter<DenseVectorIndexOptions>("index_options", true, () -> this.defaultIndexOptions(defaultInt8Hnsw, defaultBBQ8Hnsw), (n, c, o) -> o == null ? null : DenseVectorFieldMapper.parseIndexOptions(n, o, indexVersionCreated), m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexOptions, (b, n, v) -> {
                if (v != null) {
                    b.field(n, (ToXContent)v);
                }
            }, Objects::toString).setSerializerCheck((id, ic, v) -> v != null).addValidator(v -> {
                if (v != null && this.dims.isConfigured() && this.dims.get() != null) {
                    v.validateDimension(this.dims.get());
                }
                if (v != null) {
                    v.validateElementType(this.elementType.getValue());
                }
            }).acceptsNull().setMergeValidator((previous, current, c) -> previous == null || current == null || Objects.equals(previous, current) || previous.updatableTo((DenseVectorIndexOptions)current));
            if ((defaultInt8Hnsw || defaultBBQ8Hnsw) && (!defaultBBQ8Hnsw || this.dims != null && this.dims.isConfigured())) {
                this.indexOptions.alwaysSerialize();
            }
            this.indexed.addValidator(v -> {
                if (v.booleanValue()) {
                    if (this.similarity.getValue() == null) {
                        throw new IllegalArgumentException("Field [index] requires field [similarity] to be configured and not null");
                    }
                } else {
                    if (this.similarity.isConfigured() && this.similarity.getValue() != null) {
                        throw new IllegalArgumentException("Field [similarity] can only be specified for a field of type [dense_vector] when it is indexed");
                    }
                    if (this.indexOptions.isConfigured() && this.indexOptions.getValue() != null) {
                        throw new IllegalArgumentException("Field [index_options] can only be specified for a field of type [dense_vector] when it is indexed");
                    }
                }
            });
        }

        private DenseVectorIndexOptions defaultIndexOptions(boolean defaultInt8Hnsw, boolean defaultBBQHnsw) {
            boolean dimIsConfigured;
            if (this.elementType.getValue() != ElementType.FLOAT || !this.indexed.getValue().booleanValue()) {
                return null;
            }
            boolean bl = dimIsConfigured = this.dims != null && this.dims.isConfigured();
            if (defaultBBQHnsw && !dimIsConfigured) {
                return null;
            }
            if (defaultBBQHnsw && dimIsConfigured && this.dims.getValue() >= 384) {
                return new BBQHnswIndexOptions(16, 100, new RescoreVector(3.0f));
            }
            if (defaultInt8Hnsw) {
                return new Int8HnswIndexOptions(16, 100, null, null);
            }
            return null;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.elementType, this.dims, this.indexed, this.similarity, this.indexOptions, this.meta};
        }

        public Builder similarity(VectorSimilarity vectorSimilarity) {
            this.similarity.setValue(vectorSimilarity);
            return this;
        }

        public Builder dimensions(int dimensions) {
            this.dims.setValue(dimensions);
            return this;
        }

        public Builder elementType(ElementType elementType) {
            this.elementType.setValue(elementType);
            return this;
        }

        public Builder indexOptions(DenseVectorIndexOptions indexOptions) {
            this.indexOptions.setValue(indexOptions);
            return this;
        }

        @Override
        public DenseVectorFieldMapper build(MapperBuilderContext context) {
            this.validate();
            boolean isExcludeSourceVectorsFinal = !context.isSourceSynthetic() && this.indexed.getValue() != false && this.isExcludeSourceVectors;
            return new DenseVectorFieldMapper(this.leafName(), new DenseVectorFieldType(context.buildFullName(this.leafName()), this.indexVersionCreated, this.elementType.getValue(), this.dims.getValue(), this.indexed.getValue(), this.similarity.getValue(), this.indexOptions.getValue(), this.meta.getValue(), context.isSourceSynthetic()), this.builderParams(this, context), this.indexOptions.getValue(), this.indexVersionCreated, isExcludeSourceVectorsFinal, this.vectorsFormatProviders);
        }
    }

    @FunctionalInterface
    public static interface IntBooleanConsumer {
        public void accept(int var1, boolean var2);
    }

    public static enum VectorSimilarity {
        L2_NORM{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    default -> throw new MatchException(null, null);
                    case ElementType.BYTE, ElementType.FLOAT -> 1.0f / (1.0f + similarity * similarity);
                    case ElementType.BIT -> ((float)dim - similarity) / (float)dim;
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.EUCLIDEAN;
            }
        }
        ,
        COSINE{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                assert (elementType != ElementType.BIT);
                switch (elementType) {
                    case BYTE: 
                    case FLOAT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported element type [" + String.valueOf((Object)elementType) + "]");
                    }
                }
                return (1.0f + similarity) / 2.0f;
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return indexVersion.onOrAfter(NORMALIZE_COSINE) && ElementType.FLOAT.equals((Object)elementType) ? VectorSimilarityFunction.DOT_PRODUCT : VectorSimilarityFunction.COSINE;
            }
        }
        ,
        DOT_PRODUCT{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    case ElementType.BYTE -> 0.5f + similarity / (float)(dim * 32768);
                    case ElementType.FLOAT -> (1.0f + similarity) / 2.0f;
                    default -> throw new IllegalArgumentException("Unsupported element type [" + String.valueOf((Object)elementType) + "]");
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.DOT_PRODUCT;
            }
        }
        ,
        MAX_INNER_PRODUCT{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    case ElementType.BYTE, ElementType.FLOAT -> {
                        if (similarity < 0.0f) {
                            yield 1.0f / (1.0f + -1.0f * similarity);
                        }
                        yield similarity + 1.0f;
                    }
                    default -> throw new IllegalArgumentException("Unsupported element type [" + String.valueOf((Object)elementType) + "]");
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
            }
        };


        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        abstract float score(float var1, ElementType var2, int var3);

        public abstract VectorSimilarityFunction vectorSimilarityFunction(IndexVersion var1, ElementType var2);
    }

    public static enum VectorIndexType {
        HNSW("hnsw", false){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new HnswIndexOptions(m, efConstruction);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return true;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT8_HNSW("int8_hnsw", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                RescoreVector rescoreVector = null;
                if (DenseVectorFieldMapper.hasRescoreIndexVersion(indexVersion)) {
                    rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion);
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int8HnswIndexOptions(m, efConstruction, confidenceInterval, rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT4_HNSW("int4_hnsw", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                RescoreVector rescoreVector = null;
                if (DenseVectorFieldMapper.hasRescoreIndexVersion(indexVersion)) {
                    rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion);
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int4HnswIndexOptions(m, efConstruction, confidenceInterval, rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims % 2 == 0;
            }
        }
        ,
        FLAT("flat", false){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new FlatIndexOptions();
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return true;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT8_FLAT("int8_flat", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                RescoreVector rescoreVector = null;
                if (DenseVectorFieldMapper.hasRescoreIndexVersion(indexVersion)) {
                    rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion);
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int8FlatIndexOptions(confidenceInterval, rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT4_FLAT("int4_flat", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                RescoreVector rescoreVector = null;
                if (DenseVectorFieldMapper.hasRescoreIndexVersion(indexVersion)) {
                    rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion);
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int4FlatIndexOptions(confidenceInterval, rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims % 2 == 0;
            }
        }
        ,
        BBQ_HNSW("bbq_hnsw", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                RescoreVector rescoreVector = null;
                if (DenseVectorFieldMapper.hasRescoreIndexVersion(indexVersion) && (rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion)) == null && DenseVectorFieldMapper.defaultOversampleForBBQ(indexVersion)) {
                    rescoreVector = new RescoreVector(3.0f);
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new BBQHnswIndexOptions(m, efConstruction, rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims >= 64;
            }
        }
        ,
        BBQ_FLAT("bbq_flat", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                RescoreVector rescoreVector = null;
                if (DenseVectorFieldMapper.hasRescoreIndexVersion(indexVersion) && (rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion)) == null && DenseVectorFieldMapper.defaultOversampleForBBQ(indexVersion)) {
                    rescoreVector = new RescoreVector(3.0f);
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new BBQFlatIndexOptions(rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims >= 64;
            }
        }
        ,
        BBQ_DISK("bbq_disk", true){

            @Override
            public DenseVectorIndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
                Object clusterSizeNode = indexOptionsMap.remove("cluster_size");
                int clusterSize = 384;
                if (clusterSizeNode != null && ((clusterSize = XContentMapValues.nodeIntegerValue(clusterSizeNode)) < 64 || clusterSize > 65536)) {
                    throw new IllegalArgumentException("cluster_size must be between 64 and 65536, got: " + clusterSize);
                }
                RescoreVector rescoreVector = RescoreVector.fromIndexOptions(indexOptionsMap, indexVersion);
                if (rescoreVector == null) {
                    rescoreVector = new RescoreVector(3.0f);
                }
                Object visitPercentageNode = indexOptionsMap.remove("default_visit_percentage");
                double visitPercentage = 0.0;
                if (visitPercentageNode != null && ((visitPercentage = (double)((float)XContentMapValues.nodeDoubleValue(visitPercentageNode))) < 0.0 || visitPercentage > 100.0)) {
                    throw new IllegalArgumentException("default_visit_percentage must be between 0.0 and 100.0, got: " + visitPercentage + " for field [" + fieldName + "]");
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new BBQIVFIndexOptions(clusterSize, visitPercentage, rescoreVector);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        };

        private final String name;
        private final boolean quantized;

        public static Optional<VectorIndexType> fromString(String type) {
            return Stream.of(VectorIndexType.values()).filter(vectorIndexType -> vectorIndexType.name.equals(type)).findFirst();
        }

        private VectorIndexType(String name, boolean quantized) {
            this.name = name;
            this.quantized = quantized;
        }

        public abstract DenseVectorIndexOptions parseIndexOptions(String var1, Map<String, ?> var2, IndexVersion var3);

        public abstract boolean supportsElementType(ElementType var1);

        public abstract boolean supportsDimension(int var1);

        public boolean isQuantized() {
            return this.quantized;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ElementType {
        BYTE,
        FLOAT,
        BIT;


        public static ElementType fromString(String name) {
            return ElementType.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    private class IndexedSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private FloatVectorValues floatValues;
        private ByteVectorValues byteValues;
        private NumericDocValues magnitudeReader;
        private boolean hasValue;
        private boolean hasMagnitude;
        private int ord;
        private final IndexVersion indexCreatedVersion;
        private final VectorSimilarity vectorSimilarity;
        private final Thread creationThread;

        private IndexedSyntheticFieldLoader(IndexVersion indexCreatedVersion, VectorSimilarity vectorSimilarity) {
            this.indexCreatedVersion = indexCreatedVersion;
            this.vectorSimilarity = vectorSimilarity;
            this.creationThread = Thread.currentThread();
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
            this.floatValues = reader.getFloatVectorValues(DenseVectorFieldMapper.this.fullPath());
            if (this.floatValues != null) {
                if (this.shouldNormalize()) {
                    this.magnitudeReader = reader.getNumericDocValues(DenseVectorFieldMapper.this.fullPath() + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX);
                }
                return this.createLoader(this.floatValues.iterator(), true);
            }
            this.byteValues = reader.getByteVectorValues(DenseVectorFieldMapper.this.fullPath());
            if (this.byteValues != null) {
                return this.createLoader(this.byteValues.iterator(), false);
            }
            return null;
        }

        private boolean shouldNormalize() {
            return this.indexCreatedVersion.onOrAfter(NORMALIZE_COSINE) && VectorSimilarity.COSINE.equals((Object)this.vectorSimilarity);
        }

        private SourceLoader.SyntheticFieldLoader.DocValuesLoader createLoader(KnnVectorValues.DocIndexIterator iterator, boolean checkMagnitude) {
            return docId -> {
                assert (this.creationThread == Thread.currentThread()) : "Thread mismatch: created by [" + String.valueOf(this.creationThread) + "], but accessed by [" + String.valueOf(Thread.currentThread()) + "]";
                if (iterator.docID() > docId) {
                    this.hasValue = false;
                    return false;
                }
                if (iterator.docID() == docId || iterator.advance(docId) == docId) {
                    this.ord = iterator.index();
                    this.hasValue = true;
                    this.hasMagnitude = checkMagnitude && this.magnitudeReader != null && this.magnitudeReader.advanceExact(docId);
                } else {
                    this.hasValue = false;
                }
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            float magnitude = this.hasMagnitude ? Float.intBitsToFloat((int)this.magnitudeReader.longValue()) : Float.NaN;
            b.startArray(DenseVectorFieldMapper.this.leafName());
            if (this.floatValues != null) {
                for (float v : this.floatValues.vectorValue(this.ord)) {
                    b.value(this.hasMagnitude ? v * magnitude : v);
                }
            } else if (this.byteValues != null) {
                for (byte v : this.byteValues.vectorValue(this.ord)) {
                    b.value(v);
                }
            }
            b.endArray();
        }

        private List<?> copyVectorAsList() throws IOException {
            assert (this.hasValue) : "vector is null for ord=" + this.ord;
            if (this.floatValues != null) {
                float[] raw = this.floatValues.vectorValue(this.ord);
                ArrayList<Float> copyList = new ArrayList<Float>(raw.length);
                if (this.hasMagnitude) {
                    float mag = Float.intBitsToFloat((int)this.magnitudeReader.longValue());
                    for (int i = 0; i < raw.length; ++i) {
                        copyList.add(Float.valueOf(raw[i] * mag));
                    }
                } else {
                    for (int i = 0; i < raw.length; ++i) {
                        copyList.add(Float.valueOf(raw[i]));
                    }
                }
                return copyList;
            }
            if (this.byteValues != null) {
                byte[] raw = this.byteValues.vectorValue(this.ord);
                ArrayList<Byte> copyList = new ArrayList<Byte>(raw.length);
                for (int i = 0; i < raw.length; ++i) {
                    copyList.add(raw[i]);
                }
                return copyList;
            }
            throw new IllegalStateException("No vector values available to copy.");
        }

        @Override
        public String fieldName() {
            return DenseVectorFieldMapper.this.fullPath();
        }
    }

    private class DocValuesSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private BinaryDocValues values;
        private boolean hasValue;
        private final IndexVersion indexCreatedVersion;

        private DocValuesSyntheticFieldLoader(IndexVersion indexCreatedVersion) {
            this.indexCreatedVersion = indexCreatedVersion;
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getBinaryDocValues(DenseVectorFieldMapper.this.fullPath());
            if (this.values == null) {
                return null;
            }
            return docId -> {
                if (this.values.docID() > docId) {
                    this.hasValue = false;
                    return false;
                }
                if (this.values.docID() == docId) {
                    this.hasValue = true;
                    return true;
                }
                this.hasValue = docId == this.values.advance(docId);
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(DenseVectorFieldMapper.this.leafName());
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length);
            if (this.indexCreatedVersion.onOrAfter(LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION)) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int dims = DenseVectorFieldMapper.this.fieldType().element.elementType() == ElementType.BIT ? DenseVectorFieldMapper.this.fieldType().dims / 8 : DenseVectorFieldMapper.this.fieldType().dims;
            for (int dim = 0; dim < dims; ++dim) {
                DenseVectorFieldMapper.this.fieldType().element.readAndWriteValue(byteBuffer, b);
            }
            b.endArray();
        }

        @Override
        public String fieldName() {
            return DenseVectorFieldMapper.this.fullPath();
        }
    }

    public static enum FilterHeuristic {
        FANOUT{
            static final KnnSearchStrategy FANOUT_STRATEGY = new KnnSearchStrategy.Hnsw(0);

            @Override
            public KnnSearchStrategy getKnnSearchStrategy() {
                return FANOUT_STRATEGY;
            }
        }
        ,
        ACORN{
            static final KnnSearchStrategy ACORN_STRATEGY = new KnnSearchStrategy.Hnsw(60);

            @Override
            public KnnSearchStrategy getKnnSearchStrategy() {
                return ACORN_STRATEGY;
            }
        };


        public abstract KnnSearchStrategy getKnnSearchStrategy();
    }

    private static class ByteElement
    extends Element {
        private ByteElement() {
        }

        @Override
        public ElementType elementType() {
            return ElementType.BYTE;
        }

        @Override
        public void writeValue(ByteBuffer byteBuffer, float value) {
            byteBuffer.put((byte)value);
        }

        @Override
        public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
            b.value(byteBuffer.get());
        }

        private KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
            if (vector == null) {
                throw new IllegalArgumentException("vector value must not be null");
            }
            FieldType denseVectorFieldType = new FieldType();
            denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.BYTE, function);
            denseVectorFieldType.freeze();
            return new KnnByteVectorField(name, vector, denseVectorFieldType);
        }

        @Override
        IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
            return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this.elementType(), denseVectorFieldType.dims, denseVectorFieldType.indexed, r -> r);
        }

        @Override
        StringBuilder checkVectorErrors(float[] vector) {
            StringBuilder errors = super.checkNanAndInfinite(vector);
            if (errors != null) {
                return errors;
            }
            for (int index = 0; index < vector.length; ++index) {
                float value = vector[index];
                if (value % 1.0f != 0.0f) {
                    errors = new StringBuilder("element_type [" + String.valueOf((Object)this.elementType()) + "] vectors only support non-decimal values but found decimal value [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (!(value < -128.0f) && !(value > 127.0f)) continue;
                errors = new StringBuilder("element_type [" + String.valueOf((Object)this.elementType()) + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                break;
            }
            return errors;
        }

        @Override
        void checkVectorMagnitude(VectorSimilarity similarity, UnaryOperator<StringBuilder> appender, float squaredMagnitude) {
            StringBuilder errorBuilder = null;
            if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                errorBuilder = new StringBuilder("The [" + String.valueOf((Object)VectorSimilarity.COSINE) + "] similarity does not support vectors with zero magnitude.");
            }
            if (errorBuilder != null) {
                throw new IllegalArgumentException(((StringBuilder)appender.apply(errorBuilder)).toString());
            }
        }

        @Override
        public double computeSquaredMagnitude(VectorData vectorData) {
            return VectorUtil.dotProduct((byte[])vectorData.asByteVector(), (byte[])vectorData.asByteVector());
        }

        @Override
        public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
            VectorData vectorData = this.parseKnnVector(context, fieldMapper.fieldType().dims, (i, end) -> {
                if (end) {
                    fieldMapper.checkDimensionMatches(i, context);
                } else {
                    fieldMapper.checkDimensionExceeded(i, context);
                }
            }, fieldMapper.fieldType().similarity);
            KnnByteVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vectorData.asByteVector(), fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this.elementType()));
            context.doc().addWithKey(fieldMapper.fieldType().name(), (IndexableField)field);
        }

        VectorData parseVectorArray(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
            int index = 0;
            byte[] vector = new byte[dims];
            float squaredMagnitude = 0.0f;
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                int value;
                dimChecker.accept(index, false);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                if (context.parser().numberType() != XContentParser.NumberType.INT) {
                    float floatValue = context.parser().floatValue(true);
                    if (floatValue % 1.0f != 0.0f) {
                        throw new IllegalArgumentException("element_type [" + String.valueOf((Object)this.elementType()) + "] vectors only support non-decimal values but found decimal value [" + floatValue + "] at dim [" + index + "];");
                    }
                    value = (int)floatValue;
                } else {
                    value = context.parser().intValue(true);
                }
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("element_type [" + String.valueOf((Object)this.elementType()) + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                }
                vector[index++] = (byte)value;
                squaredMagnitude += (float)(value * value);
                token = context.parser().nextToken();
            }
            dimChecker.accept(index, true);
            this.checkVectorMagnitude(similarity, ByteElement.errorElementsAppender(vector), squaredMagnitude);
            return VectorData.fromBytes(vector);
        }

        VectorData parseHexEncodedVector(DocumentParserContext context, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
            byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
            dimChecker.accept(decodedVector.length, true);
            VectorData vectorData = VectorData.fromBytes(decodedVector);
            double squaredMagnitude = this.computeSquaredMagnitude(vectorData);
            this.checkVectorMagnitude(similarity, ByteElement.errorElementsAppender(decodedVector), (float)squaredMagnitude);
            return vectorData;
        }

        @Override
        public VectorData parseKnnVector(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
            XContentParser.Token token = context.parser().currentToken();
            return switch (token) {
                case XContentParser.Token.START_ARRAY -> this.parseVectorArray(context, dims, dimChecker, similarity);
                case XContentParser.Token.VALUE_STRING -> this.parseHexEncodedVector(context, dimChecker, similarity);
                default -> throw new ParsingException(context.parser().getTokenLocation(), Strings.format("Unsupported type [%s] for provided value [%s]", token, context.parser().text()), new Object[0]);
            };
        }

        @Override
        public int getNumBytes(int dimensions) {
            return dimensions;
        }

        @Override
        public ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
            return ByteBuffer.wrap(new byte[numBytes]);
        }

        @Override
        public int parseDimensionCount(DocumentParserContext context) throws IOException {
            XContentParser.Token currentToken = context.parser().currentToken();
            return switch (currentToken) {
                case XContentParser.Token.START_ARRAY -> {
                    int index = 0;
                    XContentParser.Token token = context.parser().nextToken();
                    while (token != XContentParser.Token.END_ARRAY) {
                        ++index;
                        token = context.parser().nextToken();
                    }
                    yield index;
                }
                case XContentParser.Token.VALUE_STRING -> {
                    byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
                    yield decodedVector.length;
                }
                default -> throw new ParsingException(context.parser().getTokenLocation(), Strings.format("Unsupported type [%s] for provided value [%s]", currentToken, context.parser().text()), new Object[0]);
            };
        }

        static StringBuilder appendErrorElements(StringBuilder errorBuilder, byte[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        static UnaryOperator<StringBuilder> errorElementsAppender(byte[] vector) {
            return sb -> ByteElement.appendErrorElements(sb, vector);
        }
    }

    private static class FloatElement
    extends Element {
        private FloatElement() {
        }

        @Override
        public ElementType elementType() {
            return ElementType.FLOAT;
        }

        @Override
        public void writeValue(ByteBuffer byteBuffer, float value) {
            byteBuffer.putFloat(value);
        }

        @Override
        public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
            b.value(byteBuffer.getFloat());
        }

        private KnnFloatVectorField createKnnVectorField(String name, float[] vector, VectorSimilarityFunction function) {
            if (vector == null) {
                throw new IllegalArgumentException("vector value must not be null");
            }
            FieldType denseVectorFieldType = new FieldType();
            denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.FLOAT32, function);
            denseVectorFieldType.freeze();
            return new KnnFloatVectorField(name, vector, denseVectorFieldType);
        }

        @Override
        IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
            return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this.elementType(), denseVectorFieldType.dims, denseVectorFieldType.indexed, denseVectorFieldType.isNormalized() && denseVectorFieldType.indexed ? r -> new FilterLeafReader(this, (LeafReader)r, (LeafReader)r){
                final /* synthetic */ LeafReader val$r;
                {
                    this.val$r = leafReader;
                    super(arg0);
                }

                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return this.val$r.getCoreCacheHelper();
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return this.val$r.getReaderCacheHelper();
                }

                public FloatVectorValues getFloatVectorValues(String fieldName) throws IOException {
                    FloatVectorValues values = this.in.getFloatVectorValues(fieldName);
                    if (values == null) {
                        return null;
                    }
                    return new DenormalizedCosineFloatVectorValues(values, this.in.getNumericDocValues(fieldName + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX));
                }
            } : r -> r);
        }

        @Override
        void checkVectorMagnitude(VectorSimilarity similarity, UnaryOperator<StringBuilder> appender, float squaredMagnitude) {
            StringBuilder errorBuilder = null;
            if (Float.isNaN(squaredMagnitude) || Float.isInfinite(squaredMagnitude)) {
                errorBuilder = new StringBuilder("NaN or Infinite magnitude detected, this usually means the vector values are too extreme to fit within a float.");
            }
            if (errorBuilder != null) {
                throw new IllegalArgumentException(((StringBuilder)appender.apply(errorBuilder)).toString());
            }
            if (similarity == VectorSimilarity.DOT_PRODUCT && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                errorBuilder = new StringBuilder("The [" + String.valueOf((Object)VectorSimilarity.DOT_PRODUCT) + "] similarity can only be used with unit-length vectors.");
            } else if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                errorBuilder = new StringBuilder("The [" + String.valueOf((Object)VectorSimilarity.COSINE) + "] similarity does not support vectors with zero magnitude.");
            }
            if (errorBuilder != null) {
                throw new IllegalArgumentException(((StringBuilder)appender.apply(errorBuilder)).toString());
            }
        }

        @Override
        public double computeSquaredMagnitude(VectorData vectorData) {
            return VectorUtil.dotProduct((float[])vectorData.asFloatVector(), (float[])vectorData.asFloatVector());
        }

        @Override
        public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
            int index = 0;
            float[] vector = new float[fieldMapper.fieldType().dims.intValue()];
            float squaredMagnitude = 0.0f;
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                fieldMapper.checkDimensionExceeded(index, context);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                float value = context.parser().floatValue(true);
                vector[index++] = value;
                squaredMagnitude += value * value;
                token = context.parser().nextToken();
            }
            fieldMapper.checkDimensionMatches(index, context);
            this.checkVectorBounds(vector);
            this.checkVectorMagnitude(fieldMapper.fieldType().similarity, FloatElement.errorElementsAppender(vector), squaredMagnitude);
            if (fieldMapper.fieldType().isNormalized() && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                float length = (float)Math.sqrt(squaredMagnitude);
                int i = 0;
                while (i < vector.length) {
                    int n = i++;
                    vector[n] = vector[n] / length;
                }
                String fieldName = fieldMapper.fieldType().name() + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX;
                FloatDocValuesField magnitudeField = new FloatDocValuesField(fieldName, length);
                context.doc().addWithKey(fieldName, (IndexableField)magnitudeField);
            }
            KnnFloatVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vector, fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this.elementType()));
            context.doc().addWithKey(fieldMapper.fieldType().name(), (IndexableField)field);
        }

        @Override
        public VectorData parseKnnVector(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
            int index = 0;
            float squaredMagnitude = 0.0f;
            float[] vector = new float[dims];
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                float value;
                dimChecker.accept(index, false);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                vector[index] = value = context.parser().floatValue(true);
                squaredMagnitude += value * value;
                ++index;
                token = context.parser().nextToken();
            }
            dimChecker.accept(index, true);
            this.checkVectorBounds(vector);
            this.checkVectorMagnitude(similarity, FloatElement.errorElementsAppender(vector), squaredMagnitude);
            return VectorData.fromFloats(vector);
        }

        @Override
        public int getNumBytes(int dimensions) {
            return dimensions * 4;
        }

        @Override
        public ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
            return indexVersion.onOrAfter(LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION) ? ByteBuffer.wrap(new byte[numBytes]).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.wrap(new byte[numBytes]);
        }

        static StringBuilder appendErrorElements(StringBuilder errorBuilder, float[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        static UnaryOperator<StringBuilder> errorElementsAppender(float[] vector) {
            return sb -> FloatElement.appendErrorElements(sb, vector);
        }
    }

    private static class BitElement
    extends ByteElement {
        private BitElement() {
        }

        @Override
        public ElementType elementType() {
            return ElementType.BIT;
        }

        @Override
        void checkVectorMagnitude(VectorSimilarity similarity, UnaryOperator<StringBuilder> appender, float squaredMagnitude) {
        }

        @Override
        public double computeSquaredMagnitude(VectorData vectorData) {
            int i;
            int count = 0;
            byte[] byteBits = vectorData.asByteVector();
            int upperBound = byteBits.length & 0xFFFFFFF8;
            for (i = 0; i < upperBound; i += 8) {
                count += Long.bitCount(BitUtil.VH_NATIVE_LONG.get(byteBits, i));
            }
            while (i < byteBits.length) {
                count += Integer.bitCount(byteBits[i] & 0xFF);
                ++i;
            }
            return count;
        }

        @Override
        VectorData parseVectorArray(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
            return super.parseVectorArray(context, dims / 8, (value, isComplete) -> dimChecker.accept(value * 8, isComplete), similarity);
        }

        @Override
        VectorData parseHexEncodedVector(DocumentParserContext context, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
            byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
            dimChecker.accept(decodedVector.length * 8, true);
            return VectorData.fromBytes(decodedVector);
        }

        @Override
        public int getNumBytes(int dimensions) {
            assert (dimensions % 8 == 0);
            return dimensions / 8;
        }

        @Override
        public int parseDimensionCount(DocumentParserContext context) throws IOException {
            return super.parseDimensionCount(context) * 8;
        }

        @Override
        public void checkDimensions(Integer dvDims, int qvDims) {
            super.checkDimensions(dvDims, qvDims * 8);
        }
    }

    public record RescoreVector(float oversample) implements ToXContentObject
    {
        static final String NAME = "rescore_vector";
        static final String OVERSAMPLE = "oversample";

        static RescoreVector fromIndexOptions(Map<String, ?> indexOptionsMap, IndexVersion indexVersion) {
            Object rescoreVectorNode = indexOptionsMap.remove(NAME);
            if (rescoreVectorNode == null) {
                return null;
            }
            Map<String, Object> mappedNode = XContentMapValues.nodeMapValue(rescoreVectorNode, NAME);
            Object oversampleNode = mappedNode.get(OVERSAMPLE);
            if (oversampleNode == null) {
                throw new IllegalArgumentException("Invalid rescore_vector value. Missing required field oversample");
            }
            float oversampleValue = (float)XContentMapValues.nodeDoubleValue(oversampleNode);
            if (oversampleValue == 0.0f && !DenseVectorFieldMapper.allowsZeroRescore(indexVersion)) {
                throw new IllegalArgumentException("oversample must be greater than 1");
            }
            if (oversampleValue < 1.0f && oversampleValue != 0.0f) {
                throw new IllegalArgumentException("oversample must be greater than 1 or exactly 0");
            }
            if (oversampleValue > 10.0f) {
                throw new IllegalArgumentException("oversample must be less than or equal to 10");
            }
            return new RescoreVector(oversampleValue);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field(OVERSAMPLE, this.oversample);
            builder.endObject();
            return builder;
        }
    }

    static class BBQIVFIndexOptions
    extends QuantizedIndexOptions {
        final int clusterSize;
        final double defaultVisitPercentage;

        BBQIVFIndexOptions(int clusterSize, double defaultVisitPercentage, RescoreVector rescoreVector) {
            super(VectorIndexType.BBQ_DISK, rescoreVector);
            this.clusterSize = clusterSize;
            this.defaultVisitPercentage = defaultVisitPercentage;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES920DiskBBQVectorsFormat(this.clusterSize, 16);
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            return update.type.equals((Object)this.type);
        }

        @Override
        boolean doEquals(DenseVectorIndexOptions other) {
            BBQIVFIndexOptions that = (BBQIVFIndexOptions)other;
            return this.clusterSize == that.clusterSize && this.defaultVisitPercentage == that.defaultVisitPercentage && Objects.equals(this.rescoreVector, that.rescoreVector);
        }

        @Override
        int doHashCode() {
            return Objects.hash(this.clusterSize, this.defaultVisitPercentage, this.rescoreVector);
        }

        @Override
        public boolean isFlat() {
            return false;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.field("cluster_size", this.clusterSize);
            builder.field("default_visit_percentage", this.defaultVisitPercentage);
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }
    }

    static class BBQFlatIndexOptions
    extends QuantizedIndexOptions {
        private final int CLASS_NAME_HASH = this.getClass().getName().hashCode();

        BBQFlatIndexOptions(RescoreVector rescoreVector) {
            super(VectorIndexType.BBQ_FLAT, rescoreVector);
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES818BinaryQuantizedVectorsFormat();
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            return update.type.equals((Object)this.type) || update.type.equals((Object)VectorIndexType.BBQ_HNSW) || update.type.equals((Object)VectorIndexType.BBQ_DISK);
        }

        @Override
        boolean doEquals(DenseVectorIndexOptions other) {
            return other instanceof BBQFlatIndexOptions;
        }

        @Override
        int doHashCode() {
            return this.CLASS_NAME_HASH;
        }

        @Override
        public boolean isFlat() {
            return true;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean validateDimension(int dim, boolean throwOnError) {
            boolean supportsDimension = this.type.supportsDimension(dim);
            if (throwOnError && !supportsDimension) {
                throw new IllegalArgumentException(this.type.name + " does not support dimensions fewer than 64; provided=" + dim);
            }
            return supportsDimension;
        }
    }

    public static class BBQHnswIndexOptions
    extends QuantizedIndexOptions {
        private final int m;
        private final int efConstruction;

        public BBQHnswIndexOptions(int m, int efConstruction, RescoreVector rescoreVector) {
            super(VectorIndexType.BBQ_HNSW, rescoreVector);
            this.m = m;
            this.efConstruction = efConstruction;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES818HnswBinaryQuantizedVectorsFormat(this.m, this.efConstruction);
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            return update.type.equals((Object)this.type) && ((BBQHnswIndexOptions)update).m >= this.m || update.type.equals((Object)VectorIndexType.BBQ_DISK);
        }

        @Override
        boolean doEquals(DenseVectorIndexOptions other) {
            BBQHnswIndexOptions that = (BBQHnswIndexOptions)other;
            return this.m == that.m && this.efConstruction == that.efConstruction && Objects.equals(this.rescoreVector, that.rescoreVector);
        }

        @Override
        int doHashCode() {
            return Objects.hash(this.m, this.efConstruction, this.rescoreVector);
        }

        @Override
        public boolean isFlat() {
            return false;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean validateDimension(int dim, boolean throwOnError) {
            boolean supportsDimension = this.type.supportsDimension(dim);
            if (throwOnError && !supportsDimension) {
                throw new IllegalArgumentException(this.type.name + " does not support dimensions fewer than 64; provided=" + dim);
            }
            return supportsDimension;
        }
    }

    public static class HnswIndexOptions
    extends DenseVectorIndexOptions {
        private final int m;
        private final int efConstruction;

        HnswIndexOptions(int m, int efConstruction) {
            super(VectorIndexType.HNSW);
            this.m = m;
            this.efConstruction = efConstruction;
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            if (elementType == ElementType.BIT) {
                return new ES815HnswBitVectorsFormat(this.m, this.efConstruction);
            }
            return new Lucene99HnswVectorsFormat(this.m, this.efConstruction, 1, null);
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            boolean updatable = update.type.equals((Object)this.type);
            if (updatable) {
                HnswIndexOptions hnswIndexOptions = (HnswIndexOptions)update;
                updatable = hnswIndexOptions.m >= this.m;
            }
            return updatable || update.type.equals((Object)VectorIndexType.BBQ_DISK) || update.type.equals((Object)VectorIndexType.INT8_HNSW) && ((Int8HnswIndexOptions)update).m >= this.m || update.type.equals((Object)VectorIndexType.INT4_HNSW) && ((Int4HnswIndexOptions)update).m >= this.m || update.type.equals((Object)VectorIndexType.BBQ_HNSW) && ((BBQHnswIndexOptions)update).m >= this.m;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(DenseVectorIndexOptions o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HnswIndexOptions that = (HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction;
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.m, this.efConstruction);
        }

        @Override
        public boolean isFlat() {
            return false;
        }

        public int m() {
            return this.m;
        }

        public int efConstruction() {
            return this.efConstruction;
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", m=" + this.m + ", ef_construction=" + this.efConstruction + "}";
        }
    }

    public static class Int8HnswIndexOptions
    extends QuantizedIndexOptions {
        private final int m;
        private final int efConstruction;
        private final Float confidenceInterval;

        public Int8HnswIndexOptions(int m, int efConstruction, Float confidenceInterval, RescoreVector rescoreVector) {
            super(VectorIndexType.INT8_HNSW, rescoreVector);
            this.m = m;
            this.efConstruction = efConstruction;
            this.confidenceInterval = confidenceInterval;
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES814HnswScalarQuantizedVectorsFormat(this.m, this.efConstruction, this.confidenceInterval, 7, false);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            if (this.confidenceInterval != null) {
                builder.field("confidence_interval", this.confidenceInterval);
            }
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(DenseVectorIndexOptions o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Int8HnswIndexOptions that = (Int8HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction && Objects.equals(this.confidenceInterval, that.confidenceInterval) && Objects.equals(this.rescoreVector, that.rescoreVector);
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.m, this.efConstruction, this.confidenceInterval, this.rescoreVector);
        }

        @Override
        public boolean isFlat() {
            return false;
        }

        public int m() {
            return this.m;
        }

        public int efConstruction() {
            return this.efConstruction;
        }

        public Float confidenceInterval() {
            return this.confidenceInterval;
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", m=" + this.m + ", ef_construction=" + this.efConstruction + ", confidence_interval=" + this.confidenceInterval + ", rescore_vector=" + String.valueOf(this.rescoreVector == null ? "none" : this.rescoreVector) + "}";
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            boolean updatable;
            if (update.type.equals((Object)this.type)) {
                Int8HnswIndexOptions int8HnswIndexOptions = (Int8HnswIndexOptions)update;
                updatable = int8HnswIndexOptions.m >= this.m;
                updatable &= this.confidenceInterval == null || int8HnswIndexOptions.confidenceInterval != null && this.confidenceInterval.equals(int8HnswIndexOptions.confidenceInterval);
            } else {
                updatable = update.type.equals((Object)VectorIndexType.BBQ_DISK) || update.type.equals((Object)VectorIndexType.INT4_HNSW) && ((Int4HnswIndexOptions)update).m >= this.m || update.type.equals((Object)VectorIndexType.BBQ_HNSW) && ((BBQHnswIndexOptions)update).m >= this.m;
            }
            return updatable;
        }
    }

    static class Int4FlatIndexOptions
    extends QuantizedIndexOptions {
        private final float confidenceInterval;

        Int4FlatIndexOptions(Float confidenceInterval, RescoreVector rescoreVector) {
            super(VectorIndexType.INT4_FLAT, rescoreVector);
            this.confidenceInterval = confidenceInterval == null ? 0.0f : confidenceInterval.floatValue();
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES813Int8FlatVectorFormat(Float.valueOf(this.confidenceInterval), 4, true);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.field("confidence_interval", this.confidenceInterval);
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(DenseVectorIndexOptions o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Int4FlatIndexOptions that = (Int4FlatIndexOptions)o;
            return Objects.equals(Float.valueOf(this.confidenceInterval), Float.valueOf(that.confidenceInterval)) && Objects.equals(this.rescoreVector, that.rescoreVector);
        }

        @Override
        public int doHashCode() {
            return Objects.hash(Float.valueOf(this.confidenceInterval), this.rescoreVector);
        }

        @Override
        public boolean isFlat() {
            return true;
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", confidence_interval=" + this.confidenceInterval + ", rescore_vector=" + String.valueOf(this.rescoreVector) + "}";
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            return update.type.equals((Object)this.type) || update.type.equals((Object)VectorIndexType.HNSW) || update.type.equals((Object)VectorIndexType.INT8_HNSW) || update.type.equals((Object)VectorIndexType.INT4_HNSW) || update.type.equals((Object)VectorIndexType.BBQ_HNSW) || update.type.equals((Object)VectorIndexType.BBQ_FLAT) || update.type.equals((Object)VectorIndexType.BBQ_DISK);
        }
    }

    public static class Int4HnswIndexOptions
    extends QuantizedIndexOptions {
        private final int m;
        private final int efConstruction;
        private final float confidenceInterval;

        public Int4HnswIndexOptions(int m, int efConstruction, Float confidenceInterval, RescoreVector rescoreVector) {
            super(VectorIndexType.INT4_HNSW, rescoreVector);
            this.m = m;
            this.efConstruction = efConstruction;
            this.confidenceInterval = confidenceInterval == null ? 0.0f : confidenceInterval.floatValue();
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES814HnswScalarQuantizedVectorsFormat(this.m, this.efConstruction, Float.valueOf(this.confidenceInterval), 4, true);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.field("confidence_interval", this.confidenceInterval);
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(DenseVectorIndexOptions o) {
            Int4HnswIndexOptions that = (Int4HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction && Objects.equals(Float.valueOf(this.confidenceInterval), Float.valueOf(that.confidenceInterval)) && Objects.equals(this.rescoreVector, that.rescoreVector);
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.m, this.efConstruction, Float.valueOf(this.confidenceInterval), this.rescoreVector);
        }

        @Override
        public boolean isFlat() {
            return false;
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", m=" + this.m + ", ef_construction=" + this.efConstruction + ", confidence_interval=" + this.confidenceInterval + ", rescore_vector=" + String.valueOf(this.rescoreVector == null ? "none" : this.rescoreVector) + "}";
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            boolean updatable = false;
            if (update.type.equals((Object)VectorIndexType.INT4_HNSW)) {
                Int4HnswIndexOptions int4HnswIndexOptions = (Int4HnswIndexOptions)update;
                updatable = int4HnswIndexOptions.m >= this.m && this.confidenceInterval == int4HnswIndexOptions.confidenceInterval;
            } else {
                updatable = update.type.equals((Object)VectorIndexType.BBQ_HNSW) ? ((BBQHnswIndexOptions)update).m >= this.m : update.type.equals((Object)VectorIndexType.BBQ_DISK);
            }
            return updatable;
        }
    }

    static class FlatIndexOptions
    extends DenseVectorIndexOptions {
        FlatIndexOptions() {
            super(VectorIndexType.FLAT);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            builder.endObject();
            return builder;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            if (elementType.equals((Object)ElementType.BIT)) {
                return new ES815BitFlatVectorFormat();
            }
            return new ES813FlatVectorFormat();
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            return true;
        }

        @Override
        public boolean doEquals(DenseVectorIndexOptions o) {
            return o instanceof FlatIndexOptions;
        }

        @Override
        public int doHashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        @Override
        public boolean isFlat() {
            return true;
        }
    }

    static class Int8FlatIndexOptions
    extends QuantizedIndexOptions {
        private final Float confidenceInterval;

        Int8FlatIndexOptions(Float confidenceInterval, RescoreVector rescoreVector) {
            super(VectorIndexType.INT8_FLAT, rescoreVector);
            this.confidenceInterval = confidenceInterval;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            if (this.confidenceInterval != null) {
                builder.field("confidence_interval", this.confidenceInterval);
            }
            if (this.rescoreVector != null) {
                this.rescoreVector.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES813Int8FlatVectorFormat(this.confidenceInterval, 7, false);
        }

        @Override
        boolean doEquals(DenseVectorIndexOptions o) {
            Int8FlatIndexOptions that = (Int8FlatIndexOptions)o;
            return Objects.equals(this.confidenceInterval, that.confidenceInterval) && Objects.equals(this.rescoreVector, that.rescoreVector);
        }

        @Override
        int doHashCode() {
            return Objects.hash(this.confidenceInterval, this.rescoreVector);
        }

        @Override
        public boolean isFlat() {
            return true;
        }

        @Override
        public boolean updatableTo(DenseVectorIndexOptions update) {
            return update.type.equals((Object)this.type) || update.type.equals((Object)VectorIndexType.HNSW) || update.type.equals((Object)VectorIndexType.INT8_HNSW) || update.type.equals((Object)VectorIndexType.INT4_HNSW) || update.type.equals((Object)VectorIndexType.BBQ_HNSW) || update.type.equals((Object)VectorIndexType.INT4_FLAT) || update.type.equals((Object)VectorIndexType.BBQ_FLAT) || update.type.equals((Object)VectorIndexType.BBQ_DISK);
        }
    }

    static abstract class QuantizedIndexOptions
    extends DenseVectorIndexOptions {
        final RescoreVector rescoreVector;

        QuantizedIndexOptions(VectorIndexType type, RescoreVector rescoreVector) {
            super(type);
            this.rescoreVector = rescoreVector;
        }
    }
}

