/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.codec.vectors.diskbbq.ES920DiskBBQVectorsReader;
import org.elasticsearch.index.codec.vectors.diskbbq.ES920DiskBBQVectorsWriter;

public class ES920DiskBBQVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "ES920DiskBBQVectorsFormat";
    public static final String CENTROID_EXTENSION = "cenivf";
    public static final String CLUSTER_EXTENSION = "clivf";
    static final String IVF_META_EXTENSION = "mivf";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final Map<String, FlatVectorsFormat> supportedFormats = Map.of(rawVectorFormat.getName(), rawVectorFormat);
    public static final float DYNAMIC_VISIT_RATIO = 0.0f;
    public static final int DEFAULT_VECTORS_PER_CLUSTER = 384;
    public static final int MIN_VECTORS_PER_CLUSTER = 64;
    public static final int MAX_VECTORS_PER_CLUSTER = 65536;
    public static final int DEFAULT_CENTROIDS_PER_PARENT_CLUSTER = 16;
    public static final int MIN_CENTROIDS_PER_PARENT_CLUSTER = 2;
    public static final int MAX_CENTROIDS_PER_PARENT_CLUSTER = 256;
    private final int vectorPerCluster;
    private final int centroidsPerParentCluster;

    public ES920DiskBBQVectorsFormat(int vectorPerCluster, int centroidsPerParentCluster) {
        super(NAME);
        if (vectorPerCluster < 64 || vectorPerCluster > 65536) {
            throw new IllegalArgumentException("vectorsPerCluster must be between 64 and 65536, got: " + vectorPerCluster);
        }
        if (centroidsPerParentCluster < 2 || centroidsPerParentCluster > 256) {
            throw new IllegalArgumentException("centroidsPerParentCluster must be between 2 and 256, got: " + centroidsPerParentCluster);
        }
        this.vectorPerCluster = vectorPerCluster;
        this.centroidsPerParentCluster = centroidsPerParentCluster;
    }

    public ES920DiskBBQVectorsFormat() {
        this(384, 16);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES920DiskBBQVectorsWriter(rawVectorFormat.getName(), state, rawVectorFormat.fieldsWriter(state), this.vectorPerCluster, this.centroidsPerParentCluster);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        Map<String, FlatVectorsReader> readers = Maps.newHashMapWithExpectedSize(supportedFormats.size());
        for (Map.Entry<String, FlatVectorsFormat> fe : supportedFormats.entrySet()) {
            readers.put(fe.getKey(), fe.getValue().fieldsReader(state));
        }
        return new ES920DiskBBQVectorsReader(state, Collections.unmodifiableMap(readers));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "ES920DiskBBQVectorsFormat(vectorPerCluster=" + this.vectorPerCluster + ")";
    }
}

