/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.NumberDefinition;

public final class FloatingPointReceptacle {
    private final Deque<Object> myContents = new ArrayDeque<Object>();
    private int mySize = 0;

    public static FloatingPointReceptacle of(Access1D<?> values) {
        FloatingPointReceptacle retVal = new FloatingPointReceptacle();
        retVal.append(values);
        return retVal;
    }

    public static FloatingPointReceptacle of(double ... values) {
        FloatingPointReceptacle retVal = new FloatingPointReceptacle();
        retVal.append(values);
        return retVal;
    }

    public static FloatingPointReceptacle of(float ... values) {
        FloatingPointReceptacle retVal = new FloatingPointReceptacle();
        retVal.append(values);
        return retVal;
    }

    public static FloatingPointReceptacle of(int count, double value) {
        FloatingPointReceptacle retVal = new FloatingPointReceptacle();
        retVal.append(count, value);
        return retVal;
    }

    public static FloatingPointReceptacle of(int count, float value) {
        FloatingPointReceptacle retVal = new FloatingPointReceptacle();
        retVal.append(count, value);
        return retVal;
    }

    public static FloatingPointReceptacle of(List<? extends Comparable<?>> values) {
        FloatingPointReceptacle retVal = new FloatingPointReceptacle();
        retVal.append(values);
        return retVal;
    }

    public void append(Access1D<?> part) {
        this.myContents.addLast(part);
        this.mySize += part.size();
    }

    public void append(double ... part) {
        this.myContents.addLast(part);
        this.mySize += part.length;
    }

    public void append(float ... part) {
        this.myContents.addLast(part);
        this.mySize += part.length;
    }

    public void append(FloatingPointReceptacle part) {
        this.myContents.addLast(part);
        this.mySize += part.size();
    }

    public void append(int count, double value) {
        double[] part = new double[count];
        Arrays.fill(part, value);
        this.append(part);
    }

    public void append(int count, float value) {
        float[] part = new float[count];
        Arrays.fill(part, value);
        this.append(part);
    }

    public void append(List<? extends Comparable<?>> part) {
        this.myContents.addLast(part);
        this.mySize += part.size();
    }

    public void clear() {
        this.myContents.clear();
        this.mySize = 0;
    }

    public void prepend(Access1D<?> part) {
        this.myContents.addFirst(part);
        this.mySize += part.size();
    }

    public void prepend(double ... part) {
        this.myContents.addFirst(part);
        this.mySize += part.length;
    }

    public void prepend(float ... part) {
        this.myContents.addFirst(part);
        this.mySize += part.length;
    }

    public void prepend(FloatingPointReceptacle part) {
        this.myContents.addFirst(part);
        this.mySize += part.size();
    }

    public void prepend(int count, double value) {
        double[] part = new double[count];
        Arrays.fill(part, value);
        this.prepend(part);
    }

    public void prepend(int count, float value) {
        float[] part = new float[count];
        Arrays.fill(part, value);
        this.prepend(part);
    }

    public void prepend(List<? extends Comparable<?>> part) {
        this.myContents.addFirst(part);
        this.mySize += part.size();
    }

    public int size() {
        return this.mySize;
    }

    public void supplyTo(double[] destination) {
        this.supplyTo(destination, 0);
    }

    public void supplyTo(float[] destination) {
        this.supplyTo(destination, 0);
    }

    public double[] toDoubles() {
        double[] retVal = new double[this.mySize];
        this.supplyTo(retVal);
        return retVal;
    }

    public float[] toFloats() {
        float[] retVal = new float[this.mySize];
        this.supplyTo(retVal);
        return retVal;
    }

    private int copy(Access1D<?> source, double[] destination, int offset) {
        int limit = Math.min(source.size(), destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = source.doubleValue(s);
        }
        return offset + limit;
    }

    private int copy(Access1D<?> source, float[] destination, int offset) {
        int limit = Math.min(source.size(), destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = source.floatValue(s);
        }
        return offset + limit;
    }

    private int copy(double[] source, double[] destination, int offset) {
        int limit = Math.min(source.length, destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = source[s];
        }
        return offset + limit;
    }

    private int copy(double[] source, float[] destination, int offset) {
        int limit = Math.min(source.length, destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = (float)source[s];
        }
        return offset + limit;
    }

    private int copy(float[] source, double[] destination, int offset) {
        int limit = Math.min(source.length, destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = source[s];
        }
        return offset + limit;
    }

    private int copy(float[] source, float[] destination, int offset) {
        int limit = Math.min(source.length, destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = source[s];
        }
        return offset + limit;
    }

    private int copy(List<? extends Comparable<?>> source, double[] destination, int offset) {
        int limit = Math.min(source.size(), destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = NumberDefinition.doubleValue(source.get(s));
        }
        return offset + limit;
    }

    private int copy(List<? extends Comparable<?>> source, float[] destination, int offset) {
        int limit = Math.min(source.size(), destination.length - offset);
        for (int s = 0; s < limit; ++s) {
            destination[offset + s] = NumberDefinition.floatValue(source.get(s));
        }
        return offset + limit;
    }

    private int supplyTo(double[] destination, int offset) {
        for (Object source : this.myContents) {
            if (source instanceof float[]) {
                offset = this.copy((float[])source, destination, offset);
                continue;
            }
            if (source instanceof double[]) {
                offset = this.copy((double[])source, destination, offset);
                continue;
            }
            if (source instanceof Access1D) {
                offset = this.copy((Access1D)source, destination, offset);
                continue;
            }
            if (source instanceof List) {
                offset = this.copy((List)source, destination, offset);
                continue;
            }
            if (source instanceof FloatingPointReceptacle) {
                offset = ((FloatingPointReceptacle)source).supplyTo(destination, offset);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return offset;
    }

    private int supplyTo(float[] destination, int offset) {
        for (Object source : this.myContents) {
            if (source instanceof float[]) {
                offset = this.copy((float[])source, destination, offset);
                continue;
            }
            if (source instanceof double[]) {
                offset = this.copy((double[])source, destination, offset);
                continue;
            }
            if (source instanceof Access1D) {
                offset = this.copy((Access1D)source, destination, offset);
                continue;
            }
            if (source instanceof List) {
                offset = this.copy((List)source, destination, offset);
                continue;
            }
            if (source instanceof FloatingPointReceptacle) {
                offset = ((FloatingPointReceptacle)source).supplyTo(destination, offset);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return offset;
    }
}

