/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.structure.Access1D;

public final class DataSeries
extends PrimitiveSeries {
    private final Array1D<Double> myValues;

    public static DataSeries copy(Access1D<?> template) {
        return new DataSeries((Array1D<Double>)Array1D.PRIMITIVE64.copy((Access1D)template));
    }

    public static DataSeries copy(double[] template) {
        return new DataSeries((Array1D<Double>)Array1D.PRIMITIVE64.copy(template));
    }

    public static DataSeries wrap(double[] raw) {
        return new DataSeries(Array1D.PRIMITIVE64.wrap(Primitive64Array.wrap(raw)));
    }

    private DataSeries(Array1D<Double> values) {
        this.myValues = values;
    }

    public void modify(BinaryFunction<Double> func, double right) {
        this.myValues.modifyAll(func.second((Double)right));
    }

    public void modify(double left, BinaryFunction<Double> func) {
        this.myValues.modifyAll(func.first((Double)left));
    }

    public void modify(ParameterFunction<Double> func, int param) {
        this.myValues.modifyAll(func.parameter(param));
    }

    public void modify(UnaryFunction<Double> func) {
        this.myValues.modifyAll(func);
    }

    @Override
    public int size() {
        return this.myValues.size();
    }

    @Override
    public double value(int index) {
        return this.myValues.doubleValue(index);
    }

    public void visit(AggregatorFunction<Double> visitor) {
        this.myValues.visitAll(visitor);
    }
}

