/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.Arrays;
import java.util.Collection;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.LongToNumberMap;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public abstract class SimplexSolver
extends LinearSolver {
    private static final NumberContext DEGENERATE = ACCURACY.withScale(8);
    private static final NumberContext PHASE1 = ACCURACY.withScale(7);
    private static final NumberContext PIVOT = ACCURACY.withScale(8);
    private static final NumberContext RATIO = ACCURACY.withScale(8);
    private static final NumberContext WEIGHT = ACCURACY.withPrecision(8).withScale(10);
    private LongToNumberMap<Double> myFixedVariables = null;
    private final IterationPoint myPoint;
    private final SimplexTableau myTableau;

    SimplexSolver(SimplexTableau tableau, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myTableau = tableau;
        this.myPoint = new IterationPoint();
        if (this.isLogProgress()) {
            this.log("", new Object[0]);
            this.log("Created SimplexSolver", new Object[0]);
            this.log("countVariables: {}", tableau.countVariables());
            this.log("countProblemVariables: {}", tableau.countProblemVariables());
            this.log("countSlackVariables: {}", tableau.countSlackVariables());
            this.log("countArtificialVariables: {}", tableau.countArtificialVariables());
            this.log("countVariablesTotally: {}", tableau.countVariablesTotally());
            this.log("countConstraints: {}", tableau.countConstraints());
            this.log("countBasisDeficit: {}", tableau.countBasisDeficit());
        }
        if (this.isLogDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Tableau Created");
        }
    }

    @Override
    public boolean fixVariable(int index, double value) {
        if (value < PrimitiveMath.ZERO) {
            return false;
        }
        boolean retVal = this.myTableau.fixVariable(index, value);
        if (retVal) {
            if (this.myFixedVariables == null) {
                this.myFixedVariables = LongToNumberMap.factory(Primitive64Array.FACTORY).make();
            }
            this.myFixedVariables.put((long)index, value);
            this.myPoint.returnToPhase1();
        }
        return retVal;
    }

    @Override
    public Collection<Equation> generateCutCandidates(double fractionality, boolean ... integer) {
        return this.myTableau.generateCutCandidates(integer, this.options.feasibility, fractionality);
    }

    @Override
    public SimplexTableau.MetaData getEntityMap() {
        return this.myTableau.meta;
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (this.isLogDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Initial Tableau");
        }
        this.resetIterationsCount();
        while (this.isIterationAllowed() && this.needsAnotherIteration()) {
            this.performIteration(this.myPoint);
            this.incrementIterationsCount();
            if (!this.isLogDebug() || !this.isTableauPrintable()) continue;
            this.logDebugTableau("Tableau Iteration");
        }
        if (this.isLogDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Final Tableau");
        }
        return this.buildResult();
    }

    private void cleanUpPhase1Artificials() {
        int[] basis = this.myTableau.getBasis();
        int[] excluded = this.myTableau.getExcluded();
        int colRHS = this.myTableau.countVariablesTotally();
        for (int i = 0; i < basis.length; ++i) {
            if (basis[i] >= 0) continue;
            double rhs = this.myTableau.doubleValue(i, colRHS);
            if (this.options.validate && !PHASE1.isZero(rhs)) {
                this.log("Non-zero RHS artificial variable: {} = {}", i, rhs);
            }
            int enter = -1;
            double maxPivot = PrimitiveMath.ZERO;
            for (int j = 0; j < excluded.length; ++j) {
                int posEnt = excluded[j];
                double pivot = this.myTableau.doubleValue(i, posEnt);
                if (!(pivot > maxPivot) || PIVOT.isZero(pivot)) continue;
                maxPivot = pivot;
                enter = posEnt;
            }
            if (enter < 0) continue;
            this.myPoint.row = i;
            this.myPoint.col = enter;
            this.performIteration(this.myPoint);
        }
    }

    private int getRowObjective() {
        return this.myPoint.isPhase1() ? this.myTableau.countConstraints() + 1 : this.myTableau.countConstraints();
    }

    private double infeasibility() {
        return -this.myTableau.value(true);
    }

    private boolean isTableauPrintable() {
        return this.myTableau.count() <= 512L;
    }

    private void logDebugTableau(String message) {
        this.log(message + "; Basics: " + Arrays.toString(this.myTableau.getBasis()), this.myTableau);
    }

    private int phase() {
        return this.myPoint.isPhase2() ? 2 : 1;
    }

    private double value() {
        return -this.myTableau.value(false);
    }

    @Override
    protected Optimisation.Result buildResult() {
        Optimisation.Result result = super.buildResult();
        if (this.myTableau.isAbleToExtractDual()) {
            return result.multipliers(this.extractMultipliers());
        }
        return result;
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        return -this.myTableau.value(false);
    }

    protected Access1D<?> extractMultipliers() {
        final Primitive1D duals = this.myTableau.sliceDualVariables();
        final boolean[] negative = this.myTableau.meta.negatedDual;
        return new Access1D<Double>(){

            @Override
            public long count() {
                return negative.length;
            }

            @Override
            public double doubleValue(long index) {
                int i = Math.toIntExact(index);
                return negative[i] ? -duals.doubleValue(index) : duals.doubleValue(index);
            }

            @Override
            public Double get(long index) {
                return this.doubleValue(index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    @Override
    protected Access1D<?> extractSolution() {
        int colRHS = this.myTableau.countVariablesTotally();
        Primitive64Store solution = (Primitive64Store)Primitive64Store.FACTORY.make(this.myTableau.countVariables(), 1);
        int numberOfConstraints = this.myTableau.countConstraints();
        for (int row = 0; row < numberOfConstraints; ++row) {
            int variableIndex = this.myTableau.getBasisColumnIndex(row);
            if (variableIndex < 0) continue;
            solution.set((long)variableIndex, this.myTableau.doubleValue(row, colRHS));
        }
        if (this.myFixedVariables != null) {
            for (SparseArray.NonzeroView entry : this.myFixedVariables.nonzeros()) {
                solution.set(entry.index(), entry.doubleValue());
            }
        }
        return solution;
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return false;
    }

    @Override
    protected boolean needsAnotherIteration() {
        if (this.isLogDebug()) {
            this.log();
            this.log("Needs Another Iteration? Phase={} Artificials={} Infeasibility={} Objective={}", this.phase(), this.myTableau.countBasisDeficit(), this.infeasibility(), this.value());
        }
        boolean retVal = false;
        this.myPoint.reset();
        if (this.myPoint.isPhase1() && (PHASE1.isZero(this.infeasibility()) || !this.myTableau.isBasicArtificials())) {
            this.cleanUpPhase1Artificials();
            if (this.isLogDebug()) {
                this.log();
                this.log("Switching to Phase2 with {} artificial variable(s) still in the basis and infeasibility {}.", this.myTableau.countBasisDeficit(), this.infeasibility());
                this.log();
            }
            this.myPoint.switchToPhase2();
            this.setState(Optimisation.State.FEASIBLE);
        }
        this.myPoint.col = this.findNextPivotCol();
        if (this.myPoint.col >= 0) {
            this.myPoint.row = this.findNextPivotRow();
            if (this.myPoint.row >= 0) {
                retVal = true;
            } else {
                if (this.myPoint.isPhase2()) {
                    this.setState(Optimisation.State.UNBOUNDED);
                } else {
                    this.setState(Optimisation.State.INFEASIBLE);
                }
                retVal = false;
            }
        } else {
            if (this.myPoint.isPhase1()) {
                this.setState(Optimisation.State.INFEASIBLE);
            } else {
                this.setState(Optimisation.State.OPTIMAL);
            }
            retVal = false;
        }
        if (this.isLogDebug()) {
            if (retVal) {
                this.log("\n==>>\tRow: {},\tExit: {},\tColumn/Enter: {}.\n", this.myPoint.row, this.myTableau.getBasisColumnIndex(this.myPoint.row), this.myPoint.col);
            } else {
                this.log("\n==>>\tNo more iterations needed/possible.\n", new Object[0]);
            }
        }
        return retVal;
    }

    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        return retVal;
    }

    int findNextPivotCol() {
        int row = this.getRowObjective();
        boolean phase2 = this.myPoint.isPhase2();
        int nbVariables = this.myTableau.countVariables();
        if (this.isLogDebug()) {
            if (this.options.validate) {
                int[] excluded = this.myTableau.getExcluded();
                Primitive1D sliceTableauRow = this.myTableau.sliceTableauRow(row);
                double[] exclVals = new double[excluded.length];
                for (int i = 0; i < exclVals.length; ++i) {
                    exclVals[i] = sliceTableauRow.doubleValue((long)excluded[i]);
                }
                this.log("\nfindNextPivotCol (index of most negative value) among these:\n{}", Arrays.toString(exclVals));
            } else {
                this.log("\nfindNextPivotCol", new Object[0]);
            }
        }
        int retVal = -1;
        double minVal = phase2 ? -GenericSolver.ACCURACY.epsilon() : PrimitiveMath.ZERO;
        for (int j = 0; j < nbVariables; ++j) {
            double tmpVal;
            if (!this.myTableau.isExcluded(j) || !((tmpVal = this.myTableau.doubleValue(row, j)) < minVal) || retVal >= 0 && !WEIGHT.isDifferent(minVal, tmpVal)) continue;
            retVal = j;
            minVal = tmpVal;
            if (!this.isLogDebug()) continue;
            this.log("Col: {}\t=>\tReduced Contribution Weight: {}.", j, tmpVal);
        }
        return retVal;
    }

    int findNextPivotRow() {
        int numerCol = this.myTableau.countVariablesTotally();
        int denomCol = this.myPoint.col;
        boolean phase1 = this.myPoint.isPhase1();
        boolean phase2 = this.myPoint.isPhase2();
        if (this.isLogDebug()) {
            if (this.options.validate) {
                Primitive1D numerators = this.myTableau.sliceBodyColumn(numerCol);
                Primitive1D denominators = this.myTableau.sliceBodyColumn(denomCol);
                Structure1D ratios = Array1D.PRIMITIVE64.copy((Access1D)numerators);
                ((Array1D)ratios).modifyMatching(PrimitiveMath.DIVIDE, denominators);
                this.log("\nfindNextPivotRow (smallest positive ratio) among these:\nNumerators={}\nDenominators={}\nRatios={}", numerators, denominators, ratios);
            } else {
                this.log("\nfindNextPivotRow", new Object[0]);
            }
        }
        int retVal = -1;
        double numer = Double.NaN;
        double denom = Double.NaN;
        double ratio = Double.NaN;
        double minRatio = Double.MAX_VALUE;
        double curDenom = Double.MIN_NORMAL;
        int constraintsCount = this.myTableau.countConstraints();
        for (int i = 0; i < constraintsCount; ++i) {
            numer = Math.abs(this.myTableau.doubleValue(i, numerCol));
            denom = this.myTableau.doubleValue(i, denomCol);
            int basisColumnIndex = this.myTableau.getBasisColumnIndex(i);
            boolean artificial = basisColumnIndex < 0;
            boolean degenerate = artificial && DEGENERATE.isZero(numer);
            boolean specialCase = phase2 && degenerate;
            ratio = specialCase ? PrimitiveMath.ZERO : numer / denom;
            if (!(denom > PrimitiveMath.ZERO) && !specialCase || PIVOT.isZero(denom) || !(ratio >= PrimitiveMath.ZERO) || !(ratio < minRatio) && (RATIO.isDifferent(minRatio, ratio) || !(denom > curDenom))) continue;
            retVal = i;
            minRatio = ratio;
            double d = curDenom = degenerate ? Math.max(denom, PrimitiveMath.ONE) : denom;
            if (!this.isLogDebug()) continue;
            this.log("Row: {}\t=>\tRatio: {},\tNumerator/RHS: {}, \tDenominator/Pivot: {},\tArtificial: {}.", i, ratio, numer, denom, artificial);
        }
        return retVal;
    }

    void performIteration(IterationPoint pivot) {
        double tmpPivotElement = this.myTableau.doubleValue(pivot.row, pivot.col);
        int tmpColRHS = this.myTableau.countVariablesTotally();
        double tmpPivotRHS = this.myTableau.doubleValue(pivot.row, tmpColRHS);
        this.myTableau.pivot(pivot);
        if (this.isLogDebug()) {
            this.log("Iteration Point <{},{}>\tPivot: {} => {}\tRHS: {} => {}.", pivot.row, pivot.col, tmpPivotElement, this.myTableau.doubleValue(pivot.row, pivot.col), tmpPivotRHS, this.myTableau.doubleValue(pivot.row, tmpColRHS));
        }
        if (this.isLogDebug() && this.options.validate) {
            Primitive1D colRHS = this.myTableau.sliceConstraintsRHS();
            double minRHS = Double.MAX_VALUE;
            for (int i = 0; i < colRHS.size(); ++i) {
                double tmpRHS = colRHS.doubleValue((long)i);
                if (!(tmpRHS < minRHS) || !((minRHS = tmpRHS) < PrimitiveMath.ZERO)) continue;
                this.log("Negative RHS {} @ Row: {}", minRHS, i);
                this.log();
            }
            if (minRHS < PrimitiveMath.ZERO && !GenericSolver.ACCURACY.isZero(minRHS) && this.isLogDebug()) {
                this.log("Entire RHS columns: {}", colRHS);
                this.log();
            }
        }
    }

    static abstract class Primitive2D
    implements Access2D<Double>,
    Mutate2D {
        Primitive2D() {
        }

        @Override
        public final long countColumns() {
            return this.getColDim();
        }

        @Override
        public final long countRows() {
            return this.getRowDim();
        }

        @Override
        public final double doubleValue(long row, long col) {
            return this.doubleValue(Math.toIntExact(row), Math.toIntExact(col));
        }

        @Override
        public final Double get(long row, long col) {
            return this.doubleValue(Math.toIntExact(row), Math.toIntExact(col));
        }

        @Override
        public abstract int getColDim();

        @Override
        public abstract int getRowDim();

        @Override
        public final void set(long row, long col, Comparable<?> value) {
            this.set(Math.toIntExact(row), Math.toIntExact(col), NumberDefinition.doubleValue(value));
        }

        @Override
        public final void set(long row, long col, double value) {
            this.set(Math.toIntExact(row), Math.toIntExact(col), value);
        }

        public final String toString() {
            return Access2D.toString(this);
        }

        abstract double doubleValue(int var1, int var2);

        abstract void set(int var1, int var2, double var3);
    }

    static abstract class Primitive1D
    implements Access1D<Double>,
    Mutate1D {
        Primitive1D() {
        }

        static Primitive1D of(final double ... values) {
            return new Primitive1D(){

                @Override
                public int size() {
                    return values.length;
                }

                @Override
                double doubleValue(int index) {
                    return values[index];
                }

                @Override
                void set(int index, double value) {
                    values[index] = value;
                }
            };
        }

        @Override
        public final long count() {
            return this.size();
        }

        @Override
        public final double doubleValue(long index) {
            return this.doubleValue(Math.toIntExact(index));
        }

        @Override
        public final Double get(long index) {
            return this.doubleValue(Math.toIntExact(index));
        }

        @Override
        public final void set(long index, Comparable<?> value) {
            this.set(Math.toIntExact(index), NumberDefinition.doubleValue(value));
        }

        @Override
        public final void set(long index, double value) {
            this.set(Math.toIntExact(index), value);
        }

        @Override
        public abstract int size();

        public final String toString() {
            return Access1D.toString(this);
        }

        abstract double doubleValue(int var1);

        abstract void set(int var1, double var2);
    }

    static final class IterationPoint {
        private boolean myPhase1 = true;
        int col;
        int row;

        IterationPoint() {
            this.reset();
        }

        boolean isPhase1() {
            return this.myPhase1;
        }

        boolean isPhase2() {
            return !this.myPhase1;
        }

        void reset() {
            this.row = -1;
            this.col = -1;
        }

        void returnToPhase1() {
            this.myPhase1 = true;
        }

        void switchToPhase2() {
            this.myPhase1 = false;
        }
    }
}

