/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.OjAlgoUtils;

public final class DaemonPoolExecutor
extends ThreadPoolExecutor {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final ThreadGroup GROUP = new ThreadGroup("ojAlgo-daemon-group");
    static final DaemonPoolExecutor INSTANCE = new DaemonPoolExecutor(OjAlgoUtils.ENVIRONMENT.units, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), DaemonPoolExecutor.newThreadFactory("ojAlgo-daemon-"));

    public static <T> Future<T> invoke(Callable<T> task) {
        return INSTANCE.submit(task);
    }

    public static Future<?> invoke(Runnable task) {
        return INSTANCE.submit(task);
    }

    public static <T> Future<T> invoke(Runnable task, T result) {
        return INSTANCE.submit(task, result);
    }

    public static ExecutorService newCachedThreadPool(String name) {
        return Executors.newCachedThreadPool(DaemonPoolExecutor.newThreadFactory(name));
    }

    public static ExecutorService newFixedThreadPool(String name, int nThreads) {
        return Executors.newFixedThreadPool(nThreads, DaemonPoolExecutor.newThreadFactory(name));
    }

    public static ExecutorService newScheduledThreadPool(String name, int corePoolSize) {
        return Executors.newScheduledThreadPool(corePoolSize, DaemonPoolExecutor.newThreadFactory(name));
    }

    public static ExecutorService newSingleThreadExecutor(String name) {
        return Executors.newSingleThreadExecutor(DaemonPoolExecutor.newThreadFactory(name));
    }

    public static ExecutorService newSingleThreadScheduledExecutor(String name) {
        return Executors.newSingleThreadScheduledExecutor(DaemonPoolExecutor.newThreadFactory(name));
    }

    public static ThreadFactory newThreadFactory(String name) {
        return DaemonPoolExecutor.newThreadFactory(GROUP, name);
    }

    public static ThreadFactory newThreadFactory(ThreadGroup group, String name) {
        String prefix = name.endsWith("-") ? name : name + "-";
        return target -> {
            Thread thread = new Thread(group, target, prefix + COUNTER.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        };
    }

    DaemonPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    DaemonPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    DaemonPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    DaemonPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }
}

