/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.ann;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.ojalgo.ann.ArtificialNeuralNetwork;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive32Store;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Structure2D;

abstract class FileFormat {
    private static final String FORMAT = "ojAlgo ANN";

    FileFormat() {
    }

    static ArtificialNeuralNetwork read(PhysicalStore.Factory<Double, ?> factory, DataInput input) throws IOException {
        String format = input.readUTF();
        if (!FORMAT.equals(format)) {
            throw new IOException("Unsupported format!");
        }
        int version = input.readInt();
        switch (version) {
            case 1: {
                return Version1.read(factory, input);
            }
            case 2: {
                return Version2.read(factory, input);
            }
        }
        throw new IOException("Unsupported version!");
    }

    static void write(ArtificialNeuralNetwork network, int version, DataOutput output) throws IOException {
        output.writeUTF(FORMAT);
        output.writeInt(version);
        switch (version) {
            case 1: {
                Version1.write(network, output);
                break;
            }
            case 2: {
                Version2.write(network, output);
                break;
            }
            default: {
                throw new IOException("Unsupported version!");
            }
        }
    }

    static abstract class Version2 {
        static final int ID = 2;

        Version2() {
        }

        static ArtificialNeuralNetwork read(PhysicalStore.Factory<Double, ?> factory, DataInput input) throws IOException {
            int numberOfInputs = input.readInt();
            int numberOfLayers = input.readInt();
            int[] layerOutputs = new int[numberOfLayers];
            for (int i = 0; i < numberOfLayers; ++i) {
                layerOutputs[i] = input.readInt();
            }
            ArtificialNeuralNetwork retVal = new ArtificialNeuralNetwork(factory != null ? factory : Primitive32Store.FACTORY, numberOfInputs, layerOutputs);
            for (int l = 0; l < numberOfLayers; ++l) {
                int numberOfOutputs = layerOutputs[l];
                for (int j = 0; j < numberOfOutputs; ++j) {
                    retVal.setBias(l, j, input.readFloat());
                    for (int i = 0; i < numberOfInputs; ++i) {
                        retVal.setWeight(l, i, j, input.readFloat());
                    }
                }
                retVal.setActivator(l, ArtificialNeuralNetwork.Activator.valueOf(input.readUTF()));
                numberOfInputs = numberOfOutputs;
            }
            return retVal;
        }

        static void write(ArtificialNeuralNetwork network, DataOutput output) throws IOException {
            Structure2D[] structure = network.structure();
            output.writeInt(Math.toIntExact(structure[0].countRows()));
            output.writeInt(structure.length);
            for (int l = 0; l < structure.length; ++l) {
                output.writeInt(Math.toIntExact(structure[l].countColumns()));
            }
            for (int l = 0; l < structure.length; ++l) {
                int numberofInputs = Math.toIntExact(structure[l].countRows());
                int numberofOutputs = Math.toIntExact(structure[l].countColumns());
                for (int j = 0; j < numberofOutputs; ++j) {
                    output.writeFloat((float)network.getBias(l, j));
                    for (int i = 0; i < numberofInputs; ++i) {
                        output.writeFloat((float)network.getWeight(l, i, j));
                    }
                }
                output.writeUTF(network.getActivator(l).name());
            }
        }
    }

    static abstract class Version1 {
        static final int ID = 1;

        Version1() {
        }

        static ArtificialNeuralNetwork read(PhysicalStore.Factory<Double, ?> factory, DataInput input) throws IOException {
            int numberOfInputs = input.readInt();
            int numberOfLayers = input.readInt();
            int[] layerOutputs = new int[numberOfLayers];
            for (int i = 0; i < numberOfLayers; ++i) {
                layerOutputs[i] = input.readInt();
            }
            ArtificialNeuralNetwork retVal = new ArtificialNeuralNetwork(factory != null ? factory : Primitive64Store.FACTORY, numberOfInputs, layerOutputs);
            for (int l = 0; l < numberOfLayers; ++l) {
                int numberOfOutputs = layerOutputs[l];
                for (int j = 0; j < numberOfOutputs; ++j) {
                    retVal.setBias(l, j, input.readDouble());
                    for (int i = 0; i < numberOfInputs; ++i) {
                        retVal.setWeight(l, i, j, input.readDouble());
                    }
                }
                retVal.setActivator(l, ArtificialNeuralNetwork.Activator.valueOf(input.readUTF()));
                numberOfInputs = numberOfOutputs;
            }
            return retVal;
        }

        static void write(ArtificialNeuralNetwork network, DataOutput output) throws IOException {
            Structure2D[] structure = network.structure();
            output.writeInt(Math.toIntExact(structure[0].countRows()));
            output.writeInt(structure.length);
            for (int l = 0; l < structure.length; ++l) {
                output.writeInt(Math.toIntExact(structure[l].countColumns()));
            }
            for (int l = 0; l < structure.length; ++l) {
                int numberofInputs = Math.toIntExact(structure[l].countRows());
                int numberofOutputs = Math.toIntExact(structure[l].countColumns());
                for (int j = 0; j < numberofOutputs; ++j) {
                    output.writeDouble(network.getBias(l, j));
                    for (int i = 0; i < numberofInputs; ++i) {
                        output.writeDouble(network.getWeight(l, i, j));
                    }
                }
                output.writeUTF(network.getActivator(l).name());
            }
        }
    }
}

