/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.CentroidPointAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointDocValuesAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("xVal", ElementType.DOUBLE), new IntermediateStateDesc("xDel", ElementType.DOUBLE), new IntermediateStateDesc("yVal", ElementType.DOUBLE), new IntermediateStateDesc("yDel", ElementType.DOUBLE), new IntermediateStateDesc("count", ElementType.LONG));
    private final CentroidPointAggregator.GroupingCentroidState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction(List<Integer> channels, CentroidPointAggregator.GroupingCentroidState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction(channels, SpatialCentroidGeoPointDocValuesAggregator.initGrouping(driverContext.bigArrays()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock encodedBlock = (LongBlock)page.getBlock(this.channels.get(0));
        final LongVector encodedVector = encodedBlock.asVector();
        if (encodedVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, encodedBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, encodedBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, encodedBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, encodedBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, encodedVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, encodedVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SpatialCentroidGeoPointDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, encodedVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, LongBlock encodedBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || encodedBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int encodedStart = encodedBlock.getFirstValueIndex(valuesPosition);
                int encodedEnd = encodedStart + encodedBlock.getValueCount(valuesPosition);
                for (int encodedOffset = encodedStart; encodedOffset < encodedEnd; ++encodedOffset) {
                    long encodedValue = encodedBlock.getLong(encodedOffset);
                    SpatialCentroidGeoPointDocValuesAggregator.combine(this.state, groupId, encodedValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, LongVector encodedVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                long encodedValue = encodedVector.getLong(valuesPosition);
                SpatialCentroidGeoPointDocValuesAggregator.combine(this.state, groupId, encodedValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (xVal.getPositionCount() == xDel.getPositionCount() && xVal.getPositionCount() == yVal.getPositionCount() && xVal.getPositionCount() == yDel.getPositionCount() && xVal.getPositionCount() == count.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialCentroidGeoPointDocValuesAggregator.combineIntermediate(this.state, groupId, xVal.getDouble(valuesPosition), xDel.getDouble(valuesPosition), yVal.getDouble(valuesPosition), yDel.getDouble(valuesPosition), count.getLong(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, LongBlock encodedBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || encodedBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int encodedStart = encodedBlock.getFirstValueIndex(valuesPosition);
                int encodedEnd = encodedStart + encodedBlock.getValueCount(valuesPosition);
                for (int encodedOffset = encodedStart; encodedOffset < encodedEnd; ++encodedOffset) {
                    long encodedValue = encodedBlock.getLong(encodedOffset);
                    SpatialCentroidGeoPointDocValuesAggregator.combine(this.state, groupId, encodedValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, LongVector encodedVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                long encodedValue = encodedVector.getLong(valuesPosition);
                SpatialCentroidGeoPointDocValuesAggregator.combine(this.state, groupId, encodedValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (xVal.getPositionCount() == xDel.getPositionCount() && xVal.getPositionCount() == yVal.getPositionCount() && xVal.getPositionCount() == yDel.getPositionCount() && xVal.getPositionCount() == count.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialCentroidGeoPointDocValuesAggregator.combineIntermediate(this.state, groupId, xVal.getDouble(valuesPosition), xDel.getDouble(valuesPosition), yVal.getDouble(valuesPosition), yDel.getDouble(valuesPosition), count.getLong(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock encodedBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (encodedBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int encodedStart = encodedBlock.getFirstValueIndex(valuesPosition);
            int encodedEnd = encodedStart + encodedBlock.getValueCount(valuesPosition);
            for (int encodedOffset = encodedStart; encodedOffset < encodedEnd; ++encodedOffset) {
                long encodedValue = encodedBlock.getLong(encodedOffset);
                SpatialCentroidGeoPointDocValuesAggregator.combine(this.state, groupId, encodedValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongVector encodedVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            long encodedValue = encodedVector.getLong(valuesPosition);
            SpatialCentroidGeoPointDocValuesAggregator.combine(this.state, groupId, encodedValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (xVal.getPositionCount() == xDel.getPositionCount() && xVal.getPositionCount() == yVal.getPositionCount() && xVal.getPositionCount() == yDel.getPositionCount() && xVal.getPositionCount() == count.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            SpatialCentroidGeoPointDocValuesAggregator.combineIntermediate(this.state, groupId, xVal.getDouble(valuesPosition), xDel.getDouble(valuesPosition), yVal.getDouble(valuesPosition), yDel.getDouble(valuesPosition), count.getLong(valuesPosition));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, LongBlock encodedBlock) {
        if (encodedBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = SpatialCentroidGeoPointDocValuesAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

