/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.util.MathUtils;

public class Limit {
    private final int limit;
    private final int offset;
    private final int total;

    public Limit(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
        this.total = MathUtils.abs(limit) + offset;
    }

    public int limit() {
        return this.limit;
    }

    public int absLimit() {
        return MathUtils.abs(this.limit);
    }

    public int offset() {
        return this.offset;
    }

    public int totalLimit() {
        return this.total;
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.offset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limit other = (Limit)obj;
        return Objects.equals(this.limit, other.limit) && Objects.equals(this.offset, other.offset);
    }

    public <E> List<E> view(List<E> values) {
        int size;
        if (values == null || values.isEmpty()) {
            return values;
        }
        if (this.limit == 0) {
            return Collections.emptyList();
        }
        if (this.limit < 0) {
            values = new ArrayList<E>(values);
            Collections.reverse(values);
        }
        if ((size = values.size()) >= this.total) {
            return values.subList(this.offset, this.total);
        }
        int l = this.absLimit();
        if (size <= l) {
            return values;
        }
        return values.subList(size - l, values.size());
    }
}

