/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlTranslateRequest
extends AbstractSqlQueryRequest {
    private static final ObjectParser<SqlTranslateRequest, Void> PARSER = SqlTranslateRequest.objectParser(SqlTranslateRequest::new);

    public SqlTranslateRequest() {
    }

    public SqlTranslateRequest(String query, List<SqlTypedParamValue> params, QueryBuilder filter, Map<String, Object> runtimeMappings, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo) {
        super(query, params, filter, runtimeMappings, zoneId, null, fetchSize, requestTimeout, pageTimeout, requestInfo);
    }

    public SqlTranslateRequest(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (!Strings.hasText((String)this.query())) {
            validationException = ValidateActions.addValidationError((String)"query is required", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getDescription() {
        return "SQL Translate [" + this.query() + "][" + String.valueOf(this.filter()) + "]";
    }

    public static SqlTranslateRequest fromXContent(XContentParser parser) {
        SqlTranslateRequest request = (SqlTranslateRequest)((Object)PARSER.apply(parser, null));
        SqlTranslateRequest.validateParams(request.params(), request.mode());
        return request;
    }
}

