/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.ThinkingConfig;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiUtils;

public class GoogleVertexAiChatCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "google_vertex_ai_chatcompletion_task_settings";
    private static final TransportVersion GEMINI_THINKING_BUDGET_ADDED = TransportVersion.fromName((String)"gemini_thinking_budget_added");
    private final ThinkingConfig thinkingConfig;
    private final Integer maxTokens;
    public static final GoogleVertexAiChatCompletionTaskSettings EMPTY_SETTINGS = new GoogleVertexAiChatCompletionTaskSettings();
    private static final ThinkingConfig EMPTY_THINKING_CONFIG = new ThinkingConfig();

    public GoogleVertexAiChatCompletionTaskSettings() {
        this.thinkingConfig = EMPTY_THINKING_CONFIG;
        this.maxTokens = null;
    }

    public GoogleVertexAiChatCompletionTaskSettings(ThinkingConfig thinkingConfig, @Nullable Integer maxTokens) {
        this.thinkingConfig = Objects.requireNonNullElse(thinkingConfig, EMPTY_THINKING_CONFIG);
        this.maxTokens = maxTokens;
    }

    public GoogleVertexAiChatCompletionTaskSettings(StreamInput in) throws IOException {
        this.thinkingConfig = new ThinkingConfig(in);
        TransportVersion version = in.getTransportVersion();
        this.maxTokens = GoogleVertexAiUtils.supportsModelGarden(version) ? in.readOptionalVInt() : null;
    }

    public static GoogleVertexAiChatCompletionTaskSettings fromMap(Map<String, Object> taskSettings) {
        ValidationException validationException = new ValidationException();
        ThinkingConfig thinkingConfig = ThinkingConfig.fromMap(taskSettings, validationException);
        Integer maxTokens = ServiceUtils.extractOptionalPositiveInteger(taskSettings, "max_tokens", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiChatCompletionTaskSettings(thinkingConfig, maxTokens);
    }

    public static GoogleVertexAiChatCompletionTaskSettings of(GoogleVertexAiChatCompletionTaskSettings originalTaskSettings, GoogleVertexAiChatCompletionTaskSettings newTaskSettings) {
        ThinkingConfig thinkingConfig = newTaskSettings.thinkingConfig().isEmpty() ? originalTaskSettings.thinkingConfig() : newTaskSettings.thinkingConfig();
        Integer maxTokens = Objects.requireNonNullElse(newTaskSettings.maxTokens(), originalTaskSettings.maxTokens());
        return new GoogleVertexAiChatCompletionTaskSettings(thinkingConfig, maxTokens);
    }

    public ThinkingConfig thinkingConfig() {
        return this.thinkingConfig;
    }

    public Integer maxTokens() {
        return this.maxTokens;
    }

    public boolean isEmpty() {
        return this.thinkingConfig.isEmpty() && Objects.isNull(this.maxTokens);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        GoogleVertexAiChatCompletionTaskSettings newTaskSettings = GoogleVertexAiChatCompletionTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return GoogleVertexAiChatCompletionTaskSettings.of(this, newTaskSettings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return GEMINI_THINKING_BUDGET_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.thinkingConfig.writeTo(out);
        if (GoogleVertexAiUtils.supportsModelGarden(out.getTransportVersion())) {
            out.writeOptionalVInt(this.maxTokens);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.thinkingConfig.toXContent(builder, params);
        builder.field("max_tokens", this.maxTokens);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleVertexAiChatCompletionTaskSettings that = (GoogleVertexAiChatCompletionTaskSettings)o;
        return Objects.equals(this.thinkingConfig, that.thinkingConfig) && Objects.equals(this.maxTokens, that.maxTokens);
    }

    public int hashCode() {
        return Objects.hash(this.thinkingConfig, this.maxTokens);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

