/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsTaskSettings;

public record AlibabaCloudSearchEmbeddingsRequestEntity(List<String> input, InputType inputType, AlibabaCloudSearchEmbeddingsTaskSettings taskSettings) implements ToXContentObject
{
    private static final String SEARCH_DOCUMENT = "document";
    private static final String SEARCH_QUERY = "query";
    private static final String TEXTS_FIELD = "input";
    public static final String INPUT_TYPE_FIELD = "input_type";

    public AlibabaCloudSearchEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TEXTS_FIELD, this.input);
        if (InputType.isSpecified((InputType)this.inputType)) {
            builder.field(INPUT_TYPE_FIELD, AlibabaCloudSearchEmbeddingsRequestEntity.convertToString(this.inputType));
        } else if (InputType.isSpecified((InputType)this.taskSettings.getInputType())) {
            builder.field(INPUT_TYPE_FIELD, AlibabaCloudSearchEmbeddingsRequestEntity.convertToString(this.taskSettings.getInputType()));
        }
        builder.endObject();
        return builder;
    }

    static String convertToString(InputType inputType) {
        if (inputType == null) {
            return null;
        }
        return switch (inputType) {
            case InputType.INGEST, InputType.INTERNAL_INGEST -> SEARCH_DOCUMENT;
            case InputType.SEARCH, InputType.INTERNAL_SEARCH -> SEARCH_QUERY;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)InputType.invalidInputTypeMessage((InputType)inputType));
                }
                yield null;
            }
        };
    }
}

