/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.search.SearchApplicationListItem;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public class ListSearchApplicationAction {
    public static final String NAME = "cluster:admin/xpack/application/search_application/list";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/application/search_application/list");

    private ListSearchApplicationAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField RESULT_FIELD = new ParseField("results", new String[0]);
        final QueryPage<SearchApplicationListItem> queryPage;

        public Response(StreamInput in) throws IOException {
            this.queryPage = new QueryPage(in, SearchApplicationListItem::new);
        }

        public Response(List<SearchApplicationListItem> items, Long totalResults) {
            this.queryPage = new QueryPage(items, totalResults.longValue(), RESULT_FIELD);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.queryPage.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryPage.toXContent(builder, params);
        }

        public QueryPage<SearchApplicationListItem> queryPage() {
            return this.queryPage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.queryPage.equals(that.queryPage);
        }

        public int hashCode() {
            return this.queryPage.hashCode();
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private static final String DEFAULT_QUERY = "*";
        public static final ParseField QUERY = new ParseField("query", new String[0]);
        public static final ParseField PAGE_PARAMS = new ParseField("pageParams", new String[0]);
        private final String query;
        private final PageParams pageParams;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("list_search_application_request", p -> new Request((String)p[0], (PageParams)p[1]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.query = in.readString();
            this.pageParams = new PageParams(in);
        }

        public Request(@Nullable String query, PageParams pageParams) {
            this.query = Objects.requireNonNullElse(query, DEFAULT_QUERY);
            this.pageParams = pageParams;
        }

        public String query() {
            return this.query;
        }

        public PageParams pageParams() {
            return this.pageParams;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isEmpty((CharSequence)this.query())) {
                validationException = ValidateActions.addValidationError((String)"Search Application query is missing", validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.query);
            this.pageParams.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.query, that.query) && Objects.equals(this.pageParams, that.pageParams);
        }

        public int hashCode() {
            return Objects.hash(this.query, this.pageParams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(QUERY.getPreferredName(), this.query);
            builder.field(PAGE_PARAMS.getPreferredName(), (ToXContent)this.pageParams);
            builder.endObject();
            return null;
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), QUERY);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PageParams.fromXContent((XContentParser)p), PAGE_PARAMS);
        }
    }
}

