/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.SimpleHealthIndicatorDetails;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class IlmHealthIndicatorService
implements HealthIndicatorService {
    public static final String NAME = "ilm";
    public static final String HELP_URL = "https://ela.st/fix-ilm";
    public static final Diagnosis ILM_NOT_RUNNING = new Diagnosis(new Diagnosis.Definition("ilm", "ilm_disabled", "Index Lifecycle Management is stopped", "Start Index Lifecycle Management using [POST /_ilm/start].", "https://ela.st/fix-ilm"), null);
    static final Setting<TimeValue> MAX_TIME_ON_ACTION_SETTING = Setting.timeSetting((String)"health.ilm.max_time_on_action", (TimeValue)new TimeValue(1L, TimeUnit.DAYS), (TimeValue)new TimeValue(1L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<TimeValue> MAX_TIME_ON_STEP_SETTING = Setting.timeSetting((String)"health.ilm.max_time_on_step", (TimeValue)new TimeValue(1L, TimeUnit.DAYS), (TimeValue)new TimeValue(1L, TimeUnit.DAYS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<Long> MAX_RETRIES_PER_STEP_SETTING = Setting.longSetting((String)"health.ilm.max_retries_per_step", (long)100L, (long)2L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final String AUTOMATION_DISABLED_IMPACT_ID = "automation_disabled";
    public static final String STAGNATING_INDEX_IMPACT_ID = "stagnating_index";
    public static final List<HealthIndicatorImpact> AUTOMATION_DISABLED_IMPACT = List.of(new HealthIndicatorImpact("ilm", "automation_disabled", 3, "Automatic index lifecycle and data retention management is disabled. The performance and stability of the cluster could be impacted.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)));
    public static final List<HealthIndicatorImpact> STAGNATING_INDEX_IMPACT = List.of(new HealthIndicatorImpact("ilm", "stagnating_index", 3, "Automatic index lifecycle and data retention management cannot make progress on one or more indices. The performance and stability of the indices and/or the cluster could be impacted.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)));
    static final Map<String, RuleCreator> RULES_BY_ACTION_CONFIG = Map.of("rollover", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("rollover").stepRules(StepRule.stepRuleFullChecks("wait-for-active-shards", maxTimeOnStep, maxRetries), StepRule.stepRuleOnlyCheckRetries("check-rollover-ready", maxRetries), StepRule.stepRuleFullChecks("attempt-rollover", maxTimeOnStep, maxRetries)), "migrate", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("migrate").maxTimeOnAction(maxTimeOnAction).noStepRules(), "searchable_snapshot", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("searchable_snapshot").maxTimeOnAction(maxTimeOnAction).stepRules(StepRule.stepRuleFullChecks("wait-for-data-tier", maxTimeOnStep, maxRetries), StepRule.stepRuleFullChecks("wait-for-index-color", maxTimeOnStep, maxRetries), StepRule.stepRuleOnlyCheckRetries("wait-for-shard-history-leases", maxRetries)), "delete", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("delete").stepRules(StepRule.stepRuleFullChecks("delete", maxTimeOnStep, maxRetries)), "shrink", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("shrink").maxTimeOnAction(maxTimeOnAction).stepRules(StepRule.stepRuleOnlyCheckRetries("wait-for-shard-history-leases", maxRetries)), "allocate", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("allocate").maxTimeOnAction(maxTimeOnAction).noStepRules(), "forcemerge", (maxTimeOnAction, maxTimeOnStep, maxRetries) -> RuleConfig.Builder.actionRule("forcemerge").maxTimeOnAction(maxTimeOnAction).stepRules(StepRule.stepRuleFullChecks("wait-for-index-color", maxTimeOnStep, maxRetries), StepRule.stepRuleFullChecks("forcemerge", maxTimeOnStep, maxRetries), StepRule.stepRuleFullChecks("segment-count", maxTimeOnStep, maxRetries)));
    static final Map<String, Diagnosis.Definition> STAGNATING_ACTION_DEFINITIONS = RULES_BY_ACTION_CONFIG.keySet().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), action -> new Diagnosis.Definition(NAME, "stagnating_action:" + action, "Some indices have been stagnated on the action [" + action + "] longer than the expected time.", "Check the current status of the Index Lifecycle Management for every affected index using the [GET /<affected_index_name>/_ilm/explain] API. Please replace the <affected_index_name> in the API with the actual index name.", "https://ela.st/ilm-explain")));
    private final ClusterService clusterService;
    private final StagnatingIndicesFinder stagnatingIndicesFinder;

    public IlmHealthIndicatorService(ClusterService clusterService, StagnatingIndicesFinder stagnatingIndicesFinder) {
        this.clusterService = clusterService;
        this.stagnatingIndicesFinder = stagnatingIndicesFinder;
    }

    public String name() {
        return NAME;
    }

    public HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
        ProjectMetadata projectMetadata = IlmHealthIndicatorService.getDefaultILMProject(this.clusterService.state());
        IndexLifecycleMetadata ilmMetadata = (IndexLifecycleMetadata)projectMetadata.custom("index_lifecycle", (Metadata.ProjectCustom)IndexLifecycleMetadata.EMPTY);
        OperationMode currentMode = LifecycleOperationMetadata.currentILMMode((ProjectMetadata)projectMetadata);
        if (ilmMetadata.getPolicyMetadatas().isEmpty()) {
            return this.createIndicator(HealthStatus.GREEN, "No Index Lifecycle Management policies configured", IlmHealthIndicatorService.createDetails(verbose, ilmMetadata, currentMode), List.of(), List.of());
        }
        if (currentMode != OperationMode.RUNNING) {
            return this.createIndicator(HealthStatus.YELLOW, "Index Lifecycle Management is not running", IlmHealthIndicatorService.createDetails(verbose, ilmMetadata, currentMode), AUTOMATION_DISABLED_IMPACT, verbose ? List.of(ILM_NOT_RUNNING) : List.of());
        }
        List<IndexMetadata> stagnatingIndices = this.stagnatingIndicesFinder.find();
        if (stagnatingIndices.isEmpty()) {
            return this.createIndicator(HealthStatus.GREEN, "Index Lifecycle Management is running", IlmHealthIndicatorService.createDetails(verbose, ilmMetadata, currentMode), List.of(), List.of());
        }
        return this.createIndicator(HealthStatus.YELLOW, (String)(stagnatingIndices.size() > 1 ? stagnatingIndices.size() + " indices have" : "An index has") + " stayed on the same action longer than expected.", IlmHealthIndicatorService.createDetails(verbose, ilmMetadata, currentMode, stagnatingIndices), STAGNATING_INDEX_IMPACT, verbose ? IlmHealthIndicatorService.createDiagnoses(stagnatingIndices, maxAffectedResourcesCount) : List.of());
    }

    private static HealthIndicatorDetails createDetails(boolean verbose, IndexLifecycleMetadata ilmMetadata, OperationMode currentMode) {
        return IlmHealthIndicatorService.createDetails(verbose, ilmMetadata, currentMode, List.of());
    }

    private static List<Diagnosis> createDiagnoses(List<IndexMetadata> stagnatingIndices, int maxAffectedResourcesCount) {
        return stagnatingIndices.stream().collect(Collectors.groupingBy(md -> md.getLifecycleExecutionState().action())).entrySet().stream().map(action -> {
            TreeSet affectedIndices = ((List)action.getValue()).stream().map(IndexMetadata::getIndex).map(Index::getName).limit(Math.min(maxAffectedResourcesCount, ((List)action.getValue()).size())).collect(Collectors.toCollection(TreeSet::new));
            TreeSet affectedPolicies = ((List)action.getValue()).stream().map(IndexMetadata::getLifecyclePolicyName).limit(Math.min(maxAffectedResourcesCount, ((List)action.getValue()).size())).collect(Collectors.toCollection(TreeSet::new));
            return new Diagnosis(STAGNATING_ACTION_DEFINITIONS.get(action.getKey()), List.of(new Diagnosis.Resource(Diagnosis.Resource.Type.ILM_POLICY, (Collection)affectedPolicies), new Diagnosis.Resource(Diagnosis.Resource.Type.INDEX, (Collection)affectedIndices)));
        }).toList();
    }

    private static HealthIndicatorDetails createDetails(boolean verbose, IndexLifecycleMetadata metadata, OperationMode mode, List<IndexMetadata> stagnatingIndices) {
        if (!verbose) {
            return HealthIndicatorDetails.EMPTY;
        }
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("ilm_status", mode);
        details.put("policies", metadata.getPolicies().size());
        details.put("stagnating_indices", stagnatingIndices.size());
        Map<String, Long> stagnatingIndicesPerAction = stagnatingIndices.stream().collect(Collectors.groupingBy(md -> md.getLifecycleExecutionState().action(), Collectors.counting()));
        if (!stagnatingIndicesPerAction.isEmpty()) {
            RULES_BY_ACTION_CONFIG.forEach((action, value) -> stagnatingIndicesPerAction.putIfAbsent((String)action, 0L));
            details.put("stagnating_indices_per_action", stagnatingIndicesPerAction);
        }
        return new SimpleHealthIndicatorDetails(details);
    }

    static boolean isStagnated(Collection<RuleConfig> rules, Long now, IndexMetadata indexMetadata) {
        return rules.stream().anyMatch(r -> r.test(now, indexMetadata));
    }

    private static ProjectMetadata getDefaultILMProject(ClusterState state) {
        return state.metadata().getProject(ProjectId.DEFAULT);
    }

    static class StagnatingIndicesFinder {
        private final ClusterService clusterService;
        private final LongSupplier nowSupplier;
        private final Collection<RuleCreator> rulesCreators;
        private volatile Collection<RuleConfig> rules;

        StagnatingIndicesFinder(ClusterService clusterService, Collection<RuleCreator> rulesCreators, LongSupplier nowSupplier) {
            this.clusterService = clusterService;
            this.rulesCreators = rulesCreators;
            this.nowSupplier = nowSupplier;
            ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
            clusterSettings.addSettingsUpdateConsumer(this::recreateRules, List.of(MAX_TIME_ON_ACTION_SETTING, MAX_TIME_ON_STEP_SETTING, MAX_RETRIES_PER_STEP_SETTING));
            this.recreateRules(clusterService.getSettings());
        }

        public List<IndexMetadata> find() {
            ProjectMetadata project = IlmHealthIndicatorService.getDefaultILMProject(this.clusterService.state());
            long now = this.nowSupplier.getAsLong();
            return project.indices().values().stream().filter(arg_0 -> ((ProjectMetadata)project).isIndexManagedByILM(arg_0)).filter(md -> IlmHealthIndicatorService.isStagnated(this.rules, now, md)).toList();
        }

        void recreateRules(Settings settings) {
            TimeValue maxTimeOnAction = (TimeValue)MAX_TIME_ON_ACTION_SETTING.get(settings);
            TimeValue maxTimeOnStep = (TimeValue)MAX_TIME_ON_STEP_SETTING.get(settings);
            Long maxRetriesPerStep = (Long)MAX_RETRIES_PER_STEP_SETTING.get(settings);
            this.rules = this.rulesCreators.stream().map(rc -> rc.create(maxTimeOnAction, maxTimeOnStep, maxRetriesPerStep)).toList();
        }

        Collection<RuleConfig> rules() {
            return this.rules;
        }

        ClusterService clusterService() {
            return this.clusterService;
        }
    }

    @FunctionalInterface
    public static interface RuleConfig {
        public boolean test(Long var1, IndexMetadata var2);

        public static TimeValue getElapsedTime(Long now, Long currentTime) {
            return currentTime == null ? TimeValue.ZERO : TimeValue.timeValueMillis((long)(now - currentTime));
        }

        default public RuleConfig and(RuleConfig other) {
            return (now, indexMetadata) -> this.test(now, indexMetadata) && other.test(now, indexMetadata);
        }

        default public RuleConfig or(RuleConfig other) {
            return (now, indexMetadata) -> this.test(now, indexMetadata) || other.test(now, indexMetadata);
        }

        public static class Builder {
            private String action;
            private TimeValue maxTimeOn = null;

            static Builder actionRule(String action) {
                Builder builder = new Builder();
                builder.action = action;
                return builder;
            }

            Builder maxTimeOnAction(TimeValue maxTimeOn) {
                this.maxTimeOn = maxTimeOn;
                return this;
            }

            RuleConfig stepRules(StepRule ... stepRules) {
                assert (stepRules.length > 0);
                if (stepRules.length == 1) {
                    return new ActionRule(this.action, this.maxTimeOn).and(stepRules[0]);
                }
                RuleConfig stepRule = stepRules[0];
                for (int i = 1; i < stepRules.length; ++i) {
                    stepRule = stepRule.or(stepRules[i]);
                }
                return new ActionRule(this.action, this.maxTimeOn).and(stepRule);
            }

            RuleConfig noStepRules() {
                return new ActionRule(this.action, this.maxTimeOn);
            }
        }
    }

    public record StepRule(String step, TimeValue maxTimeOn, Long maxRetries) implements RuleConfig
    {
        public StepRule {
            if (maxTimeOn == null && maxRetries == null) {
                throw new IllegalArgumentException("At least one of [maxTimeOne or maxRetries] must be defined.");
            }
        }

        static StepRule stepRuleFullChecks(String name, TimeValue maxTimeOn, long maxRetries) {
            return new StepRule(name, maxTimeOn, maxRetries);
        }

        static StepRule stepRuleOnlyCheckPassedTime(String name, TimeValue maxTimeOn) {
            return new StepRule(name, maxTimeOn, null);
        }

        static StepRule stepRuleOnlyCheckRetries(String name, long maxRetries) {
            return new StepRule(name, null, maxRetries);
        }

        @Override
        public boolean test(Long now, IndexMetadata indexMetadata) {
            Integer failedStepRetryCount = indexMetadata.getLifecycleExecutionState().failedStepRetryCount();
            return this.step.equals(indexMetadata.getLifecycleExecutionState().step()) && (this.maxTimeOn != null && this.maxTimeOn.compareTo(RuleConfig.getElapsedTime(now, indexMetadata.getLifecycleExecutionState().stepTime())) < 0 || this.maxRetries != null && failedStepRetryCount != null && (long)failedStepRetryCount.intValue() > this.maxRetries);
        }
    }

    @FunctionalInterface
    static interface RuleCreator {
        public RuleConfig create(TimeValue var1, TimeValue var2, Long var3);
    }

    record ActionRule(String action, TimeValue maxTimeOn) implements RuleConfig
    {
        @Override
        public boolean test(Long now, IndexMetadata indexMetadata) {
            String currentAction = indexMetadata.getLifecycleExecutionState().action();
            if (this.maxTimeOn == null) {
                return this.action.equals(currentAction);
            }
            return this.action.equals(currentAction) && this.maxTimeOn.compareTo(RuleConfig.getElapsedTime(now, indexMetadata.getLifecycleExecutionState().actionTime())) < 0;
        }
    }
}

