/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.lib;

import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.nativeaccess.jdk.JdkNativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.NativeLibrary;

public abstract class NativeLibraryProvider {
    private final String name;
    private final Map<Class<? extends NativeLibrary>, Supplier<NativeLibrary>> libraries;

    protected NativeLibraryProvider(String name, Map<Class<? extends NativeLibrary>, Supplier<NativeLibrary>> libraries) {
        this.name = name;
        this.libraries = libraries;
        for (Class<?> libClass : NativeLibrary.class.getPermittedSubclasses()) {
            if (libraries.containsKey(libClass)) continue;
            throw new IllegalStateException(this.getClass().getSimpleName() + " missing implementation for " + libClass.getSimpleName());
        }
    }

    public static NativeLibraryProvider instance() {
        return Holder.INSTANCE;
    }

    public String getName() {
        return this.name;
    }

    public <T extends NativeLibrary> T getLibrary(Class<T> cls) {
        Supplier<NativeLibrary> libraryCtor = this.libraries.get(cls);
        NativeLibrary library = libraryCtor.get();
        assert (library != null);
        assert (cls.isAssignableFrom(library.getClass()));
        return (T)((NativeLibrary)cls.cast(library));
    }

    private static final class Holder {
        static final NativeLibraryProvider INSTANCE = new JdkNativeLibraryProvider();

        private Holder() {
        }
    }
}

