/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;

public enum TDigestExecutionHint implements Writeable
{
    DEFAULT(0),
    HIGH_ACCURACY(1);

    public static final Setting<String> SETTING;
    private final int id;

    private TDigestExecutionHint(int id) {
        this.id = id;
    }

    public static TDigestExecutionHint parse(String value) {
        try {
            return switch (value) {
                case "high_accuracy" -> HIGH_ACCURACY;
                case "default", "" -> DEFAULT;
                default -> TDigestExecutionHint.valueOf(value);
            };
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid execution_hint [" + value + "], valid values are [default, high_accuracy]");
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
    }

    public static TDigestExecutionHint readFrom(StreamInput in) throws IOException {
        int value = in.readVInt();
        if (value == TDigestExecutionHint.DEFAULT.id) {
            return DEFAULT;
        }
        if (value == TDigestExecutionHint.HIGH_ACCURACY.id) {
            return HIGH_ACCURACY;
        }
        throw new IllegalStateException("Received unknown TDigestExecutionHint id: " + value);
    }

    static {
        SETTING = Setting.simpleString("search.aggs.tdigest_execution_hint", DEFAULT.toString(), TDigestExecutionHint::parse, Setting.Property.NodeScope, Setting.Property.Dynamic);
    }
}

