/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequestBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;

public class DeleteByQueryRequestBuilder
extends AbstractBulkByScrollRequestBuilder<DeleteByQueryRequest, DeleteByQueryRequestBuilder> {
    private Boolean abortOnVersionConflict;

    public DeleteByQueryRequestBuilder(ElasticsearchClient client) {
        this(client, new SearchRequestBuilder(client));
    }

    private DeleteByQueryRequestBuilder(ElasticsearchClient client, SearchRequestBuilder search) {
        super(client, DeleteByQueryAction.INSTANCE, search);
        this.source().setFetchSource(false);
    }

    @Override
    protected DeleteByQueryRequestBuilder self() {
        return this;
    }

    @Override
    public DeleteByQueryRequestBuilder abortOnVersionConflict(boolean abortOnVersionConflict) {
        this.abortOnVersionConflict = abortOnVersionConflict;
        return this;
    }

    @Override
    public DeleteByQueryRequest request() {
        SearchRequest search = (SearchRequest)this.source().request();
        try {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(search, false);
            try {
                this.apply(deleteByQueryRequest);
                return deleteByQueryRequest;
            }
            catch (Exception e) {
                deleteByQueryRequest.decRef();
                throw e;
            }
        }
        catch (Exception e) {
            search.decRef();
            throw e;
        }
    }

    @Override
    public void apply(DeleteByQueryRequest request) {
        super.apply(request);
        if (this.abortOnVersionConflict != null) {
            request.setAbortOnVersionConflict(this.abortOnVersionConflict);
        }
    }
}

