/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TimeBasedUUIDGenerator;
import org.elasticsearch.common.util.ByteUtils;

public class TimeBasedKOrderedUUIDGenerator
extends TimeBasedUUIDGenerator {
    static final int SIZE_IN_BYTES = 15;

    public TimeBasedKOrderedUUIDGenerator(Supplier<Long> timestampSupplier, Supplier<Integer> sequenceIdSupplier, Supplier<byte[]> macAddressSupplier) {
        super(timestampSupplier, sequenceIdSupplier, macAddressSupplier);
    }

    @Override
    public String getBase64UUID() {
        return this.getBase64UUID(OptionalInt.empty());
    }

    public String getBase64UUID(OptionalInt hash) {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = this.lastTimestamp.accumulateAndGet((Long)this.timestampSupplier.get(), sequenceId == 0 ? (lastTimestamp, currentTimeMillis) -> Math.max(lastTimestamp, currentTimeMillis) + 1L : Math::max);
        byte[] uuidBytes = new byte[15 + (hash.isPresent() ? 4 : 0)];
        ByteBuffer buffer = ByteBuffer.wrap(uuidBytes);
        buffer.put((byte)(timestamp >>> 40));
        buffer.put((byte)(timestamp >>> 32));
        buffer.put((byte)(timestamp >>> 24));
        buffer.put((byte)(timestamp >>> 16));
        byte[] macAddress = this.macAddress();
        assert (macAddress.length == 6);
        buffer.put(macAddress, 0, macAddress.length);
        if (hash.isPresent()) {
            byte[] hashBytes = new byte[4];
            ByteUtils.writeIntLE(hash.getAsInt(), hashBytes, 0);
            buffer.put(hashBytes, 0, hashBytes.length);
        }
        buffer.put((byte)(sequenceId >>> 16));
        buffer.put((byte)(timestamp >>> 8));
        buffer.put((byte)(sequenceId >>> 8));
        buffer.put((byte)timestamp);
        buffer.put((byte)sequenceId);
        assert (buffer.position() == uuidBytes.length);
        return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(uuidBytes);
    }
}

