/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Insist
extends UnaryPlan
implements SurrogateLogicalPlan,
Streaming {
    private final List<? extends Attribute> insistedAttributes;
    @Nullable
    private List<Attribute> lazyOutput = null;

    public Insist(Source source, LogicalPlan child, List<? extends Attribute> insistedAttributes) {
        super(source, child);
        this.insistedAttributes = insistedAttributes;
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(this.insistedAttributes, this.child().output());
        }
        return this.lazyOutput;
    }

    public List<? extends Attribute> insistedAttributes() {
        return this.insistedAttributes;
    }

    @Override
    public Insist replaceChild(LogicalPlan newChild) {
        return new Insist(this.source(), newChild, this.insistedAttributes);
    }

    @Override
    public boolean expressionsResolved() {
        return this.insistedAttributes().stream().allMatch(a -> a.resolved() || a instanceof UnsupportedAttribute);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, (source, insistedAttributes1, child) -> new Insist(source, (LogicalPlan)((Object)child), (List<? extends Attribute>)insistedAttributes1), this.insistedAttributes, (Object)((Object)this.child()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("doesn't escape the coordinator node");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the coordinator node");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Objects.hashCode(this.insistedAttributes));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(((Insist)obj).insistedAttributes, this.insistedAttributes);
    }

    @Override
    public LogicalPlan surrogate() {
        return new Project(this.source(), this.child(), this.output());
    }

    public Insist withAttributes(List<Attribute> attributes) {
        return new Insist(this.source(), this.child(), attributes);
    }
}

