/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.LicenseAware;
import org.elasticsearch.xpack.esql.SupportsObservabilityTier;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ml.MachineLearning;

@SupportsObservabilityTier(tier=SupportsObservabilityTier.ObservabilityTier.COMPLETE)
public class ChangePoint
extends UnaryPlan
implements SurrogateLogicalPlan,
PostAnalysisVerificationAware,
LicenseAware,
ExecutesOn.Coordinator {
    private final Attribute value;
    private final Attribute key;
    private final Attribute targetType;
    private final Attribute targetPvalue;
    private List<Attribute> output;

    public ChangePoint(Source source, LogicalPlan child, Attribute value, Attribute key, Attribute targetType, Attribute targetPvalue) {
        super(source, child);
        this.value = value;
        this.key = key;
        this.targetType = targetType;
        this.targetPvalue = targetPvalue;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    protected NodeInfo<ChangePoint> info() {
        return NodeInfo.create((Node)this, ChangePoint::new, (Object)((Object)this.child()), (Object)this.value, (Object)this.key, (Object)this.targetType, (Object)this.targetPvalue);
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new ChangePoint(this.source(), newChild, this.value, this.key, this.targetType, this.targetPvalue);
    }

    @Override
    public List<Attribute> output() {
        if (this.output == null) {
            this.output = NamedExpressions.mergeOutputAttributes(List.of(this.targetType, this.targetPvalue), this.child().output());
        }
        return this.output;
    }

    public Attribute value() {
        return this.value;
    }

    public Attribute key() {
        return this.key;
    }

    public Attribute targetType() {
        return this.targetType;
    }

    public Attribute targetPvalue() {
        return this.targetPvalue;
    }

    @Override
    protected AttributeSet computeReferences() {
        return Expressions.references(List.of(this.key, this.value));
    }

    @Override
    public boolean expressionsResolved() {
        return this.value.resolved() && this.key.resolved();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.key, this.targetType, this.targetPvalue);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals(this.value, ((ChangePoint)other).value) && Objects.equals(this.key, ((ChangePoint)other).key) && Objects.equals(this.targetType, ((ChangePoint)other).targetType) && Objects.equals(this.targetPvalue, ((ChangePoint)other).targetPvalue);
    }

    private Order order() {
        return new Order(this.source(), (Expression)this.key, Order.OrderDirection.ASC, Order.NullsPosition.ANY);
    }

    @Override
    public LogicalPlan surrogate() {
        OrderBy orderBy = new OrderBy(this.source(), this.child(), List.of(this.order()));
        Limit limit = new Limit(this.source(), (Expression)new Literal(Source.EMPTY, (Object)1001, DataType.INTEGER), orderBy);
        ChangePoint changePoint = new ChangePoint(this.source(), limit, this.value, this.key, this.targetType, this.targetPvalue);
        return new Limit(this.source(), (Expression)new Literal(Source.EMPTY, (Object)1000, DataType.INTEGER), changePoint);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        Order order = this.order();
        if (!DataType.isSortable((DataType)order.dataType())) {
            failures.add(Failure.fail(this, "change point key [" + this.key.name() + "] must be sortable", new Object[0]));
        }
        if (!this.value.dataType().isNumeric()) {
            failures.add(Failure.fail(this, "change point value [" + this.value.name() + "] must be numeric", new Object[0]));
        }
    }

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return MachineLearning.CHANGE_POINT_AGG_FEATURE.check(state);
    }
}

