/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVector;

public final class ToDenseVectorFromIntEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToDenseVectorFromIntEvaluator.class);
    private final EvalOperator.ExpressionEvaluator i;

    public ToDenseVectorFromIntEvaluator(Source source, EvalOperator.ExpressionEvaluator i, DriverContext driverContext) {
        super(driverContext, source);
        this.i = i;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.i;
    }

    @Override
    public Block evalVector(Vector v) {
        IntVector vector = (IntVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantFloatBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (FloatBlock.Builder builder = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendFloat(this.evalValue(vector, p));
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private float evalValue(IntVector container, int index) {
        int value = container.getInt(index);
        return ToDenseVector.fromInt(value);
    }

    @Override
    public Block evalBlock(Block b) {
        IntBlock block = (IntBlock)b;
        int positionCount = block.getPositionCount();
        try (FloatBlock.Builder builder = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    float value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendFloat(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private float evalValue(IntBlock container, int index) {
        int value = container.getInt(index);
        return ToDenseVector.fromInt(value);
    }

    public String toString() {
        return "ToDenseVectorFromIntEvaluator[i=" + String.valueOf(this.i) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.i);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.i.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory i;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory i) {
            this.source = source;
            this.i = i;
        }

        public ToDenseVectorFromIntEvaluator get(DriverContext context) {
            return new ToDenseVectorFromIntEvaluator(this.source, this.i.get(context), context);
        }

        public String toString() {
            return "ToDenseVectorFromIntEvaluator[i=" + String.valueOf(this.i) + "]";
        }
    }
}

