/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.datapoint;

import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.HistogramConverter;
import org.elasticsearch.xpack.oteldata.otlp.docbuilder.MappingHints;

public interface DataPoint {
    public long getTimestampUnixNano();

    public long getStartTimestampUnixNano();

    public List<KeyValue> getAttributes();

    public String getUnit();

    public String getMetricName();

    public void buildMetricValue(MappingHints var1, XContentBuilder var2) throws IOException;

    public String getDynamicTemplate(MappingHints var1);

    public boolean isValid(Set<String> var1);

    public long getDocCount();

    private static void buildAggregateMetricDouble(XContentBuilder builder, double sum, long valueCount) throws IOException {
        builder.startObject();
        builder.field("sum", sum);
        builder.field("value_count", valueCount);
        builder.endObject();
    }

    public record Summary(SummaryDataPoint dataPoint, Metric metric) implements DataPoint
    {
        @Override
        public long getTimestampUnixNano() {
            return this.dataPoint.getTimeUnixNano();
        }

        @Override
        public List<KeyValue> getAttributes() {
            return this.dataPoint.getAttributesList();
        }

        @Override
        public long getStartTimestampUnixNano() {
            return this.dataPoint.getStartTimeUnixNano();
        }

        @Override
        public String getUnit() {
            return this.metric.getUnit();
        }

        @Override
        public String getMetricName() {
            return this.metric.getName();
        }

        @Override
        public void buildMetricValue(MappingHints mappingHints, XContentBuilder builder) throws IOException {
            DataPoint.buildAggregateMetricDouble(builder, this.dataPoint.getSum(), this.dataPoint.getCount());
        }

        @Override
        public long getDocCount() {
            return this.dataPoint.getCount();
        }

        @Override
        public String getDynamicTemplate(MappingHints mappingHints) {
            return "summary";
        }

        @Override
        public boolean isValid(Set<String> errors) {
            return true;
        }
    }

    public record Histogram(HistogramDataPoint dataPoint, Metric metric) implements DataPoint
    {
        @Override
        public long getTimestampUnixNano() {
            return this.dataPoint.getTimeUnixNano();
        }

        @Override
        public List<KeyValue> getAttributes() {
            return this.dataPoint.getAttributesList();
        }

        @Override
        public long getStartTimestampUnixNano() {
            return this.dataPoint.getStartTimeUnixNano();
        }

        @Override
        public String getUnit() {
            return this.metric.getUnit();
        }

        @Override
        public String getMetricName() {
            return this.metric.getName();
        }

        @Override
        public void buildMetricValue(MappingHints mappingHints, XContentBuilder builder) throws IOException {
            if (mappingHints.aggregateMetricDouble()) {
                DataPoint.buildAggregateMetricDouble(builder, this.dataPoint.getSum(), this.dataPoint.getCount());
            } else {
                builder.startObject();
                builder.startArray("counts");
                HistogramConverter.counts(this.dataPoint, arg_0 -> ((XContentBuilder)builder).value(arg_0));
                builder.endArray();
                builder.startArray("values");
                HistogramConverter.centroidValues(this.dataPoint, arg_0 -> ((XContentBuilder)builder).value(arg_0));
                builder.endArray();
                builder.endObject();
            }
        }

        @Override
        public long getDocCount() {
            return this.dataPoint.getCount();
        }

        @Override
        public String getDynamicTemplate(MappingHints mappingHints) {
            if (mappingHints.aggregateMetricDouble()) {
                return "summary";
            }
            return "histogram";
        }

        @Override
        public boolean isValid(Set<String> errors) {
            if (this.metric.getHistogram().getAggregationTemporality() != AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA) {
                errors.add("cumulative histogram metrics are not supported, ignoring " + this.metric.getName());
                return false;
            }
            if (this.dataPoint.getBucketCountsCount() == 1 && this.dataPoint.getExplicitBoundsCount() == 0) {
                errors.add("histogram with a single bucket and no explicit bounds is not supported, ignoring " + this.metric.getName());
                return false;
            }
            return true;
        }
    }

    public record ExponentialHistogram(ExponentialHistogramDataPoint dataPoint, Metric metric) implements DataPoint
    {
        @Override
        public long getTimestampUnixNano() {
            return this.dataPoint.getTimeUnixNano();
        }

        @Override
        public List<KeyValue> getAttributes() {
            return this.dataPoint.getAttributesList();
        }

        @Override
        public long getStartTimestampUnixNano() {
            return this.dataPoint.getStartTimeUnixNano();
        }

        @Override
        public String getUnit() {
            return this.metric.getUnit();
        }

        @Override
        public String getMetricName() {
            return this.metric.getName();
        }

        @Override
        public void buildMetricValue(MappingHints mappingHints, XContentBuilder builder) throws IOException {
            if (mappingHints.aggregateMetricDouble()) {
                DataPoint.buildAggregateMetricDouble(builder, this.dataPoint.getSum(), this.dataPoint.getCount());
            } else {
                builder.startObject();
                builder.startArray("counts");
                HistogramConverter.counts(this.dataPoint, arg_0 -> ((XContentBuilder)builder).value(arg_0));
                builder.endArray();
                builder.startArray("values");
                HistogramConverter.centroidValues(this.dataPoint, arg_0 -> ((XContentBuilder)builder).value(arg_0));
                builder.endArray();
                builder.endObject();
            }
        }

        @Override
        public long getDocCount() {
            return this.dataPoint.getCount();
        }

        @Override
        public String getDynamicTemplate(MappingHints mappingHints) {
            if (mappingHints.aggregateMetricDouble()) {
                return "summary";
            }
            return "histogram";
        }

        @Override
        public boolean isValid(Set<String> errors) {
            if (this.metric.getExponentialHistogram().getAggregationTemporality() != AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA) {
                errors.add("cumulative exponential histogram metrics are not supported, ignoring " + this.metric.getName());
                return false;
            }
            return true;
        }
    }

    public record Number(NumberDataPoint dataPoint, Metric metric) implements DataPoint
    {
        @Override
        public long getTimestampUnixNano() {
            return this.dataPoint.getTimeUnixNano();
        }

        @Override
        public List<KeyValue> getAttributes() {
            return this.dataPoint.getAttributesList();
        }

        @Override
        public long getStartTimestampUnixNano() {
            return this.dataPoint.getStartTimeUnixNano();
        }

        @Override
        public String getUnit() {
            return this.metric.getUnit();
        }

        @Override
        public String getMetricName() {
            return this.metric.getName();
        }

        @Override
        public void buildMetricValue(MappingHints mappingHints, XContentBuilder builder) throws IOException {
            switch (this.dataPoint.getValueCase()) {
                case AS_DOUBLE: {
                    builder.value(this.dataPoint.getAsDouble());
                    break;
                }
                case AS_INT: {
                    builder.value(this.dataPoint.getAsInt());
                }
            }
        }

        @Override
        public long getDocCount() {
            return 1L;
        }

        @Override
        public String getDynamicTemplate(MappingHints mappingHints) {
            String type = this.metric.hasSum() && this.metric.getSum().getAggregationTemporality() == AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE && this.metric.getSum().getIsMonotonic() ? "counter_" : "gauge_";
            if (this.dataPoint.getValueCase() == NumberDataPoint.ValueCase.AS_INT) {
                return type + "long";
            }
            if (this.dataPoint.getValueCase() == NumberDataPoint.ValueCase.AS_DOUBLE) {
                return type + "double";
            }
            return null;
        }

        @Override
        public boolean isValid(Set<String> errors) {
            return true;
        }
    }
}

