/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.LongSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryIntegrityVerifier;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityParams;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponse;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseChunk;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityTask;
import org.elasticsearch.repositories.blobstore.testkit.integrity.TransportRepositoryVerifyIntegrityCoordinationAction;
import org.elasticsearch.repositories.blobstore.testkit.integrity.TransportRepositoryVerifyIntegrityResponseChunkAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

class TransportRepositoryVerifyIntegrityAction
extends HandledTransportAction<Request, RepositoryVerifyIntegrityResponse> {
    static final String ACTION_NAME = TransportRepositoryVerifyIntegrityCoordinationAction.INSTANCE.name() + "[m]";
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final Executor executor;

    TransportRepositoryVerifyIntegrityAction(TransportService transportService, RepositoriesService repositoriesService, ActionFilters actionFilters, Executor executor) {
        super(ACTION_NAME, transportService, actionFilters, Request::new, executor);
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.executor = executor;
    }

    protected void doExecute(final Task rawTask, final Request request, ActionListener<RepositoryVerifyIntegrityResponse> listener) {
        RepositoryVerifyIntegrityResponseChunk.Writer responseWriter = new RepositoryVerifyIntegrityResponseChunk.Writer(){
            final Transport.Connection responseConnection;
            {
                this.responseConnection = TransportRepositoryVerifyIntegrityAction.this.transportService.getConnection(request.coordinatingNode);
            }

            @Override
            public void writeResponseChunk(RepositoryVerifyIntegrityResponseChunk responseChunk, ActionListener<Void> listener) {
                TransportRepositoryVerifyIntegrityAction.this.transportService.sendChildRequest(this.responseConnection, TransportRepositoryVerifyIntegrityResponseChunkAction.ACTION_NAME, (TransportRequest)new TransportRepositoryVerifyIntegrityResponseChunkAction.Request(request.coordinatingTaskId, responseChunk), rawTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener.map(ignored -> null), in -> ActionResponse.Empty.INSTANCE, TransportRepositoryVerifyIntegrityAction.this.executor));
            }
        };
        LongSupplier currentTimeMillisSupplier = () -> ((ThreadPool)this.transportService.getThreadPool()).absoluteTimeInMillis();
        BlobStoreRepository repository = (BlobStoreRepository)this.repositoriesService.repository(request.requestParams.repository());
        RepositoryVerifyIntegrityTask task = (RepositoryVerifyIntegrityTask)rawTask;
        SubscribableListener.newForked(l -> repository.getRepositoryData(this.executor, l)).andThenApply(arg_0 -> TransportRepositoryVerifyIntegrityAction.lambda$doExecute$2(task, currentTimeMillisSupplier, repository, responseWriter, request, arg_0)).andThen((arg_0, arg_1) -> TransportRepositoryVerifyIntegrityAction.lambda$doExecute$4(responseWriter, currentTimeMillisSupplier, arg_0, arg_1)).andThen((l, repositoryIntegrityVerifier) -> repositoryIntegrityVerifier.start((ActionListener<RepositoryVerifyIntegrityResponse>)l)).addListener(listener);
    }

    static void ensureValidGenId(long repositoryGenId) {
        if (repositoryGenId == -1L) {
            throw new IllegalArgumentException("repository is empty, cannot verify its integrity");
        }
        if (repositoryGenId < 0L) {
            IllegalStateException exception = new IllegalStateException("repository is in an unexpected state [" + repositoryGenId + "], cannot verify its integrity");
            assert (false) : exception;
            throw exception;
        }
    }

    private static /* synthetic */ void lambda$doExecute$4(1 responseWriter, LongSupplier currentTimeMillisSupplier, ActionListener l, RepositoryIntegrityVerifier repositoryIntegrityVerifier) throws Exception {
        new RepositoryVerifyIntegrityResponseChunk.Builder(responseWriter, RepositoryVerifyIntegrityResponseChunk.Type.START_RESPONSE, currentTimeMillisSupplier.getAsLong()).write((ActionListener<Void>)l.map(ignored -> repositoryIntegrityVerifier));
    }

    private static /* synthetic */ RepositoryIntegrityVerifier lambda$doExecute$2(RepositoryVerifyIntegrityTask task, LongSupplier currentTimeMillisSupplier, BlobStoreRepository repository, 1 responseWriter, Request request, RepositoryData repositoryData) throws Exception {
        TransportRepositoryVerifyIntegrityAction.ensureValidGenId(repositoryData.getGenId());
        CancellableThreads cancellableThreads = new CancellableThreads();
        task.addListener(() -> cancellableThreads.cancel("task cancelled"));
        RepositoryIntegrityVerifier verifier = new RepositoryIntegrityVerifier(currentTimeMillisSupplier, repository, responseWriter, request.requestParams.withResolvedDefaults(repository.threadPool().info("snapshot_meta")), repositoryData, cancellableThreads);
        task.setStatusSupplier(verifier::getStatus);
        return verifier;
    }

    static class Request
    extends LegacyActionRequest {
        private final DiscoveryNode coordinatingNode;
        private final long coordinatingTaskId;
        private final RepositoryVerifyIntegrityParams requestParams;

        Request(DiscoveryNode coordinatingNode, long coordinatingTaskId, RepositoryVerifyIntegrityParams requestParams) {
            this.coordinatingNode = coordinatingNode;
            this.coordinatingTaskId = coordinatingTaskId;
            this.requestParams = Objects.requireNonNull(requestParams);
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.coordinatingNode = new DiscoveryNode(in);
            this.coordinatingTaskId = in.readVLong();
            this.requestParams = new RepositoryVerifyIntegrityParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.coordinatingNode.writeTo(out);
            out.writeVLong(this.coordinatingTaskId);
            this.requestParams.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new RepositoryVerifyIntegrityTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }
    }
}

