/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Unresolvable;
import org.elasticsearch.xpack.ql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class UnresolvedAttribute
extends Attribute
implements Unresolvable {
    private final String unresolvedMsg;
    private final boolean customMessage;
    private final Object resolutionMetadata;

    public UnresolvedAttribute(Source source, String name) {
        this(source, name, null);
    }

    public UnresolvedAttribute(Source source, String name, String qualifier) {
        this(source, name, qualifier, (String)null);
    }

    public UnresolvedAttribute(Source source, String name, String qualifier, String unresolvedMessage) {
        this(source, name, qualifier, null, unresolvedMessage, null);
    }

    public UnresolvedAttribute(Source source, String name, String qualifier, NameId id, String unresolvedMessage, Object resolutionMetadata) {
        super(source, name, qualifier, id);
        this.customMessage = unresolvedMessage != null;
        this.unresolvedMsg = unresolvedMessage == null ? UnresolvedAttribute.errorMessage(this.qualifiedName(), null) : unresolvedMessage;
        this.resolutionMetadata = resolutionMetadata;
    }

    @Override
    protected NodeInfo<UnresolvedAttribute> info() {
        return NodeInfo.create(this, UnresolvedAttribute::new, this.name(), this.qualifier(), this.id(), this.unresolvedMsg, this.resolutionMetadata);
    }

    public Object resolutionMetadata() {
        return this.resolutionMetadata;
    }

    public boolean customMessage() {
        return this.customMessage;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    protected Attribute clone(Source source, String name, DataType dataType, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        return this;
    }

    public UnresolvedAttribute withUnresolvedMessage(String unresolvedMessage) {
        return new UnresolvedAttribute(this.source(), this.name(), this.qualifier(), this.id(), unresolvedMessage, this.resolutionMetadata());
    }

    @Override
    public DataType dataType() {
        throw new UnresolvedException("dataType", (Object)this);
    }

    @Override
    public String toString() {
        return "?" + this.qualifiedName();
    }

    @Override
    protected String label() {
        return "?";
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    @Override
    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    public static String errorMessage(String name, List<String> potentialMatches) {
        String msg = "Unknown column [" + name + "]";
        if (!CollectionUtils.isEmpty(potentialMatches)) {
            msg = msg + ", did you mean " + (potentialMatches.size() == 1 ? "[" + potentialMatches.get(0) + "]" : "any of " + potentialMatches.toString()) + "?";
        }
        return msg;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolutionMetadata, this.unresolvedMsg);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            UnresolvedAttribute ua = (UnresolvedAttribute)obj;
            return Objects.equals(this.resolutionMetadata, ua.resolutionMetadata) && Objects.equals(this.unresolvedMsg, ua.unresolvedMsg);
        }
        return false;
    }
}

