/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.integer.ModelStrategy;
import org.ojalgo.optimisation.integer.NodeSolver;
import org.ojalgo.type.ObjectPool;
import org.ojalgo.type.context.NumberContext;

public final class NodeKey
implements Comparable<NodeKey> {
    public static final Comparator<NodeKey> EARLIEST_SEQUENCE = Comparator.comparingLong(nk -> nk.sequence).reversed();
    public static final Comparator<NodeKey> LARGEST_DISPLACEMENT = Comparator.comparingDouble(nk -> nk.displacement);
    public static final Comparator<NodeKey> LATEST_SEQUENCE = Comparator.comparingLong(nk -> nk.sequence);
    public static final Comparator<NodeKey> MAX_OBJECTIVE = Comparator.comparingDouble(nk -> nk.objective);
    public static final Comparator<NodeKey> MIN_OBJECTIVE = Comparator.comparingDouble(nk -> nk.objective).reversed();
    public static final Comparator<NodeKey> SMALLEST_DISPLACEMENT = Comparator.comparingDouble(nk -> nk.displacement).reversed();
    private static final NumberContext FEASIBILITY = NumberContext.of(8, 6);
    private static final AtomicLong SEQUENCE_GENERATOR = new AtomicLong();
    public final double displacement;
    public final int index;
    public final double objective;
    public final long parent;
    public final long sequence;
    private final IntArrayPool myIntArrayPool;
    private final int[] myLowerBounds;
    private final boolean mySignChanged;
    private final int[] myUpperBounds;

    private NodeKey(int[] lowerBounds, int[] upperBounds, long parentSequenceNumber, int integerIndexBranchedOn, double branchVariableDisplacement, double parentObjectiveFunctionValue, boolean signChanged, IntArrayPool pool) {
        this.sequence = SEQUENCE_GENERATOR.incrementAndGet();
        this.myLowerBounds = lowerBounds;
        this.myUpperBounds = upperBounds;
        this.parent = parentSequenceNumber;
        this.index = integerIndexBranchedOn;
        this.displacement = branchVariableDisplacement;
        this.objective = parentObjectiveFunctionValue;
        this.mySignChanged = signChanged;
        this.myIntArrayPool = pool;
    }

    NodeKey(ExpressionsBasedModel integerModel) {
        this.sequence = 0L;
        List<Variable> integerVariables = integerModel.getIntegerVariables();
        int nbIntegerVariables = integerVariables.size();
        this.myIntArrayPool = new IntArrayPool(nbIntegerVariables);
        this.myLowerBounds = (int[])this.myIntArrayPool.borrow();
        this.myUpperBounds = (int[])this.myIntArrayPool.borrow();
        for (int i = 0; i < nbIntegerVariables; ++i) {
            Variable variable = integerVariables.get(i);
            BigDecimal lowerLimit = variable.getLowerLimit();
            this.myLowerBounds[i] = lowerLimit != null ? lowerLimit.intValue() : Integer.MIN_VALUE;
            BigDecimal upperLimit = variable.getUpperLimit();
            this.myUpperBounds[i] = upperLimit != null ? upperLimit.intValue() : Integer.MAX_VALUE;
        }
        this.parent = this.sequence;
        this.index = -1;
        this.displacement = Double.NaN;
        this.objective = Double.NaN;
        this.mySignChanged = false;
    }

    @Override
    public int compareTo(NodeKey ref) {
        return Long.compare(this.sequence, ref.sequence);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeKey)) {
            return false;
        }
        NodeKey other = (NodeKey)obj;
        return this.sequence == other.sequence;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.sequence);
        retVal.append(' ');
        retVal.append('(');
        retVal.append(this.parent);
        retVal.append(')');
        retVal.append(' ');
        retVal.append(this.index);
        retVal.append('=');
        retVal.append(this.displacement);
        retVal.append(' ');
        retVal.append(this.objective);
        retVal.append(' ');
        retVal.append('[');
        if (this.myLowerBounds.length > 0) {
            this.append(retVal, 0);
        }
        for (int i = 1; i < this.myLowerBounds.length; ++i) {
            retVal.append(',');
            retVal.append(' ');
            this.append(retVal, i);
        }
        return retVal.append(']').toString();
    }

    private void append(StringBuilder builder, int idx) {
        builder.append(idx);
        builder.append('=');
        builder.append(this.myLowerBounds[idx]);
        builder.append('<');
        builder.append(this.myUpperBounds[idx]);
    }

    private double feasible(int idx, double value, boolean validate) {
        double feasibilityAdjusted = Math.min(Math.max((double)this.myLowerBounds[idx], value), (double)this.myUpperBounds[idx]);
        if (validate && FEASIBILITY.isDifferent(feasibilityAdjusted, value)) {
            BasicLogger.error("Obviously infeasible value {}: {} <= {} <= {} @ {}", idx, this.myLowerBounds[idx], value, this.myUpperBounds[idx], this);
        }
        return feasibilityAdjusted;
    }

    long calculateTreeSize() {
        long retVal = 1L;
        int limit = this.myLowerBounds.length;
        for (int i = 0; i < limit; ++i) {
            retVal *= 1L + (long)(this.myUpperBounds[i] - this.myLowerBounds[i]);
        }
        return retVal;
    }

    int[] copyLowerBounds() {
        return COPY.invoke(this.myLowerBounds, (int[])this.myIntArrayPool.borrow());
    }

    int[] copyUpperBounds() {
        return COPY.invoke(this.myUpperBounds, (int[])this.myIntArrayPool.borrow());
    }

    NodeKey createLowerBranch(int branchIntegerIndex, double value, double objVal) {
        int[] tmpLBs = this.copyLowerBounds();
        int[] tmpUBs = this.copyUpperBounds();
        int floorValue = (int)Math.floor(this.feasible(branchIntegerIndex, value, false));
        int oldVal = tmpUBs[branchIntegerIndex];
        tmpUBs[branchIntegerIndex] = floorValue >= tmpUBs[branchIntegerIndex] && floorValue > tmpLBs[branchIntegerIndex] ? floorValue - 1 : floorValue;
        int newVal = tmpUBs[branchIntegerIndex];
        boolean changed = oldVal > 0 && newVal <= 0;
        return new NodeKey(tmpLBs, tmpUBs, this.sequence, branchIntegerIndex, value - (double)floorValue, objVal, changed, this.myIntArrayPool);
    }

    NodeKey createUpperBranch(int branchIntegerIndex, double value, double objVal) {
        int[] tmpLBs = this.copyLowerBounds();
        int[] tmpUBs = this.copyUpperBounds();
        int ceilValue = (int)Math.ceil(this.feasible(branchIntegerIndex, value, false));
        int oldVal = tmpLBs[branchIntegerIndex];
        tmpLBs[branchIntegerIndex] = ceilValue <= tmpLBs[branchIntegerIndex] && ceilValue < tmpUBs[branchIntegerIndex] ? ceilValue + 1 : ceilValue;
        int newVal = tmpLBs[branchIntegerIndex];
        boolean changed = oldVal < 0 && newVal >= 0;
        return new NodeKey(tmpLBs, tmpUBs, this.sequence, branchIntegerIndex, (double)ceilValue - value, objVal, changed, this.myIntArrayPool);
    }

    void dispose() {
        this.myIntArrayPool.giveBack(this.myLowerBounds);
        this.myIntArrayPool.giveBack(this.myUpperBounds);
    }

    void enforceBounds(ExpressionsBasedModel model, int idx, ModelStrategy strategy) {
        BigDecimal lowerBound = this.getLowerBound(idx);
        BigDecimal upperBound = this.getUpperBound(idx);
        Variable variable = model.getVariable(strategy.getIndex(idx));
        variable.lower((Comparable)lowerBound);
        variable.upper((Comparable)upperBound);
        BigDecimal value = variable.getValue();
        if (value != null) {
            variable.setValue(value);
        }
    }

    void enforceBounds(NodeSolver nodeSolver, ModelStrategy strategy) {
        BigDecimal lowerBound = this.getLowerBound(this.index);
        BigDecimal upperBound = this.getUpperBound(this.index);
        Variable variable = nodeSolver.getVariable(strategy.getIndex(this.index));
        variable.lower((Comparable)lowerBound);
        variable.upper((Comparable)upperBound);
        BigDecimal value = variable.getValue();
        if (value != null) {
            variable.setValue(value);
        }
        if (this.isSignChanged()) {
            nodeSolver.reset();
        } else {
            nodeSolver.update(variable);
        }
    }

    boolean equals(int[] lowerBounds, int[] upperBounds) {
        return Arrays.equals(this.myLowerBounds, lowerBounds) && Arrays.equals(this.myUpperBounds, upperBounds);
    }

    BigDecimal getLowerBound(int idx) {
        int tmpLower = this.myLowerBounds[idx];
        if (tmpLower != Integer.MIN_VALUE) {
            return new BigDecimal(tmpLower);
        }
        return null;
    }

    double getMinimumDisplacement(int idx, double value) {
        double feasibleValue = this.feasible(idx, value, true);
        return Math.abs(feasibleValue - Math.rint(feasibleValue));
    }

    BigDecimal getUpperBound(int idx) {
        int tmpUpper = this.myUpperBounds[idx];
        if (tmpUpper != Integer.MAX_VALUE) {
            return new BigDecimal(tmpUpper);
        }
        return null;
    }

    boolean isSignChanged() {
        return this.mySignChanged;
    }

    void setNodeState(ExpressionsBasedModel model, ModelStrategy strategy) {
        for (int i = 0; i < strategy.countIntegerVariables(); ++i) {
            this.enforceBounds(model, i, strategy);
        }
    }

    static final class IntArrayPool
    extends ObjectPool<int[]> {
        private final int myArrayLength;

        IntArrayPool(int arrayLength) {
            this.myArrayLength = arrayLength;
        }

        @Override
        protected int[] newObject() {
            return new int[this.myArrayLength];
        }

        @Override
        protected void reset(int[] object) {
        }
    }
}

