/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.hnsw.IntToIntFunction;

final class DocIdsWriter {
    private static final byte CONTINUOUS_IDS = -2;
    private static final byte DELTA_BPV_16 = 16;
    private static final byte BPV_21 = 21;
    private static final byte BPV_24 = 24;
    private static final byte BPV_32 = 32;
    private int[] scratch = new int[0];

    DocIdsWriter() {
    }

    byte calculateBlockEncoding(IntToIntFunction docIds, int count, int blockSize) {
        int[] r;
        int offset;
        int i;
        if (count == 0) {
            return -2;
        }
        int iterationLimit = count - blockSize + 1;
        int maxValue = 0;
        int maxMin2Max = 0;
        boolean continuousIds = true;
        for (i = 0; i < iterationLimit; i += blockSize) {
            offset = i;
            r = DocIdsWriter.sortedAndMaxAndMin2Max(d -> docIds.apply(offset + d), blockSize);
            continuousIds &= r[0] == 1;
            maxValue = Math.max(maxValue, r[1]);
            maxMin2Max = Math.max(maxMin2Max, r[2]);
        }
        if (i < count) {
            offset = i;
            r = DocIdsWriter.sortedAndMaxAndMin2Max(d -> docIds.apply(offset + d), count - i);
            continuousIds &= r[0] == 1;
            maxValue = Math.max(maxValue, r[1]);
            maxMin2Max = Math.max(maxMin2Max, r[2]);
        }
        if (continuousIds) {
            return -2;
        }
        if (maxMin2Max <= 65535) {
            return 16;
        }
        if (maxValue <= 0x1FFFFF) {
            return 21;
        }
        if (maxValue <= 0xFFFFFF) {
            return 24;
        }
        return 32;
    }

    void writeDocIds(IntToIntFunction docIds, int count, byte encoding, DataOutput out) throws IOException {
        if (count == 0) {
            return;
        }
        if (count > this.scratch.length) {
            this.scratch = new int[count];
        }
        int min = docIds.apply(0);
        for (int i = 1; i < count; ++i) {
            int current = docIds.apply(i);
            min = Math.min(min, current);
        }
        switch (encoding) {
            case -2: {
                DocIdsWriter.writeContinuousIds(docIds, count, out);
                break;
            }
            case 16: {
                this.writeDelta16(docIds, count, min, out);
                break;
            }
            case 21: {
                this.write21(docIds, count, min, out);
                break;
            }
            case 24: {
                this.write24(docIds, count, min, out);
                break;
            }
            case 32: {
                this.write32(docIds, count, min, out);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + encoding);
            }
        }
    }

    private static void writeContinuousIds(IntToIntFunction docIds, int count, DataOutput out) throws IOException {
        out.writeVInt(docIds.apply(0));
    }

    private void writeDelta16(IntToIntFunction docIds, int count, int min, DataOutput out) throws IOException {
        int i;
        for (int i2 = 0; i2 < count; ++i2) {
            this.scratch[i2] = docIds.apply(i2) - min;
        }
        out.writeVInt(min);
        int halfLen = count >> 1;
        for (i = 0; i < halfLen; ++i) {
            this.scratch[i] = this.scratch[halfLen + i] | this.scratch[i] << 16;
        }
        for (i = 0; i < halfLen; ++i) {
            out.writeInt(this.scratch[i]);
        }
        if ((count & 1) == 1) {
            out.writeShort((short)this.scratch[count - 1]);
        }
    }

    private void write21(IntToIntFunction docIds, int count, int min, DataOutput out) throws IOException {
        int i;
        int oneThird = DocIdsWriter.floorToMultipleOf16(count / 3);
        int numInts = oneThird * 2;
        for (i = 0; i < numInts; ++i) {
            this.scratch[i] = docIds.apply(i) << 11;
        }
        for (i = 0; i < oneThird; ++i) {
            int longIdx = i + numInts;
            int n = i;
            this.scratch[n] = this.scratch[n] | docIds.apply(longIdx) & 0x7FF;
            int n2 = i + oneThird;
            this.scratch[n2] = this.scratch[n2] | docIds.apply(longIdx) >>> 11 & 0x7FF;
        }
        for (i = 0; i < numInts; ++i) {
            out.writeInt(this.scratch[i]);
        }
        for (i = oneThird * 3; i < count - 2; i += 3) {
            out.writeLong((long)docIds.apply(i) | (long)docIds.apply(i + 1) << 21 | (long)docIds.apply(i + 2) << 42);
        }
        while (i < count) {
            out.writeShort((short)docIds.apply(i));
            out.writeByte((byte)(docIds.apply(i) >>> 16));
            ++i;
        }
    }

    private void write24(IntToIntFunction docIds, int count, int min, DataOutput out) throws IOException {
        int i;
        int quarter = count >> 2;
        int numInts = quarter * 3;
        for (i = 0; i < numInts; ++i) {
            this.scratch[i] = docIds.apply(i) << 8;
        }
        for (i = 0; i < quarter; ++i) {
            int longIdx = i + numInts;
            int n = i;
            this.scratch[n] = this.scratch[n] | docIds.apply(longIdx) & 0xFF;
            int n2 = i + quarter;
            this.scratch[n2] = this.scratch[n2] | docIds.apply(longIdx) >>> 8 & 0xFF;
            int n3 = i + quarter * 2;
            this.scratch[n3] = this.scratch[n3] | docIds.apply(longIdx) >>> 16;
        }
        for (i = 0; i < numInts; ++i) {
            out.writeInt(this.scratch[i]);
        }
        for (i = quarter << 2; i < count; ++i) {
            out.writeShort((short)docIds.apply(i));
            out.writeByte((byte)(docIds.apply(i) >>> 16));
        }
    }

    private void write32(IntToIntFunction docIds, int count, int min, DataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeInt(docIds.apply(i));
        }
    }

    private static int[] sortedAndMaxAndMin2Max(IntToIntFunction docIds, int count) {
        int min;
        boolean strictlySorted = true;
        int max = min = docIds.apply(0);
        for (int i = 1; i < count; ++i) {
            int current;
            int last = docIds.apply(i - 1);
            if (last >= (current = docIds.apply(i))) {
                strictlySorted = false;
            }
            min = Math.min(min, current);
            max = Math.max(max, current);
        }
        int min2max = max - min + 1;
        return new int[]{strictlySorted && min2max == count ? 1 : 0, max, min2max};
    }

    void writeDocIds(IntToIntFunction docIds, int count, DataOutput out) throws IOException {
        int min;
        if (count == 0) {
            return;
        }
        if (count > this.scratch.length) {
            this.scratch = new int[count];
        }
        boolean strictlySorted = true;
        int max = min = docIds.apply(0);
        for (int i = 1; i < count; ++i) {
            int current;
            int last = docIds.apply(i - 1);
            if (last >= (current = docIds.apply(i))) {
                strictlySorted = false;
            }
            min = Math.min(min, current);
            max = Math.max(max, current);
        }
        int min2max = max - min + 1;
        if (strictlySorted && min2max == count) {
            out.writeByte((byte)-2);
            DocIdsWriter.writeContinuousIds(docIds, count, out);
            return;
        }
        if (min2max <= 65535) {
            out.writeByte((byte)16);
            this.writeDelta16(docIds, count, min, out);
        } else if (max <= 0x1FFFFF) {
            out.writeByte((byte)21);
            this.write21(docIds, count, min, out);
        } else if (max <= 0xFFFFFF) {
            out.writeByte((byte)24);
            this.write24(docIds, count, min, out);
        } else {
            out.writeByte((byte)32);
            this.write32(docIds, count, min, out);
        }
    }

    void readInts(IndexInput in, int count, byte encoding, int[] docIDs) throws IOException {
        if (count == 0) {
            return;
        }
        if (count > this.scratch.length) {
            this.scratch = new int[count];
        }
        switch (encoding) {
            case -2: {
                DocIdsWriter.readContinuousIds(in, count, docIDs);
                break;
            }
            case 16: {
                DocIdsWriter.readDelta16(in, count, docIDs);
                break;
            }
            case 21: {
                this.readInts21(in, count, docIDs);
                break;
            }
            case 24: {
                this.readInts24(in, count, docIDs);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count, docIDs);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + encoding);
            }
        }
    }

    void readInts(IndexInput in, int count, int[] docIDs) throws IOException {
        if (count == 0) {
            return;
        }
        if (count > this.scratch.length) {
            this.scratch = new int[count];
        }
        byte bpv = in.readByte();
        this.readInts(in, count, bpv, docIDs);
    }

    private static void readContinuousIds(IndexInput in, int count, int[] docIDs) throws IOException {
        int start = in.readVInt();
        for (int i = 0; i < count; ++i) {
            docIDs[i] = start + i;
        }
    }

    private static void readDelta16(IndexInput in, int count, int[] docIds) throws IOException {
        int min = in.readVInt();
        int half = count >> 1;
        in.readInts(docIds, 0, half);
        DocIdsWriter.decode16(docIds, half, min);
        for (int i = half << 1; i < count; ++i) {
            docIds[i] = Short.toUnsignedInt(in.readShort()) + min;
        }
    }

    private static void decode16(int[] docIDs, int half, int min) {
        for (int i = 0; i < half; ++i) {
            int l = docIDs[i];
            docIDs[i] = (l >>> 16) + min;
            docIDs[i + half] = (l & 0xFFFF) + min;
        }
    }

    private static int floorToMultipleOf16(int n) {
        assert (n >= 0);
        return n & 0xFFFFFFF0;
    }

    private void readInts21(IndexInput in, int count, int[] docIDs) throws IOException {
        int i;
        int oneThird = DocIdsWriter.floorToMultipleOf16(count / 3);
        int numInts = oneThird << 1;
        in.readInts(this.scratch, 0, numInts);
        DocIdsWriter.decode21(docIDs, this.scratch, oneThird, numInts);
        for (i = oneThird * 3; i < count - 2; i += 3) {
            long l = in.readLong();
            docIDs[i] = (int)(l & 0x1FFFFFL);
            docIDs[i + 1] = (int)(l >>> 21 & 0x1FFFFFL);
            docIDs[i + 2] = (int)(l >>> 42);
        }
        while (i < count) {
            docIDs[i] = in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
            ++i;
        }
    }

    private static void decode21(int[] docIds, int[] scratch, int oneThird, int numInts) {
        int i;
        for (i = 0; i < numInts; ++i) {
            docIds[i] = scratch[i] >>> 11;
        }
        for (i = 0; i < oneThird; ++i) {
            docIds[i + numInts] = scratch[i] & 0x7FF | (scratch[i + oneThird] & 0x7FF) << 11;
        }
    }

    private void readInts24(IndexInput in, int count, int[] docIDs) throws IOException {
        int quarter = count >> 2;
        int numInts = quarter * 3;
        in.readInts(this.scratch, 0, numInts);
        DocIdsWriter.decode24(docIDs, this.scratch, quarter, numInts);
        for (int i = quarter << 2; i < count; ++i) {
            docIDs[i] = in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
        }
    }

    private static void decode24(int[] docIDs, int[] scratch, int quarter, int numInts) {
        int i;
        for (i = 0; i < numInts; ++i) {
            docIDs[i] = scratch[i] >>> 8;
        }
        for (i = 0; i < quarter; ++i) {
            docIDs[i + numInts] = scratch[i] & 0xFF | (scratch[i + quarter] & 0xFF) << 8 | (scratch[i + quarter * 2] & 0xFF) << 16;
        }
    }

    private static void readInts32(IndexInput in, int count, int[] docIDs) throws IOException {
        in.readInts(docIDs, 0, count);
    }
}

