/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import org.elasticsearch.simdvec.ESVectorUtil;

public class BQSpaceUtils {
    public static final short B_QUERY = 4;

    public static void transposeHalfByte(byte[] q, byte[] quantQueryByte) {
        int upperByte;
        int upperMiddleByte;
        int lowerMiddleByte;
        int lowerByte;
        int limit = q.length - 7;
        int i = 0;
        int index = 0;
        while (i < limit) {
            assert (q[i] >= 0 && q[i] <= 15);
            assert (q[i + 1] >= 0 && q[i + 1] <= 15);
            assert (q[i + 2] >= 0 && q[i + 2] <= 15);
            assert (q[i + 3] >= 0 && q[i + 3] <= 15);
            assert (q[i + 4] >= 0 && q[i + 4] <= 15);
            assert (q[i + 5] >= 0 && q[i + 5] <= 15);
            assert (q[i + 6] >= 0 && q[i + 6] <= 15);
            assert (q[i + 7] >= 0 && q[i + 7] <= 15);
            lowerByte = (q[i] & 1) << 7 | (q[i + 1] & 1) << 6 | (q[i + 2] & 1) << 5 | (q[i + 3] & 1) << 4 | (q[i + 4] & 1) << 3 | (q[i + 5] & 1) << 2 | (q[i + 6] & 1) << 1 | q[i + 7] & 1;
            lowerMiddleByte = (q[i] >> 1 & 1) << 7 | (q[i + 1] >> 1 & 1) << 6 | (q[i + 2] >> 1 & 1) << 5 | (q[i + 3] >> 1 & 1) << 4 | (q[i + 4] >> 1 & 1) << 3 | (q[i + 5] >> 1 & 1) << 2 | (q[i + 6] >> 1 & 1) << 1 | q[i + 7] >> 1 & 1;
            upperMiddleByte = (q[i] >> 2 & 1) << 7 | (q[i + 1] >> 2 & 1) << 6 | (q[i + 2] >> 2 & 1) << 5 | (q[i + 3] >> 2 & 1) << 4 | (q[i + 4] >> 2 & 1) << 3 | (q[i + 5] >> 2 & 1) << 2 | (q[i + 6] >> 2 & 1) << 1 | q[i + 7] >> 2 & 1;
            upperByte = (q[i] >> 3 & 1) << 7 | (q[i + 1] >> 3 & 1) << 6 | (q[i + 2] >> 3 & 1) << 5 | (q[i + 3] >> 3 & 1) << 4 | (q[i + 4] >> 3 & 1) << 3 | (q[i + 5] >> 3 & 1) << 2 | (q[i + 6] >> 3 & 1) << 1 | q[i + 7] >> 3 & 1;
            quantQueryByte[index] = (byte)lowerByte;
            quantQueryByte[index + quantQueryByte.length / 4] = (byte)lowerMiddleByte;
            quantQueryByte[index + quantQueryByte.length / 2] = (byte)upperMiddleByte;
            quantQueryByte[index + 3 * quantQueryByte.length / 4] = (byte)upperByte;
            i += 8;
            ++index;
        }
        if (i == q.length) {
            return;
        }
        lowerByte = 0;
        lowerMiddleByte = 0;
        upperMiddleByte = 0;
        upperByte = 0;
        int j = 7;
        while (i < q.length) {
            lowerByte |= (q[i] & 1) << j;
            lowerMiddleByte |= (q[i] >> 1 & 1) << j;
            upperMiddleByte |= (q[i] >> 2 & 1) << j;
            upperByte |= (q[i] >> 3 & 1) << j;
            --j;
            ++i;
        }
        quantQueryByte[index] = (byte)lowerByte;
        quantQueryByte[index + quantQueryByte.length / 4] = (byte)lowerMiddleByte;
        quantQueryByte[index + quantQueryByte.length / 2] = (byte)upperMiddleByte;
        quantQueryByte[index + 3 * quantQueryByte.length / 4] = (byte)upperByte;
    }

    public static void transposeHalfByteLegacy(byte[] q, byte[] quantQueryByte) {
        int i = 0;
        while (i < q.length) {
            assert (q[i] >= 0 && q[i] <= 15);
            int lowerByte = 0;
            int lowerMiddleByte = 0;
            int upperMiddleByte = 0;
            int upperByte = 0;
            for (int j = 7; j >= 0 && i < q.length; ++i, --j) {
                lowerByte |= (q[i] & 1) << j;
                lowerMiddleByte |= (q[i] >> 1 & 1) << j;
                upperMiddleByte |= (q[i] >> 2 & 1) << j;
                upperByte |= (q[i] >> 3 & 1) << j;
            }
            int index = (i + 7) / 8 - 1;
            quantQueryByte[index] = (byte)lowerByte;
            quantQueryByte[index + quantQueryByte.length / 4] = (byte)lowerMiddleByte;
            quantQueryByte[index + quantQueryByte.length / 2] = (byte)upperMiddleByte;
            quantQueryByte[index + 3 * quantQueryByte.length / 4] = (byte)upperByte;
        }
    }

    public static void transposeHalfByte(int[] q, byte[] quantQueryByte) {
        ESVectorUtil.transposeHalfByte((int[])q, (byte[])quantQueryByte);
    }

    public static void transposeHalfByteLegacy(int[] q, byte[] quantQueryByte) {
        int i = 0;
        while (i < q.length) {
            assert (q[i] >= 0 && q[i] <= 15);
            int lowerByte = 0;
            int lowerMiddleByte = 0;
            int upperMiddleByte = 0;
            int upperByte = 0;
            for (int j = 7; j >= 0 && i < q.length; ++i, --j) {
                lowerByte |= (q[i] & 1) << j;
                lowerMiddleByte |= (q[i] >> 1 & 1) << j;
                upperMiddleByte |= (q[i] >> 2 & 1) << j;
                upperByte |= (q[i] >> 3 & 1) << j;
            }
            int index = (i + 7) / 8 - 1;
            quantQueryByte[index] = (byte)lowerByte;
            quantQueryByte[index + quantQueryByte.length / 4] = (byte)lowerMiddleByte;
            quantQueryByte[index + quantQueryByte.length / 2] = (byte)upperMiddleByte;
            quantQueryByte[index + 3 * quantQueryByte.length / 4] = (byte)upperByte;
        }
    }
}

