/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class UpdateDesiredNodesRequest
extends AcknowledgedRequest<UpdateDesiredNodesRequest> {
    private static final TransportVersion DRY_RUN_VERSION = TransportVersions.V_8_4_0;
    private final String historyID;
    private final long version;
    private final List<DesiredNode> nodes;
    private final boolean dryRun;
    public static final ParseField NODES_FIELD = new ParseField("nodes", new String[0]);
    private static final ConstructingObjectParser<List<DesiredNode>, Void> PARSER = new ConstructingObjectParser("update_desired_nodes_request", false, (args, unused) -> (List)args[0]);

    public UpdateDesiredNodesRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, String historyID, long version, List<DesiredNode> nodes, boolean dryRun) {
        super(masterNodeTimeout, ackTimeout);
        assert (historyID != null);
        assert (nodes != null);
        this.historyID = historyID;
        this.version = version;
        this.nodes = nodes;
        this.dryRun = dryRun;
    }

    public UpdateDesiredNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.historyID = in.readString();
        this.version = in.readLong();
        this.nodes = in.readCollectionAsList(DesiredNode::readFrom);
        this.dryRun = in.getTransportVersion().onOrAfter(DRY_RUN_VERSION) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.historyID);
        out.writeLong(this.version);
        out.writeCollection(this.nodes);
        if (out.getTransportVersion().onOrAfter(DRY_RUN_VERSION)) {
            out.writeBoolean(this.dryRun);
        }
    }

    public static UpdateDesiredNodesRequest fromXContent(TimeValue masterNodeTimeout, TimeValue ackTimeout, String historyID, long version, boolean dryRun, XContentParser parser) throws IOException {
        List nodes = (List)PARSER.parse(parser, null);
        return new UpdateDesiredNodesRequest(masterNodeTimeout, ackTimeout, historyID, version, nodes, dryRun);
    }

    public String getHistoryID() {
        return this.historyID;
    }

    public long getVersion() {
        return this.version;
    }

    public List<DesiredNode> getNodes() {
        return this.nodes;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDesiredNodesRequest that = (UpdateDesiredNodesRequest)o;
        return this.version == that.version && Objects.equals(this.historyID, that.historyID) && Objects.equals(this.nodes, that.nodes) && Objects.equals(this.dryRun, that.dryRun);
    }

    public int hashCode() {
        return Objects.hash(this.historyID, this.version, this.nodes, this.dryRun);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.historyID.isBlank()) {
            validationException = ValidateActions.addValidationError("historyID should not be empty", null);
        }
        if (this.version < 0L) {
            validationException = ValidateActions.addValidationError("version must be positive", validationException);
        }
        if (!this.nodes.stream().anyMatch(DesiredNode::hasMasterRole)) {
            validationException = ValidateActions.addValidationError("nodes must contain at least one master node", validationException);
        }
        return validationException;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> DesiredNode.fromXContent(p), NODES_FIELD);
    }
}

