/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gpu.codec;

import com.nvidia.cuvs.CagraIndexParams;
import com.nvidia.cuvs.CuVSIvfPqIndexParams;
import com.nvidia.cuvs.CuVSIvfPqParams;
import com.nvidia.cuvs.CuVSIvfPqSearchParams;

class CuVSIvfPqParamsFactory {
    CuVSIvfPqParamsFactory() {
    }

    static CuVSIvfPqParams create(int numVectors, int dims, CagraIndexParams.CuvsDistanceType distanceType, int efConstruction) {
        long nRows = numVectors;
        long nFeatures = dims;
        if (nRows <= 0L || nFeatures <= 0L) {
            throw new IllegalArgumentException("Dataset dimensions must be positive: rows=" + nRows + ", features=" + nFeatures);
        }
        return CuVSIvfPqParamsFactory.createFromDimensions(nRows, nFeatures, distanceType, efConstruction);
    }

    static CuVSIvfPqParams createFromDimensions(long nRows, long nFeatures, CagraIndexParams.CuvsDistanceType distanceType, int efConstruction) {
        int pqBits;
        int pqDim;
        if (nRows <= 0L || nFeatures <= 0L) {
            throw new IllegalArgumentException("Dataset dimensions must be positive: rows=" + nRows + ", features=" + nFeatures);
        }
        if (nFeatures <= 32L) {
            pqDim = 16;
            pqBits = 8;
        } else {
            pqBits = 4;
            pqDim = nFeatures <= 64L ? 32 : (nFeatures <= 128L ? 64 : (nFeatures <= 192L ? 96 : (int)CuVSIvfPqParamsFactory.roundUpSafe(nFeatures / 2L, 128L)));
        }
        int nLists = Math.max(1, (int)(nRows / 2000L));
        double kMinPointsPerCluster = 32.0;
        double minKmeansTrainsetPoints = 32.0 * (double)nLists;
        double maxKmeansTrainsetFraction = 1.0;
        double minKmeansTrainsetFraction = Math.min(1.0, minKmeansTrainsetPoints / (double)nRows);
        double kmeansTrainsetFraction = Math.clamp(1.0 / Math.sqrt((double)nRows * 1.0E-5), minKmeansTrainsetFraction, 1.0);
        int nProbes = Math.round((float)(2.0 + Math.sqrt(nLists) / 20.0 + (double)efConstruction / 16.0));
        CuVSIvfPqIndexParams indexParams = new CuVSIvfPqIndexParams.Builder().withMetric(distanceType).withPqDim(pqDim).withPqBits(pqBits).withNLists(nLists).withKmeansNIters(10).withKmeansTrainsetFraction(kmeansTrainsetFraction).withCodebookKind(CagraIndexParams.CodebookGen.PER_SUBSPACE).build();
        CuVSIvfPqSearchParams searchParams = new CuVSIvfPqSearchParams.Builder().withNProbes(nProbes).withLutDtype(CagraIndexParams.CudaDataType.CUDA_R_16F).withInternalDistanceDtype(CagraIndexParams.CudaDataType.CUDA_R_16F).build();
        return new CuVSIvfPqParams.Builder().withCuVSIvfPqIndexParams(indexParams).withCuVSIvfPqSearchParams(searchParams).withRefinementRate(1.0f).build();
    }

    private static long roundUpSafe(long value, long divisor) {
        if (divisor <= 0L) {
            throw new IllegalArgumentException("divisor must be positive");
        }
        return (value + divisor - 1L) / divisor * divisor;
    }
}

