/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.Closeable;
import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.IOUtils;

public class BlockStreamInput
extends NamedWriteableAwareStreamInput {
    private final BlockFactory blockFactory;
    private Block lastConstantNullBlock;

    public BlockStreamInput(StreamInput delegate, BlockFactory blockFactory) {
        super(delegate, delegate.namedWriteableRegistry());
        this.blockFactory = blockFactory;
    }

    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    Block readConstantNullBlock() throws IOException {
        int positions = this.readVInt();
        if (this.lastConstantNullBlock == null) {
            this.lastConstantNullBlock = this.blockFactory.newConstantNullBlock(positions);
        } else if (this.lastConstantNullBlock.getPositionCount() != positions) {
            this.lastConstantNullBlock.decRef();
            this.lastConstantNullBlock = this.blockFactory.newConstantNullBlock(positions);
        }
        this.lastConstantNullBlock.incRef();
        return this.lastConstantNullBlock;
    }

    public void close() throws IOException {
        IOUtils.close((Closeable)((Object)this.lastConstantNullBlock));
    }
}

