/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.ToMask;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

record FilteredAggregatorFunction(AggregatorFunction next, EvalOperator.ExpressionEvaluator filter) implements AggregatorFunction
{
    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.isConstant() || !mask.getBoolean(0)) {
            throw new UnsupportedOperationException("can't filter twice");
        }
        try (BooleanBlock filterResult = (BooleanBlock)this.filter.eval(page);
             ToMask m = filterResult.toMask();){
            this.next.addRawInput(page, m.mask());
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        this.next.addIntermediateInput(page);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.next.evaluateIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        this.next.evaluateFinal(blocks, offset, driverContext);
    }

    @Override
    public int intermediateBlockCount() {
        return this.next.intermediateBlockCount();
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.next, this.filter});
    }
}

