/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.geoip;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.ingest.EnterpriseGeoIpTask;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;

public class EnterpriseGeoIpDownloaderLicenseListener
implements LicenseStateListener,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(EnterpriseGeoIpDownloaderLicenseListener.class);
    static final String INGEST_GEOIP_CUSTOM_METADATA_TYPE = "ingest_geoip";
    private final PersistentTasksService persistentTasksService;
    private final ClusterService clusterService;
    private final XPackLicenseState licenseState;
    private static final LicensedFeature.Momentary ENTERPRISE_GEOIP_FEATURE = LicensedFeature.momentary(null, (String)"enterprise_geoip_downloader", (License.OperationMode)License.OperationMode.PLATINUM);
    private final ConcurrentMap<ProjectId, Boolean> licenseIsValid = new ConcurrentHashMap<ProjectId, Boolean>();
    private final ConcurrentMap<ProjectId, Boolean> hasIngestGeoIpMetadata = new ConcurrentHashMap<ProjectId, Boolean>();
    private final ProjectResolver projectResolver;
    private volatile boolean licenseStateListenerRegistered;

    protected EnterpriseGeoIpDownloaderLicenseListener(Client client, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ProjectResolver projectResolver) {
        this.persistentTasksService = new PersistentTasksService(clusterService, threadPool, client);
        this.clusterService = clusterService;
        this.licenseState = licenseState;
        this.projectResolver = projectResolver;
    }

    public void init() {
        this.listenForLicenseStateChanges();
        this.clusterService.addListener((ClusterStateListener)this);
    }

    void listenForLicenseStateChanges() {
        assert (!this.licenseStateListenerRegistered) : "listenForLicenseStateChanges() should only be called once";
        this.licenseStateListenerRegistered = true;
        this.licenseState.addListener((LicenseStateListener)this);
    }

    public void licenseStateChanged() {
        this.licenseIsValid.put(ProjectId.DEFAULT, ENTERPRISE_GEOIP_FEATURE.checkWithoutTracking(this.licenseState));
        boolean isLocalNodeMaster = this.clusterService.state().nodes().isLocalNodeElectedMaster();
        this.maybeUpdateTaskState(ProjectId.DEFAULT, isLocalNodeMaster);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean masterNodeChanged = !Objects.equals(event.state().nodes().getMasterNode(), event.previousState().nodes().getMasterNode());
        boolean isLocalNodeMaster = event.state().nodes().isLocalNodeElectedMaster();
        event.state().metadata().projects().values().forEach(projectMetadata -> {
            boolean ingestGeoIpCustomMetaChangedInEvent;
            ProjectId projectId = projectMetadata.id();
            boolean hasMetadata = projectMetadata.custom(INGEST_GEOIP_CUSTOM_METADATA_TYPE) != null;
            this.hasIngestGeoIpMetadata.put(projectId, hasMetadata);
            boolean bl = ingestGeoIpCustomMetaChangedInEvent = event.metadataChanged() && event.customMetadataChanged(projectId, INGEST_GEOIP_CUSTOM_METADATA_TYPE);
            if (ingestGeoIpCustomMetaChangedInEvent || masterNodeChanged && this.hasIngestGeoIpMetadata.getOrDefault(projectId, false).booleanValue()) {
                this.maybeUpdateTaskState(projectId, isLocalNodeMaster);
            }
        });
    }

    private void maybeUpdateTaskState(ProjectId projectId, boolean isLocalNodeMaster) {
        if (isLocalNodeMaster) {
            if (this.licenseIsValid.getOrDefault(projectId, false).booleanValue()) {
                if (this.hasIngestGeoIpMetadata.getOrDefault(projectId, false).booleanValue()) {
                    this.ensureTaskStarted(projectId);
                }
            } else {
                this.ensureTaskStopped(projectId);
            }
        }
    }

    private void ensureTaskStarted(ProjectId projectId) {
        assert (this.licenseIsValid.getOrDefault(projectId, false).booleanValue()) : "Task should never be started without valid license";
        this.persistentTasksService.sendProjectStartRequest(projectId, EnterpriseGeoIpDownloaderLicenseListener.getTaskId(projectId, this.projectResolver.supportsMultipleProjects()), "enterprise-geoip-downloader", (PersistentTaskParams)new EnterpriseGeoIpTask.EnterpriseGeoIpTaskParams(), MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> logger.debug("Started enterprise geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceAlreadyExistsException)) {
                logger.error("failed to create enterprise geoip downloader task", (Throwable)e);
            }
        }));
    }

    private void ensureTaskStopped(ProjectId projectId) {
        ActionListener listener = ActionListener.wrap(r -> logger.debug("Stopped enterprise geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceNotFoundException)) {
                logger.error("failed to remove enterprise geoip downloader task", (Throwable)e);
            }
        });
        this.persistentTasksService.sendProjectRemoveRequest(projectId, EnterpriseGeoIpDownloaderLicenseListener.getTaskId(projectId, this.projectResolver.supportsMultipleProjects()), MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, listener);
    }

    protected static String getTaskId(ProjectId projectId, boolean supportsMultipleProjects) {
        return supportsMultipleProjects ? String.valueOf(projectId) + "/enterprise-geoip-downloader" : "enterprise-geoip-downloader";
    }
}

