/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.otel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.otel.EcsOTelResourceAttributes;

public class NormalizeForStreamProcessor
extends AbstractProcessor {
    public static final String TYPE = "normalize_for_stream";
    static final Map<String, String> RENAME_KEYS = Map.ofEntries(Map.entry("span.id", "span_id"), Map.entry("message", "body.text"), Map.entry("log.level", "severity_text"), Map.entry("trace.id", "trace_id"));
    private static final Set<String> KEEP_KEYS;
    private static final Logger log;
    private static final String ATTRIBUTES_KEY = "attributes";
    private static final String RESOURCE_KEY = "resource";
    private static final String SCOPE_KEY = "scope";
    private static final String BODY_KEY = "body";
    private static final String TEXT_KEY = "text";
    private static final String STRUCTURED_KEY = "structured";

    NormalizeForStreamProcessor(String tag, String description) {
        super(tag, description);
    }

    public String getType() {
        return TYPE;
    }

    public IngestDocument execute(IngestDocument document) {
        Map source = document.getSource();
        boolean isOTel = NormalizeForStreamProcessor.isOTelDocument(source);
        if (isOTel) {
            return document;
        }
        HashMap<String, Map> body = null;
        try {
            String message = (String)document.getFieldValue("message", String.class, true);
            if (message != null && (message = message.trim()).startsWith("{") && message.endsWith("}")) {
                Object parsedMessage = JsonProcessor.apply((Object)message, (boolean)true, (boolean)true);
                if (parsedMessage instanceof Map) {
                    Map messageMap = (Map)parsedMessage;
                    if (messageMap.containsKey("@timestamp")) {
                        log.debug("Handling structured message with @timestamp field, assuming ECS-JSON format, merging into root document");
                        source.remove("message");
                        JsonProcessor.recursiveMerge((Map)source, (Map)messageMap);
                    } else {
                        log.debug("Handling structured message without @timestamp field, assuming non-ECS format, moving to 'body.structured'");
                        body = new HashMap<String, Map>();
                        body.put(STRUCTURED_KEY, messageMap);
                        source.remove("message");
                    }
                } else {
                    log.debug("Structured message is not a JSON object, keeping it as a string in 'body.text' field: {}", (Object)message);
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed to parse structured message, keeping it as a string in 'body.text' field", (Throwable)e);
        }
        HashMap newAttributes = new HashMap();
        for (String keepKey : KEEP_KEYS) {
            if (keepKey.equals("@timestamp") || !source.containsKey(keepKey)) continue;
            newAttributes.put(keepKey, source.remove(keepKey));
        }
        if (body != null) {
            source.put(BODY_KEY, body);
        }
        source.put(ATTRIBUTES_KEY, newAttributes);
        NormalizeForStreamProcessor.renameSpecialKeys(document);
        Iterator sourceItr = source.entrySet().iterator();
        while (sourceItr.hasNext()) {
            Map.Entry entry = sourceItr.next();
            if (KEEP_KEYS.contains(entry.getKey())) continue;
            newAttributes.put((String)entry.getKey(), entry.getValue());
            sourceItr.remove();
        }
        Map flattenAttributes = Maps.flatten(newAttributes, (boolean)false, (boolean)false);
        source.put(ATTRIBUTES_KEY, flattenAttributes);
        HashMap<String, HashMap<String, Object>> newResource = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> newResourceAttributes = new HashMap<String, Object>();
        newResource.put(ATTRIBUTES_KEY, newResourceAttributes);
        source.put(RESOURCE_KEY, newResource);
        NormalizeForStreamProcessor.moveResourceAttributes(flattenAttributes, newResourceAttributes);
        return document;
    }

    static boolean isOTelDocument(Map<String, Object> source) {
        Object resource = source.get(RESOURCE_KEY);
        if (resource instanceof Map) {
            Map resourceMap = (Map)resource;
            Object resourceAttributes = resourceMap.get(ATTRIBUTES_KEY);
            if (resourceAttributes != null && !(resourceAttributes instanceof Map)) {
                return false;
            }
        } else {
            return false;
        }
        Object scope = source.get(SCOPE_KEY);
        if (scope != null && !(scope instanceof Map)) {
            return false;
        }
        Object attributes = source.get(ATTRIBUTES_KEY);
        if (attributes != null && !(attributes instanceof Map)) {
            return false;
        }
        Object body = source.get(BODY_KEY);
        if (body != null) {
            if (body instanceof Map) {
                Map bodyMap = (Map)body;
                Object bodyText = bodyMap.get(TEXT_KEY);
                if (bodyText != null && !(bodyText instanceof String)) {
                    return false;
                }
                Object bodyStructured = bodyMap.get(STRUCTURED_KEY);
                return !(bodyStructured instanceof String);
            }
            return false;
        }
        return true;
    }

    static void renameSpecialKeys(IngestDocument document) {
        switch (document.getCurrentAccessPatternSafe()) {
            case CLASSIC: {
                NormalizeForStreamProcessor.renameSpecialKeysClassic(document);
                break;
            }
            case FLEXIBLE: {
                NormalizeForStreamProcessor.renameSpecialKeysFlexible(document);
            }
        }
    }

    static void renameSpecialKeysClassic(IngestDocument document) {
        RENAME_KEYS.forEach((nonOtelName, otelName) -> {
            Map source;
            boolean fieldExists = false;
            Object value = null;
            if (document.hasField(nonOtelName)) {
                String parentName;
                Map parent;
                fieldExists = true;
                value = document.getFieldValue(nonOtelName, Object.class, true);
                document.removeField(nonOtelName);
                int lastDot = nonOtelName.lastIndexOf(46);
                while (lastDot > 0 && (parent = (Map)document.getFieldValue(parentName = nonOtelName.substring(0, lastDot), Map.class)).isEmpty()) {
                    document.removeField(parentName);
                    lastDot = parentName.lastIndexOf(46);
                }
            } else if (nonOtelName.contains(".") && (source = document.getSource()).containsKey(nonOtelName)) {
                fieldExists = true;
                value = source.remove(nonOtelName);
            }
            if (fieldExists) {
                document.setFieldValue(otelName, value);
            }
        });
    }

    static void renameSpecialKeysFlexible(IngestDocument document) {
        RENAME_KEYS.forEach((nonOtelName, otelName) -> {
            boolean fieldExists = false;
            Object value = null;
            if (document.hasField(nonOtelName)) {
                fieldExists = true;
                value = document.getFieldValue(nonOtelName, Object.class, true);
                document.removeField(nonOtelName);
                int lastDot = nonOtelName.lastIndexOf(46);
                while (lastDot > 0) {
                    String parentName = nonOtelName.substring(0, lastDot);
                    Map parent = (Map)document.getFieldValue(parentName, Map.class, true);
                    if (parent != null) {
                        if (!parent.isEmpty()) break;
                        document.removeField(parentName);
                    }
                    lastDot = parentName.lastIndexOf(46);
                }
            }
            if (fieldExists) {
                HashMap<String, Object> source = document.getSource();
                String remainingPath = otelName;
                int dot = remainingPath.indexOf(46);
                while (dot > 0) {
                    String fieldName = remainingPath.substring(0, dot);
                    remainingPath = remainingPath.substring(dot + 1);
                    Object existingParent = source.get(fieldName);
                    if (existingParent instanceof Map) {
                        Map castAssignment = (Map)existingParent;
                        source = castAssignment;
                    } else {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        source.put(fieldName, map);
                        source = map;
                    }
                    dot = remainingPath.indexOf(46);
                }
                source.put(remainingPath, value);
            }
        });
    }

    private static void moveResourceAttributes(Map<String, Object> attributes, Map<String, Object> resourceAttributes) {
        Set<String> ecsResourceFields = EcsOTelResourceAttributes.LATEST;
        Iterator<Map.Entry<String, Object>> attributeIterator = attributes.entrySet().iterator();
        while (attributeIterator.hasNext()) {
            Map.Entry<String, Object> entry = attributeIterator.next();
            if (!ecsResourceFields.contains(entry.getKey())) continue;
            resourceAttributes.put(entry.getKey(), entry.getValue());
            attributeIterator.remove();
        }
    }

    static {
        log = LogManager.getLogger(NormalizeForStreamProcessor.class);
        HashSet<String> keepKeys = new HashSet<String>(Set.of("@timestamp", ATTRIBUTES_KEY, RESOURCE_KEY));
        HashSet<String> renamedTopLevelFields = new HashSet<String>();
        for (String value : RENAME_KEYS.values()) {
            String[] values;
            String workingKey = null;
            for (String part : values = value.split("\\.")) {
                workingKey = workingKey == null ? part : workingKey + "." + part;
                renamedTopLevelFields.add(workingKey);
            }
        }
        keepKeys.addAll(renamedTopLevelFields);
        KEEP_KEYS = Set.copyOf(keepKeys);
    }

    public static final class Factory
    implements Processor.Factory {
        public Processor create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config, ProjectId projectId) {
            return new NormalizeForStreamProcessor(tag, description);
        }
    }
}

